/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.common.client.DateHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class NCMClientVerifyHelper {
    public static final int DEFAULT_CURRENCY_PREC = 2;
    public static final int DEFAULT_RATE_PRECISION = 5;
    public static final int ONE_SECOND = 1000;
    public static final int ONE_MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    public static final int MAX_YEAR = 2999;
    public static final BigDecimal FIRST_VERSION = new BigDecimal("0.9");
    public static final BigDecimal CURR_VERSION = new BigDecimal("0");
    public static final Integer TRUE = 1;
    public static final Integer FALSE = 0;
    public static final int MsgMaxLength = 2000;
    public static final String INTTERM_OTHER = "jhNyIgEWEADgAAr6wKgSC61eI6Y=";
    public static final String GENERAL_LOCAL_CURRENCY = "11111111-1111-1111-1111-111111111111DEB58FDC";
    public static final String GENERAL_REPORT_CURRENCY = "22222222-2222-2222-2222-222222222222DEB58FDC";
    public static final String datafilter = "datafilter";
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final Date MAX_DATE = new Date(1099, 11, 30);
    public static final BigDecimal ONE = new BigDecimal("1");
    public static final BigDecimal _ONE = new BigDecimal("-1");
    public static final BigDecimal TEN = new BigDecimal("10");
    public static final BigDecimal _TEN = new BigDecimal("-10");
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    public static final BigDecimal _ONE_HUNDRED = new BigDecimal("-100");
    public static final BigDecimal ONE_THOUSAND = new BigDecimal("1000");
    public static final BigDecimal _ONE_THOUSAND = new BigDecimal("-1000");
    public static final BigDecimal TEN_THOUSAND = new BigDecimal("10000");
    public static final BigDecimal _TEN_THOUSAND = new BigDecimal("-10000");
    public static final BigDecimal ONE_HUNDRED_MILLION = new BigDecimal("100000000");
    public static final BigDecimal _ONE_HUNDRED_MILLION = new BigDecimal("-100000000");
    private static String path = "com.kingdee.eas.ncm.common.CMBillResource";
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.99");

    public static void verifyInput(CoreUIObject ui, String resourcePath, KDTable kdtEntries, IRow row, int i, String msg) {
        if (NCMClientVerifyHelper.isEmpty(row.getCell(i).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), i);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            NCMClientVerifyHelper.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key, boolean ifEntries) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            if (ifEntries) {
                NCMClientVerifyHelper.verifyInput(ui, kdtEntries, row, key, true);
                continue;
            }
            NCMClientVerifyHelper.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (NCMClientVerifyHelper.isEmpty(row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = headValue + " " + EASResource.getString((String)path, (String)"CanNotBeNull");
            msg = msg.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key, boolean ifEntries) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (NCMClientVerifyHelper.isEmpty(row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String entries = EASResource.getString((String)path, (String)"entries");
            String msg = entries + headValue + " " + EASResource.getString((String)path, (String)"CanNotBeNull");
            msg = msg.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyInputIsZero(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        Object obj = row.getCell(key).getValue();
        if (!NCMClientVerifyHelper.isEmpty(obj) && obj instanceof BigDecimal && NCMClientVerifyHelper.isZERO((BigDecimal)obj)) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = headValue + " " + EASResource.getString((String)path, (String)"CanNotBeZero");
            msg = msg.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyInputIsMaxValue(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        Object obj = row.getCell(key).getValue();
        if (!NCMClientVerifyHelper.isEmpty(obj) && obj instanceof BigDecimal && ((BigDecimal)obj).compareTo(MAX_VALUE) == 1) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = headValue + " " + EASResource.getString((String)path, (String)"CanNotBeZero");
            msg = msg.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTable kdtEntries) {
        if (kdtEntries == null || kdtEntries.getRowCount() < 1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"EntryCanNotBeNull"));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? NCMClientVerifyHelper.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        NCMClientVerifyHelper.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, JFormattedTextField txtField, String msg) {
        String txt = txtField.getText();
        if (txt == null || txt.trim().equals("")) {
            txtField.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? NCMClientVerifyHelper.getMessage(txtField) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, JFormattedTextField txtNumber) {
        NCMClientVerifyHelper.verifyEmpty(ui, null, txtNumber, null);
    }

    public static String getMessage(Component component) {
        String text = NCMClientVerifyHelper.getCompLabelText(component);
        return text + EASResource.getString((String)path, (String)"CanNotBeNull");
    }

    private static String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? NCMClientVerifyHelper.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        NCMClientVerifyHelper.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDComboBox comboBox) {
        NCMClientVerifyHelper.verifyEmpty(ui, null, comboBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDMultiLangBox multLangBox, String msg) {
        Object content = multLangBox.getSelectedItem();
        if (content == null || content.toString().trim().length() <= 0) {
            multLangBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? NCMClientVerifyHelper.getMessage((Component)multLangBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDMultiLangBox multLangBox) {
        NCMClientVerifyHelper.verifyEmpty(ui, null, multLangBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDComboBox comboBox, String msg) {
        Object content = comboBox.getSelectedItem();
        if (content == null) {
            comboBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? NCMClientVerifyHelper.getMessage((Component)comboBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker datePicker, String msg) {
        String content = datePicker.getText();
        if (content == null || content.equals("")) {
            datePicker.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? NCMClientVerifyHelper.getMessage((Component)datePicker) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker datePicker) {
        NCMClientVerifyHelper.verifyEmpty(ui, null, datePicker, null);
    }

    public static void verifyDateFromTo(CoreUIObject ui, String resourcePath, Date dateFrom, Date dateTo, String msg) {
        if ((dateFrom = DateTimeUtils.truncateDate((Date)dateFrom)).compareTo(dateTo = DateTimeUtils.truncateDate((Date)dateTo)) == 0) {
            dateTo = DateHelper.getNextDay(dateTo);
        }
        if (dateFrom.compareTo(dateTo) > 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDFormattedTextField txtNumber, String msg) {
        Number txt = txtNumber.getNumberValue();
        if (txt == null) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? NCMClientVerifyHelper.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea txtArea, String msg) {
        String txt = txtArea.getText();
        if (txt == null || txt.trim().length() <= 0) {
            txtArea.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? NCMClientVerifyHelper.getMessage((Component)txtArea) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtArea, String name) {
        String txt = txtArea.getText();
        if (txt == null || txt.trim().length() <= 0) {
            txtArea.requestFocus(true);
            MsgBox.showWarning((String)(name + EASResource.getString((String)path, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtArea) {
        NCMClientVerifyHelper.verifyEmpty(ui, null, txtArea, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDFormattedTextField txtNumber) {
        NCMClientVerifyHelper.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void checkStringLength(Component ui, String resourcePath, IRow row, String colName, int length) {
        String name = (String)row.getCell(colName).getValue();
        if (name != null && name.length() > length) {
            MsgBox.showWarning((Component)ui, (String)(EASResource.getString((String)resourcePath, (String)"StringLengthGreaterthan") + length + ":\n\n" + name));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (NCMClientVerifyHelper.isEmpty(value)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg, String ctrlName) {
        if (NCMClientVerifyHelper.isEmpty(value)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            NCMClientVerifyHelper.setComponentFocus((JComponent)ui, ctrlName);
            SysUtil.abort();
        }
    }

    public static void setComponentFocus(JComponent ui, String componentName) {
        Component[] comps = ui.getComponents();
        if (comps != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof KDPanel || comps[i] instanceof KDScrollPane || comps[i] instanceof KDSplitPane || comps[i] instanceof KDTabbedPane || comps[i] instanceof KDLabelContainer || comps[i] instanceof KDContainer || comps[i] instanceof KDPanel || comps[i] instanceof JPanel) {
                    NCMClientVerifyHelper.setComponentFocus((JComponent)comps[i], componentName);
                    continue;
                }
                if (comps[i] == null || comps[i].getName() == null || !comps[i].getName().equals(componentName)) continue;
                comps[i].requestFocus();
            }
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (value == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
        if (value instanceof BigDecimal && ((BigDecimal)value).compareTo(ZERO) == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, KDFormattedTextField txt) {
        NCMClientVerifyHelper.verifyEmpty(ui, txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(ZERO) == 0) {
            txt.requestFocus(true);
            String msg = NCMClientVerifyHelper.getCompLabelText((Component)txt) + EASResource.getString((String)path, (String)"CanNotBeZero");
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyBeginEndDateRel(CoreUIObject ui, Date beginDate, Date endDate) {
        if (beginDate != null && endDate != null && beginDate.after(endDate)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"beginDateNotGreaterEndDate"));
            SysUtil.abort();
        }
    }

    public static void verifyBeginEndDateRel(CoreUIObject ui, KDDatePicker pkBeginDate, KDDatePicker pkEndDate) {
        if (pkBeginDate == null || pkEndDate == null) {
            return;
        }
        if (pkBeginDate.getValue() == null || pkEndDate.getValue() == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)path, (String)"pkDateIsNull"));
            SysUtil.abort();
        }
        Date beginDate = DateTimeUtils.truncateDate((Date)((Date)pkBeginDate.getValue()));
        Date endDate = DateTimeUtils.truncateDate((Date)((Date)pkEndDate.getValue()));
        NCMClientVerifyHelper.verifyBeginEndDateRel(ui, beginDate, endDate);
    }

    public static void verifyAGreaterThanB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        NCMClientVerifyHelper.verifyEmpty(ui, txtA);
        NCMClientVerifyHelper.verifyEmpty(ui, txtB);
        BigDecimal a = txtA.getBigDecimalValue();
        BigDecimal b = txtB.getBigDecimalValue();
        if (a.compareTo(b) < 1) {
            txtA.requestFocus(true);
            String aText = NCMClientVerifyHelper.getCompLabelText((Component)txtA);
            String bText = NCMClientVerifyHelper.getCompLabelText((Component)txtB);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThan"), aText, bText);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyAGreaterThanEqualsB(CoreUIObject ui, KDFormattedTextField txtA, KDFormattedTextField txtB) {
        NCMClientVerifyHelper.verifyEmpty(ui, txtA);
        NCMClientVerifyHelper.verifyEmpty(ui, txtB);
        BigDecimal a = txtA.getBigDecimalValue();
        BigDecimal b = txtB.getBigDecimalValue();
        if (a.compareTo(b) == -1) {
            txtA.requestFocus(true);
            String aText = NCMClientVerifyHelper.getCompLabelText((Component)txtA);
            String bText = NCMClientVerifyHelper.getCompLabelText((Component)txtB);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThanEquals"), aText, bText);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyGreaterThan(CoreUIObject ui, KDFormattedTextField txt, BigDecimal num) {
        NCMClientVerifyHelper.verifyEmpty(ui, txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(num) < 1) {
            txt.requestFocus(true);
            String Text = NCMClientVerifyHelper.getCompLabelText((Component)txt);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThan"), Text, num.toString());
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyGreaterThanEqual(CoreUIObject ui, KDFormattedTextField txt, BigDecimal num) {
        NCMClientVerifyHelper.verifyEmpty(ui, txt);
        BigDecimal value = txt.getBigDecimalValue();
        if (value.compareTo(num) == -1) {
            txt.requestFocus(true);
            String Text = NCMClientVerifyHelper.getCompLabelText((Component)txt);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"greaterThanEquals"), Text, num.toString());
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyRequire(CoreUIObject ui) {
        Component[] comps = ui.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            KDTextField txtEditor;
            Component comp = comps[i];
            if (!(comp instanceof KDLabelContainer)) continue;
            KDLabelContainer ct = (KDLabelContainer)comp;
            JComponent editor = ct.getBoundEditor();
            if (editor instanceof KDTextField) {
                txtEditor = (KDTextField)editor;
                if (!txtEditor.isRequired()) continue;
                NCMClientVerifyHelper.verifyEmpty(ui, txtEditor);
                continue;
            }
            if (editor instanceof KDComboBox) {
                txtEditor = (KDComboBox)editor;
                if (!txtEditor.isRequired()) continue;
                NCMClientVerifyHelper.verifyEmpty(ui, (KDComboBox)txtEditor);
                continue;
            }
            if (editor instanceof KDDatePicker) {
                txtEditor = (KDDatePicker)editor;
                if (!txtEditor.isRequired()) continue;
                NCMClientVerifyHelper.verifyEmpty(ui, (KDDatePicker)txtEditor);
                continue;
            }
            if (editor instanceof KDBizPromptBox) {
                txtEditor = (KDBizPromptBox)editor;
                if (!txtEditor.isRequired()) continue;
                NCMClientVerifyHelper.verifyEmpty(ui, (KDBizPromptBox)txtEditor);
                continue;
            }
            if (editor instanceof KDFormattedTextField) {
                txtEditor = (KDFormattedTextField)editor;
                if (!txtEditor.isRequired()) continue;
                NCMClientVerifyHelper.verifyEmpty(ui, (KDFormattedTextField)txtEditor);
                continue;
            }
            if (!(editor instanceof KDBizMultiLangBox) || !(txtEditor = (KDBizMultiLangBox)editor).isRequired()) continue;
            NCMClientVerifyHelper.verifyEmpty(ui, (KDMultiLangBox)txtEditor);
        }
    }

    public static Set getAllComponents(Container container) {
        Component[] components = container.getComponents();
        HashSet<Component> compSet = new HashSet<Component>();
        for (Component comp : components) {
            compSet.add(comp);
            if (!(comp instanceof KDPanel) && !(comp instanceof KDScrollPane) && !(comp instanceof KDSplitPane) && !(comp instanceof KDTabbedPane) && !(comp instanceof KDLabelContainer) && !(comp instanceof KDContainer) && !(comp instanceof JPanel)) continue;
            compSet.addAll(NCMClientVerifyHelper.getAllComponents((Container)comp));
        }
        return compSet;
    }

    public static void verifyUIControlEmpty(CoreUI ui) {
        Set allLeafComponents = NCMClientVerifyHelper.getAllComponents((Container)ui);
        for (Component comp : allLeafComponents) {
            IKDTextComponent txtComp;
            if (!(comp instanceof IKDTextComponent) || !(txtComp = (IKDTextComponent)comp).isRequired()) continue;
            if (comp instanceof KDTextField) {
                NCMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDTextField)comp);
                continue;
            }
            if (comp instanceof KDBizPromptBox) {
                NCMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDBizPromptBox)comp);
                continue;
            }
            if (comp instanceof KDComboBox) {
                NCMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDComboBox)comp);
                continue;
            }
            if (comp instanceof KDMultiLangBox) {
                NCMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDMultiLangBox)comp);
                continue;
            }
            if (comp instanceof KDDatePicker) {
                NCMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDDatePicker)comp);
                continue;
            }
            if (comp instanceof KDFormattedTextField) {
                NCMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)comp);
                continue;
            }
            if (!(comp instanceof KDTextArea)) continue;
            NCMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDTextArea)comp);
        }
    }

    public static boolean verifyEmptyXOR(Object a, Object b) {
        return !NCMClientVerifyHelper.verifyEmptyOR(a, b);
    }

    public static boolean verifyEmptyXOR(Object a, Object b, Object c) {
        return !NCMClientVerifyHelper.verifyEmptyOR(a, b, c);
    }

    public static boolean verifyEmptyOR(Object a, Object b) {
        return a == null && b == null || a != null && b != null;
    }

    public static boolean verifyEmptyOR(Object a, Object b, Object c) {
        return a == null && b == null && c == null || a != null && b != null && c != null;
    }

    public static boolean isEmpty(Object[] param) {
        return param == null || param.length == 0 || param[0] == null;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return o.toString().trim().length() == 0;
        }
        return true;
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(AbstractObjectCollection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isZERO(BigDecimal o) {
        return o == null || o.compareTo(ZERO) == 0;
    }
}

