/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.ncm.common.DataConditionBaseInfo;
import com.kingdee.eas.ncm.common.DataSqlInfo;
import com.kingdee.eas.ncm.common.DataToolGroupFactory;
import com.kingdee.eas.ncm.common.DataToolGroupInfo;
import com.kingdee.eas.ncm.common.NCMDBUtilServerFacadeFactory;
import com.kingdee.eas.ncm.common.NCMKSQLData;
import com.kingdee.eas.ncm.common.SqlFileSelector;
import com.kingdee.eas.ncm.common.client.AbstractNCMDataExportUI;
import com.kingdee.eas.ncm.common.utils.FileUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class NCMDataExportUI
extends AbstractNCMDataExportUI {
    private static final Logger logger = CoreUIObject.getLogger(NCMDataExportUI.class);
    private SqlFileSelector sqlFileSelect = null;
    private static String genTempPath = "C:" + File.separator + "AtuoNCM_KSQL";

    public void onLoad() throws Exception {
        this.sqlFileSelect = new SqlFileSelector((Component)((Object)this), "SAVE", 2, false);
        this.kDBizPrFilePath.setSelector((KDPromptSelector)this.sqlFileSelect);
        this.kDTDetailInfo.setEditable(false);
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
        File file = (File)this.sqlFileSelect.getData();
        if (file == null) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u811a\u672c\u4fdd\u5b58\u7684\u8def\u5f84\u3002");
            SysUtil.abort();
        } else {
            int selectIndex;
            String fileName = file.getAbsolutePath();
            if (file.exists()) {
                file.delete();
            }
            if ((selectIndex = this.kDComboBoxFileType.getSelectedIndex()) == 0) {
                if (!fileName.endsWith(".sql")) {
                    fileName = fileName + ".sql";
                }
                this.exportDataDealBySql(fileName);
            } else if (selectIndex == 1) {
                this.exportDataDealByZip(file.getParent(), file.getName());
            }
        }
    }

    private void exportDataDealBySql(String fileName) throws EASBizException, BOSException {
        String treeID = (String)this.getUIContext().get("TreeID");
        DataToolGroupInfo dataToolGroupInfo = null;
        if (!"00000".equals(treeID)) {
            dataToolGroupInfo = DataToolGroupFactory.getRemoteInstance().getDataToolGroupInfo((IObjectPK)new ObjectUuidPK(treeID));
        }
        final List exportDataCondition = NCMDBUtilServerFacadeFactory.getRemoteInstance().getAllchildsData(dataToolGroupInfo);
        final File file = new File(fileName);
        final File deleteFile = new File(fileName.replace(".sql", "Delete.sql"));
        final DataConditionBaseInfo condition = new DataConditionBaseInfo();
        condition.setScriptType(this.kDComScriptType.getSelectedIndex());
        final boolean isGenDelete = this.kDChkIsGenDele.isSelected();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < exportDataCondition.size(); ++i) {
                        DataConditionBaseInfo condit = (DataConditionBaseInfo)exportDataCondition.get(i);
                        NCMDataExportUI.this.log("\u8868 " + condit.getTableName() + " \u5bfc\u51fa\u5f00\u59cb", Color.BLACK);
                        condition.setTableName(condit.getTableName());
                        condition.setWhereStr(condit.getWhereStr());
                        condition.setContainDel(condit.isContainDel());
                        DataSqlInfo dataSqlInfo = NCMDBUtilServerFacadeFactory.getRemoteInstance().exportData(condition);
                        NCMKSQLData.writeFile(dataSqlInfo.sql, file.getPath(), true);
                        if (isGenDelete) {
                            NCMKSQLData.writeFile(dataSqlInfo.deletesql, deleteFile.getPath(), true);
                        }
                        NCMDataExportUI.this.log("\u8868 " + condit.getTableName() + " \u5bfc\u51fa\u6210\u529f", Color.BLACK);
                    }
                    MsgBox.showInfo((String)"\u6570\u636e\u5bfc\u51fa\u6210\u529f\u3002");
                }
                catch (EASBizException e) {
                    NCMDataExportUI.this.log(e.getMessage(), Color.RED);
                }
                catch (BOSException e) {
                    NCMDataExportUI.this.log(e.getMessage(), Color.RED);
                }
                catch (Exception e) {
                    NCMDataExportUI.this.log(e.getMessage(), Color.RED);
                }
            }
        }).start();
    }

    private void exportDataDealByZip(String outPath, String fileName) throws EASBizException, BOSException {
        final String sqlFileName = fileName;
        final String filePath = outPath;
        String treeID = (String)this.getUIContext().get("TreeID");
        DataToolGroupInfo dataToolGroupInfo = null;
        if (!"00000".equals(treeID)) {
            dataToolGroupInfo = DataToolGroupFactory.getRemoteInstance().getDataToolGroupInfo((IObjectPK)new ObjectUuidPK(treeID));
        }
        final TreeBaseCollection dataToolGroupCollection = NCMDBUtilServerFacadeFactory.getRemoteInstance().getSubGroupNode(dataToolGroupInfo);
        File files = new File(genTempPath);
        if (!files.isDirectory()) {
            files.mkdir();
        }
        if (dataToolGroupCollection == null) {
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ZipOutputStream zos = null;
                try {
                    NCMDataExportUI.this.setKdButtonEnable(false);
                    String zipFileName = filePath + File.separator + sqlFileName + ".ncm";
                    for (int groupIndex = 0; groupIndex < dataToolGroupCollection.size(); ++groupIndex) {
                        DataToolGroupInfo tempDataToolGroupInfo = (DataToolGroupInfo)dataToolGroupCollection.get(groupIndex);
                        List exportDataCondition = NCMDBUtilServerFacadeFactory.getRemoteInstance().getAllchildsData(tempDataToolGroupInfo);
                        File file = new File("C:" + File.separator + "AtuoNCM_KSQL" + File.separator + sqlFileName + tempDataToolGroupInfo.getNumber() + ".sql");
                        DataConditionBaseInfo condition = new DataConditionBaseInfo();
                        condition.setScriptType(NCMDataExportUI.this.kDComScriptType.getSelectedIndex());
                        for (int i = 0; i < exportDataCondition.size(); ++i) {
                            DataConditionBaseInfo condit = (DataConditionBaseInfo)exportDataCondition.get(i);
                            NCMDataExportUI.this.log("\u8868 " + condit.getTableName() + " \u5bfc\u51fa\u5f00\u59cb", Color.BLACK);
                            condition.setTableName(condit.getTableName());
                            condition.setWhereStr(condit.getWhereStr());
                            condition.setContainDel(condit.isContainDel());
                            DataSqlInfo dataSqlInfo = NCMDBUtilServerFacadeFactory.getRemoteInstance().exportData(condition);
                            NCMKSQLData.writeFile(dataSqlInfo.sql, file.getPath(), true);
                            NCMDataExportUI.this.log("\u8868 " + condit.getTableName() + " \u5bfc\u51fa\u6210\u529f", Color.BLACK);
                        }
                    }
                    zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
                    FileUtils.zip(new File(genTempPath), "", zos);
                    NCMDataExportUI.this.log("\u751f\u6210\u538b\u7f29\u6587\u4ef6\uff1a" + zipFileName, Color.BLACK);
                    FileUtils.delFolder(genTempPath);
                    MsgBox.showInfo((String)"\u811a\u672c\u5bfc\u51fa\u6210\u529f\u3002");
                    NCMDataExportUI.this.setKdButtonEnable(true);
                }
                catch (EASBizException e) {
                    NCMDataExportUI.this.log(e.getMessage(), Color.RED);
                }
                catch (BOSException e) {
                    NCMDataExportUI.this.log(e.getMessage(), Color.RED);
                }
                catch (Exception e) {
                    NCMDataExportUI.this.log(e.getMessage(), Color.RED);
                }
                finally {
                    try {
                        if (zos != null) {
                            zos.close();
                        }
                    }
                    catch (IOException e) {
                        NCMDataExportUI.this.log(e.getMessage(), Color.RED);
                    }
                }
            }
        }).start();
    }

    private synchronized void log(final String msg, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = NCMDataExportUI.this.kDTDetailInfo.getDocument();
                try {
                    doc.insertString(doc.getLength(), msg + "\n", attributeSet);
                }
                catch (BadLocationException ignore) {
                    logger.error((Object)ignore);
                }
                NCMDataExportUI.this.kDTDetailInfo.setSelectionStart(doc.getLength());
            }
        });
    }

    private synchronized void setKdButtonEnable(boolean isEnable) {
        this.kDbutExportData.setEnabled(isEnable);
    }
}

