/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.progress.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.progress.IProgressTask;
import com.kingdee.eas.ncm.common.progress.ProgressException;
import com.kingdee.eas.ncm.common.progress.ProgressMsgLevelEnum;
import com.kingdee.eas.ncm.common.progress.ProgressUtils;
import com.kingdee.eas.ncm.common.progress.client.ProgressRemoteTask;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class ProgressHintProcessor
implements Runnable {
    private static Logger logger = Logger.getLogger(ProgressHintProcessor.class);
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss SSS >> ";
    private KDLabel lbSection;
    private JProgressBar pbSection;
    private KDLabel lbStep;
    private JProgressBar pbStep;
    private KDLabel lbUsedTime;
    private KDLabel lbRemainTime;
    private KDTextPane tpMsg;
    private boolean doSection = false;
    private boolean doStep = false;
    private int accessSpaceTime = 500;
    private boolean interrupting = false;
    private boolean showTime = false;
    private IProgressTask task = null;
    private Thread taskThread = null;
    private List userObjects = new ArrayList();
    private Throwable throwable = null;

    public List getUserObjects() {
        return this.userObjects;
    }

    public void throwThrowable() throws Throwable {
        if (this.throwable != null) {
            throw this.throwable;
        }
    }

    public ProgressHintProcessor(KDLabel lbStep, JProgressBar pbStep, KDLabel lbUsedTime, KDLabel lbRemainTime, KDTextPane tpMsg, Map param, String taskClazzName) {
        this(null, null, lbStep, pbStep, lbUsedTime, lbRemainTime, tpMsg, param, taskClazzName);
    }

    public ProgressHintProcessor(KDLabel lbSection, JProgressBar pbSection, KDLabel lbStep, JProgressBar pbStep, KDLabel lbUsedTime, KDLabel lbRemainTime, KDTextPane tpMsg, Map param, String taskClazzName) {
        if (lbSection == null) {
            lbSection = new KDLabel();
        }
        this.lbSection = lbSection;
        if (pbSection == null) {
            pbSection = new KDProgressBar();
        }
        pbSection.setStringPainted(true);
        this.pbSection = pbSection;
        if (lbStep == null) {
            lbStep = new KDLabel();
        }
        this.lbStep = lbStep;
        if (pbStep == null) {
            pbStep = new KDProgressBar();
        }
        pbStep.setStringPainted(true);
        this.pbStep = pbStep;
        if (lbUsedTime == null) {
            lbUsedTime = new KDLabel();
        }
        lbUsedTime.setText("00:00:00");
        this.lbUsedTime = lbUsedTime;
        if (lbRemainTime == null) {
            lbRemainTime = new KDLabel();
        }
        lbRemainTime.setText("00:00:00");
        this.lbRemainTime = lbRemainTime;
        if (tpMsg == null) {
            tpMsg = new KDTextPane();
        }
        this.tpMsg = tpMsg;
        this.tpMsg.setEditable(false);
        this.tpMsg.setBackground(new Color(231, 237, 242));
        if (param == null) {
            param = new HashMap<String, String>();
        }
        param.put("task.class", taskClazzName);
        this.task = new ProgressRemoteTask();
        this.init(this.task, param);
    }

    private void init(IProgressTask task, Map param) {
        Assert.that((task != null ? 1 : 0) != 0);
        this.task = task;
        task.init(param);
        Object temp = param.get("task.do.section");
        this.doSection = temp != null && temp instanceof Boolean ? (Boolean)temp : false;
        this.doStep = this.doSection ? true : ((temp = param.get("task.do.step")) != null && temp instanceof Boolean ? (Boolean)temp : true);
        temp = param.get("task.show.time");
        if (temp != null && temp instanceof Boolean) {
            this.showTime = (Boolean)temp;
        }
    }

    public synchronized void execute() {
        this.taskThread = new Thread(this);
        this.taskThread.start();
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
    }

    public synchronized void cancel() {
        this.interrupting = true;
        if (this.taskThread != null) {
            this.taskThread.interrupt();
        }
    }

    public synchronized void refresh() {
        if (this.taskThread != null) {
            this.taskThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process() throws Throwable {
        if (this.taskThread == null) {
            this.taskThread = Thread.currentThread();
        }
        int iTemp = 0;
        int stepProcess = 0;
        int sectionProcess = 0;
        this.task.execute();
        try {
            Thread.sleep(this.accessSpaceTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean goOn = true;
        int accessWaitTime = 500;
        List result = null;
        try {
            while (true) {
                if ((result = this.task.query()) == null || result.size() <= 0) {
                    try {
                        Thread.sleep(accessWaitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((accessWaitTime += accessWaitTime) <= 120000) continue;
                    accessWaitTime = this.accessSpaceTime;
                    continue;
                }
                accessWaitTime = this.accessSpaceTime;
                for (HashMap item : result) {
                    Object temp;
                    if (this.doStep) {
                        temp = item.get("task.step.name");
                        if (temp != null) {
                            this.lbStep.setText(temp.toString());
                        }
                        if ((temp = item.get("task.step.progress")) != null && temp instanceof Integer) {
                            iTemp = (Integer)temp;
                            stepProcess = iTemp <= 0 ? 0 : (iTemp >= 100 ? 100 : iTemp);
                        }
                        this.pbStep.setValue(stepProcess);
                    }
                    if (this.doSection) {
                        temp = item.get("task.section.name");
                        if (temp != null) {
                            this.lbSection.setText(temp.toString());
                        }
                        if ((temp = item.get("task.section.progress")) != null && temp instanceof Integer) {
                            iTemp = (Integer)temp;
                            sectionProcess = iTemp <= 0 ? 0 : (iTemp >= 100 ? 100 : iTemp);
                        }
                        this.pbSection.setValue(sectionProcess);
                    }
                    this.showTime(item);
                    this.log(item);
                    temp = item.get("task.user.object");
                    if (temp != null) {
                        this.userObjects.add(temp);
                    }
                    if ((temp = item.get("task.finished.status")) == null) continue;
                    if ((Integer)temp == 1) {
                        if (this.doStep) {
                            stepProcess = 100;
                            this.pbStep.setValue(stepProcess);
                        }
                        if (this.doSection) {
                            sectionProcess = 100;
                            this.pbSection.setValue(stepProcess);
                        }
                    }
                    goOn = false;
                }
                if (!goOn) break;
                if (this.interrupting) {
                    try {
                        this.task.interrupt();
                    }
                    catch (Throwable t) {
                        HashMap item;
                        item = new HashMap();
                        ProgressUtils.error(item, null, t);
                        this.log(item);
                    }
                    finally {
                        this.interrupting = false;
                    }
                    continue;
                }
                try {
                    Thread.sleep(this.accessSpaceTime);
                }
                catch (InterruptedException t) {}
            }
        }
        catch (ProgressException e) {
            if (ProgressException.SERVER_BUSY.getCode().equals(e.getSubCode())) {
                String msg = e.getMessage();
                if (this.doSection) {
                    this.lbSection.setText(msg);
                }
                this.lbStep.setText(msg);
                this.info(msg);
                throw e;
            }
            HashMap item = new HashMap();
            ProgressUtils.error(item, null, (Throwable)((Object)e));
            this.log(item);
            throw e;
        }
        catch (Throwable t) {
            HashMap item = new HashMap();
            ProgressUtils.error(item, null, t);
            this.log(item);
            throw t;
        }
    }

    private void showTime(Map item) {
        if (!this.showTime) {
            return;
        }
        if (item.containsKey("task.used.time") && item.containsKey("task.remain.time")) {
            long lTemp = 0L;
            Object temp = item.get("task.used.time");
            if (temp != null && temp instanceof Long && (lTemp = ((Long)temp).longValue()) < 0L) {
                lTemp = 0L;
            }
            String usedTime = this.calTime(lTemp);
            temp = item.get("task.remain.time");
            if (temp != null && temp instanceof Long && (lTemp = ((Long)temp).longValue()) < 0L) {
                lTemp = 0L;
            }
            String remainTime = this.calTime(lTemp);
            this.lbUsedTime.setText(usedTime);
            this.lbRemainTime.setText(remainTime);
        }
    }

    private String calTime(long millis) {
        long h = millis / 3600000L;
        long m = millis / 60000L % 60L;
        long s = millis / 1000L % 3600L % 60L;
        String time = "";
        time = h < 10L ? time + "0" + h : time + h;
        time = time + ":";
        time = m < 10L ? time + "0" + m : time + m;
        time = time + ":";
        time = s < 10L ? time + "0" + s : time + s;
        return time;
    }

    private void info(String msg) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("task.msg", msg);
        this.log(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Map item) {
        String msg = (String)item.get("task.msg");
        String msgex = (String)item.get("task.msg.exception");
        if (!StringUtils.isEmpty((String)msg) || !StringUtils.isEmpty((String)msgex)) {
            String levelName;
            int level = 20;
            Object temp = item.get("task.msg.level");
            if (temp != null && temp instanceof Integer) {
                level = (Integer)temp;
            }
            Color color = Color.BLACK;
            if (10 == level) {
                levelName = ProgressMsgLevelEnum.DEBUG.getName();
                color = Color.GRAY;
            } else if (20 == level) {
                levelName = ProgressMsgLevelEnum.INFO.getName();
                color = Color.BLACK;
            } else if (30 == level) {
                levelName = ProgressMsgLevelEnum.WARN.getName();
                color = Color.YELLOW;
            } else if (40 == level) {
                levelName = ProgressMsgLevelEnum.ERROR.getName();
                color = Color.RED;
            } else {
                levelName = ProgressMsgLevelEnum.INFO.getName();
                color = Color.BLACK;
            }
            levelName = levelName + " ";
            String date = "";
            temp = item.get("task.item.time");
            if (temp != null && temp instanceof Long) {
                date = new SimpleDateFormat(DATE_FORMAT).format(new Date((Long)temp));
            }
            date = date + levelName;
            SimpleAttributeSet attrset = new SimpleAttributeSet();
            StyleConstants.setForeground(attrset, color);
            Document docs = this.tpMsg.getDocument();
            try {
                ProgressHintProcessor progressHintProcessor = this;
                synchronized (progressHintProcessor) {
                    if (!StringUtils.isEmpty((String)msg)) {
                        docs.insertString(docs.getLength(), date + msg + "\n", attrset);
                    }
                    if (!StringUtils.isEmpty((String)msgex)) {
                        docs.insertString(docs.getLength(), date + msgex + "\n", attrset);
                    }
                }
            }
            catch (BadLocationException ble) {
                logger.error((Object)"", (Throwable)ble);
            }
            this.tpMsg.setSelectionStart(this.tpMsg.getDocument().getLength());
        }
    }

    public static void test() throws EASBizException, BOSException {
        final KDDialog dialog = new KDDialog();
        Container con = dialog.getContentPane();
        con.setLayout(new BorderLayout());
        KDLabel sectionLabel = new KDLabel("...");
        KDProgressBar sectionProgressBar = new KDProgressBar();
        sectionProgressBar.setPreferredSize(new Dimension(200, 20));
        KDLabel stepLabel = new KDLabel("...");
        KDProgressBar stepProgressBar = new KDProgressBar();
        stepProgressBar.setPreferredSize(new Dimension(200, 20));
        KDLabel lbUsedTime = new KDLabel();
        lbUsedTime.setPreferredSize(new Dimension(60, 20));
        lbUsedTime.setAlignmentX(1.0f);
        KDLabel lbRemainTime = new KDLabel();
        lbRemainTime.setPreferredSize(new Dimension(60, 20));
        lbRemainTime.setAlignmentX(1.0f);
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(10, 10, 10, 10));
        con.add((Component)box, "Center");
        box.add(Box.createVerticalGlue());
        box.add((Component)sectionLabel);
        box.add((Component)sectionProgressBar);
        box.add((Component)stepLabel);
        box.add((Component)stepProgressBar);
        Box timeBox = Box.createHorizontalBox();
        box.add(timeBox);
        timeBox.add(Box.createHorizontalGlue());
        timeBox.add((Component)lbUsedTime);
        timeBox.add((Component)lbRemainTime);
        HashMap<String, Object> param = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        String companyId = company.getId().toString();
        PeriodInfo period = OrderCMUtils.getCurrentPeriod((String)companyId);
        String periodId = period.getId().toString();
        param.put("bFilter_all", "true");
        param.put("task.do.section", Boolean.TRUE);
        param.put("task.support.interrupt", Boolean.TRUE);
        param.put("task.show.time", Boolean.TRUE);
        param.put("companyId", companyId);
        param.put("periodId", periodId);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber())));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(0);
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", ccoTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
        filter.getFilterItems().add(new FilterItemInfo("manuOrder.id", null, CompareType.NOTEQUALS));
        param.put("filterInfo", filter);
        String taskClassName = "com.kingdee.eas.ncm.order.fact.alloc.app.task.OCAllAllocTask";
        final ProgressHintProcessor processor = new ProgressHintProcessor(sectionLabel, (JProgressBar)sectionProgressBar, stepLabel, (JProgressBar)stepProgressBar, lbUsedTime, lbRemainTime, null, param, taskClassName);
        Box btnBox = Box.createHorizontalBox();
        box.add(btnBox);
        final KDButton btn = new KDButton("execute");
        btn.setActionCommand("execute");
        btn.setMargin(new Insets(1, 1, 1, 1));
        btnBox.add(Box.createHorizontalGlue());
        btnBox.add((Component)btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if ("execute".equals(btn.getActionCommand())) {
                        btn.setEnabled(false);
                        processor.execute();
                        btn.setActionCommand("close");
                        btn.setText("close");
                        btn.setEnabled(true);
                    } else if ("close".equals(btn.getActionCommand())) {
                        dialog.setVisible(true);
                        dialog.dispose();
                    }
                }
                catch (Throwable ex) {
                    logger.error((Object)"", ex);
                }
            }
        });
        ((JPanel)con).setPreferredSize(new Dimension(400, 150));
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.show();
    }
}

