/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.progress.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ncm.common.progress.ProgressServiceFacadeFactory;
import com.kingdee.eas.ncm.common.progress.ProgressUtils;
import com.kingdee.eas.ncm.common.progress.client.AbstractProgressListUI;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ProgressListUI
extends AbstractProgressListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProgressListUI.class);
    private Timer timer = null;

    public ProgressListUI() throws Exception {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
        ProgressBarRender render = new ProgressBarRender();
        this.tblMain.getColumn("progress").setRenderer((IBasicRender)render);
        this.timer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressListUI.this.btnRefresh.doClick();
            }
        });
        this.timer.setInitialDelay(0);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.timer.start();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        List list = ProgressServiceFacadeFactory.getRemoteInstance().getCollection(null);
        Object temp = null;
        for (int i = 0; i < list.size(); ++i) {
            Map task = (Map)list.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("ID").setValue(task.get("ID"));
            row.getCell("name").setValue(task.get("name"));
            row.getCell("userName").setValue(task.get("userName"));
            row.getCell("orgName").setValue(task.get("orgName"));
            temp = task.get("submitTime");
            if (temp instanceof Long) {
                row.getCell("submitTime").setValue((Object)DATE_FORMAT.format(new Date((Long)temp)));
            } else {
                row.getCell("submitTime").setValue(temp);
            }
            temp = task.get("startTime");
            if (temp instanceof Long) {
                row.getCell("startTime").setValue((Object)DATE_FORMAT.format(new Date((Long)temp)));
            } else {
                row.getCell("startTime").setValue(temp);
            }
            temp = task.get("usedTime");
            if (temp instanceof Long) {
                row.getCell("usedTime").setValue((Object)ProgressUtils.calTime((Long)temp));
            } else {
                row.getCell("usedTime").setValue(temp);
            }
            temp = task.get("remainTime");
            if (temp instanceof Long) {
                row.getCell("remainTime").setValue((Object)ProgressUtils.calTime((Long)temp));
            } else {
                row.getCell("remainTime").setValue(temp);
            }
            row.getCell("remark").setValue(task.get("remark"));
            row.getCell("progress").setValue(task.get("progress"));
        }
    }

    public boolean destroyWindow() {
        this.timer.stop();
        return super.destroyWindow();
    }

    private static class ProgressBarRender
    extends KDProgressBar
    implements IBasicRender {
        public ProgressBarRender() {
            this.setStringPainted(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if (object instanceof Integer) {
                this.setValue((Integer)object);
            }
            Rectangle rect = clip.getBounds();
            rect.x -= 3;
            rect.width += 6;
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }
    }
}

