/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.task.CostTaskCollection;
import com.kingdee.eas.ncm.common.task.CostTaskException;
import com.kingdee.eas.ncm.common.task.CostTaskFactory;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.app.CostTaskExecutor;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CostTaskUtils {
    public static Context cloneContext(Context srcCtx, String contextID) {
        return CostTaskUtils.cloneContext(srcCtx, contextID, false);
    }

    public static Context cloneContext(Context srcCtx, String contextID, boolean simple) {
        Context ctx = new Context(srcCtx.getCaller(), srcCtx.getSolution(), srcCtx.getAIS(), srcCtx.getLocale(), contextID);
        ctx.setClientHostIP(srcCtx.getClientHostIP());
        ctx.setClientHostName(srcCtx.getClientHostName());
        ctx.setUserName(srcCtx.getUserName());
        for (Object key : srcCtx.getUserDefineFieldKeySet()) {
            Object value = srcCtx.get(key);
            if (simple) {
                if (value != null && !(value instanceof Serializable)) continue;
                ctx.put(key, value);
                continue;
            }
            ctx.put(key, value);
        }
        return ctx;
    }

    public static String encode(Map map) {
        StringBuffer result = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            result.append(entry.getKey());
            result.append("~=~");
            result.append(value);
            result.append("~@~");
        }
        if (result.length() > 0) {
            result.delete(result.length() - 3, result.length());
        }
        return result.toString();
    }

    public static Map decode(String str) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (str == null || str.length() == 0) {
            return result;
        }
        String[] entries = str.split("~@~");
        for (int i = 0; i < entries.length; ++i) {
            String[] keyvalue;
            String entry = entries[i].trim();
            if (entry.length() == 0 || (keyvalue = entry.split("~=~")).length != 2) continue;
            String key = keyvalue[0].trim();
            String value = keyvalue[1].trim();
            if (key.length() == 0 || value.length() == 0) continue;
            result.put(key, value);
        }
        return result;
    }

    public static long getCurrentTime(Context ctx) throws BOSException {
        try {
            IMutexServiceControl mutex = null;
            mutex = ctx != null ? MutexServiceControlFactory.getLocalInstance((Context)ctx) : MutexServiceControlFactory.getRemoteInstance();
            return mutex.getCurrentTime();
        }
        catch (Throwable e) {
            return System.currentTimeMillis();
        }
    }

    public static void setExecutorClazz(Map param, String executorClazz) {
        if (param != null) {
            param.put("key.cost.task.executor.class", executorClazz);
        }
    }

    public static String getExecutorClazz(Map param) {
        if (param != null) {
            return (String)param.get("key.cost.task.executor.class");
        }
        return null;
    }

    public static void setExecutor(Map param, CostTaskExecutor executor) {
        if (param != null) {
            param.put("key.cost.task.executor.object", executor);
        }
    }

    public static CostTaskExecutor getExecutor(Map param) {
        if (param != null) {
            return (CostTaskExecutor)param.get("key.cost.task.executor.object");
        }
        return null;
    }

    public static void setTask(Map param, CostTaskInfo costTask) {
        if (param != null) {
            param.put("key.cost.task.cost.task", costTask);
        }
    }

    public static CostTaskInfo getTask(Map param) {
        if (param != null) {
            return (CostTaskInfo)param.get("key.cost.task.cost.task");
        }
        return null;
    }

    public static void setSendQueue(Map param) {
        CostTaskUtils.setSendQueue(param, true);
    }

    public static void setSendQueue(Map param, boolean isSendQueue) {
        if (param != null) {
            param.put("key.cost.task.send.queue", new Boolean(isSendQueue));
        }
    }

    public static boolean isSendQueue(Map param) {
        if (param != null && param.get("key.cost.task.send.queue") != null) {
            return (Boolean)param.get("key.cost.task.send.queue");
        }
        return false;
    }

    public static void setSyn(Map param) {
        CostTaskUtils.setSyn(param, true);
    }

    public static void setSyn(Map param, boolean isSyn) {
        if (param != null) {
            param.put("key.cost.task.is.syn", new Boolean(isSyn));
        }
    }

    public static boolean isSyn(Map param) {
        if (param != null && param.get("key.cost.task.is.syn") != null) {
            return (Boolean)param.get("key.cost.task.is.syn");
        }
        return true;
    }

    public static void setSubTask(Map param) {
        CostTaskUtils.setSubTask(param, true);
    }

    public static void setSubTask(Map param, boolean isSubTask) {
        if (param != null) {
            param.put("key.cost.task.sub.task", new Boolean(isSubTask));
        }
    }

    public static boolean isSubTask(Map param) {
        if (param != null && param.get("key.cost.task.sub.task") != null) {
            return (Boolean)param.get("key.cost.task.sub.task");
        }
        return false;
    }

    public static void setMutexId(Map param, Uuid mutexId) {
        if (param != null) {
            param.put("key.cost.task.mutex.id", mutexId);
        }
    }

    public static Uuid getMutexId(Map param) {
        if (param != null) {
            return (Uuid)param.get("key.cost.task.mutex.id");
        }
        return null;
    }

    public static void requestMutex(Context ctx, Map param) throws BOSException, EASBizException {
        CostTaskInfo costTask = CostTaskUtils.getTask(param);
        if (costTask.getFunction() != null) {
            Uuid oldMutexUuid = CostTaskUtils.getMutexId(param);
            MutexParameter mutexParam = new MutexParameter();
            Uuid mutexUuid = oldMutexUuid;
            if (mutexUuid == null) {
                mutexUuid = Uuid.create();
            }
            mutexParam.setRequestId(mutexUuid);
            mutexParam.setMutexName(costTask.getFunction());
            mutexParam.setActionName(costTask.getName());
            mutexParam.setUserID(costTask.getCreator().getId());
            mutexParam.setOrgUnitID(costTask.getCompany().getId());
            mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
            mutexParam.setDcName(ctx.getAIS());
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean isSucceed = mutex.requestMutex(mutexParam);
            if (!isSucceed && oldMutexUuid == null) {
                StringBuffer oql = new StringBuffer();
                oql.append("select \n");
                oql.append("    number, \n");
                oql.append("    name, \n");
                oql.append("    function, \n");
                oql.append("    company.name, \n");
                oql.append("    period.number \n");
                oql.append("where \n");
                oql.append("    function = '" + costTask.getFunction() + "' \n");
                oql.append("    and status <> 9 \n");
                CostTaskCollection coll = CostTaskFactory.getLocalInstance(ctx).getCostTaskCollection(oql.toString());
                if (coll.size() > 0) {
                    CostTaskInfo existCostTask = coll.get(0);
                    Object[] params = new Object[]{existCostTask.getCompany().getName(), existCostTask.getName()};
                    throw new CostTaskException(CostTaskException.CONCURRENT, params);
                }
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
            CostTaskUtils.setMutexId(param, mutexUuid);
        }
    }

    public static void releaseMutex(Context ctx, Map param) throws BOSException, EASBizException {
        if (param != null) {
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            Uuid mutexId = CostTaskUtils.getMutexId(param);
            if (mutexId != null) {
                mutex.releaseMutex(mutexId);
            }
        }
    }
}

