/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.common.perf.client.JobSwingWorker;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.common.task.CostTaskCollection;
import com.kingdee.eas.ncm.common.task.CostTaskFacadeFactory;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.client.CostTaskEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CostTaskClientUtils {
    public static void execute(Map param, CoreUIObject owner, boolean close) throws Exception {
        CostTaskClientUtils.execute(param, owner, null, close);
    }

    public static void execute(List params, CoreUIObject owner, boolean close) throws Exception {
        CostTaskClientUtils.execute(params, owner, null, close);
    }

    public static void execute(Map param, CoreUIObject owner, CoreUIObject popup, boolean close) throws Exception {
        ArrayList<Map> params = new ArrayList<Map>(1);
        params.add(param);
        CostTaskClientUtils.execute(params, owner, popup, close);
    }

    public static void execute(List params, CoreUIObject owner, CoreUIObject popup, boolean close) throws Exception {
        if (params == null || params.size() == 0) {
            return;
        }
        List list = CostTaskFacadeFactory.getRemoteInstance().execute(params);
        if (list == null || list.size() == 0) {
            return;
        }
        CostTaskCollection costTasks = new CostTaskCollection();
        for (int i = 0; i < params.size(); ++i) {
            Map result;
            Map param = (Map)params.get(i);
            CostTaskInfo costTask = CostTaskUtils.getTask(param);
            if (list.size() > i && (result = (Map)list.get(i)) != null) {
                costTask.setId(BOSUuid.read((String)result.get("taskId").toString()));
                CostTaskClientUtils.addMonitorInfo(param, costTask, result, owner);
            }
            costTasks.add(costTask);
        }
        CostTaskClientUtils.showProgress(costTasks, owner, popup, close);
    }

    private static void addMonitorInfo(Map param, CostTaskInfo costTask, Map result, final CoreUIObject owner) {
        if (result.get("jobId") != null) {
            String title = "\u3010" + param.get("companyName") + "(" + param.get("companyNumber") + ")\u3011(" + costTask.getName() + ")";
            final CostTaskCollection aCostTasks = new CostTaskCollection();
            aCostTasks.add(costTask);
            JobMonitorManager.getInstance().addMonitorInfo(result.get("jobId").toString(), title, new JobSwingWorker(result.get("jobId").toString()){

                public void finishedLater() {
                    try {
                        CostTaskClientUtils.showProgress(aCostTasks, owner, null, false);
                    }
                    catch (Exception e) {
                        SysUtil.abort((Throwable)e);
                    }
                }
            });
        }
    }

    public static void showProgress(CostTaskInfo costTask, CoreUIObject owner, boolean close) throws Exception {
        CostTaskClientUtils.showProgress(costTask, owner, null, close);
    }

    public static void showProgress(CostTaskInfo costTask, CoreUIObject owner, CoreUIObject popup, boolean close) throws Exception {
        CostTaskCollection costTasks = new CostTaskCollection();
        costTasks.add(costTask);
        CostTaskClientUtils.showProgress(costTasks, owner, popup, close);
    }

    public static void showProgress(CostTaskCollection costTasks, CoreUIObject owner, CoreUIObject popup, boolean close) throws Exception {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"costTasks", (Object)costTasks);
        if (costTasks.size() == 1) {
            CostTaskInfo costTask = costTasks.get(0);
            String id = costTask.getCompany().getId().toString() + "_" + costTask.getNumber();
            uiContext.put((Object)"ID", (Object)id);
        } else {
            uiContext.put((Object)"ID", (Object)Uuid.create().toString());
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CostTaskEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        if (close) {
            if (popup != null) {
                popup.getUIWindow().close();
            }
            if (owner != null) {
                owner.getUIWindow().close();
            }
        }
        uiWindow.show();
    }
}

