/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.task.client;

import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ImageIcon;

public class ProgressRenderer
implements IBasicRender {
    private ImageIcon unbeginIcon = new ImageIcon("com/kingdee/eas/ncm/common/resource/pic/status_unbegin.gif");
    private ImageIcon beginIcon = new ImageIcon("com/kingdee/eas/ncm/common/resource/pic/status_begin.gif");
    private ImageIcon endIcon = new ImageIcon("com/kingdee/eas/ncm/common/resource/pic/status_end.gif");
    protected SimpleTextRender simpleRender = new SimpleTextRender();
    protected TreeIcon cbIcon;
    private Map mapOfTreeNodeLocation = new Hashtable();

    public ProgressRenderer() {
        this.cbIcon = new TreeIcon();
    }

    public boolean inRect(CostTaskEntryInfo item, int x, int y) {
        String key = item.getId().toString();
        Rectangle rec = (Rectangle)this.mapOfTreeNodeLocation.get(key);
        if (rec != null) {
            return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
        }
        return false;
    }

    public void draw(Graphics g, Shape clip, Object value, Style style) {
        if (value == null || !(value instanceof CostTaskEntryInfo)) {
            return;
        }
        CostTaskEntryInfo item = (CostTaskEntryInfo)value;
        int ident = item.getLevel() * 16;
        Rectangle rect = clip.getBounds();
        int x = rect.x + ident;
        int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
        int v = item.isLeaf() ? 0 : (item.isExpanded() ? 2 : 1);
        Color color = style.getFontColor();
        g.setColor(color);
        Rectangle locRec = new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getWidth());
        String key = item.getId().toString();
        this.mapOfTreeNodeLocation.put(key, locRec);
        int xx = x + this.cbIcon.getWidth() + 8;
        Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - 8, (int)clip.getBounds().getHeight());
        this.simpleRender.draw(g, (Shape)newRec, item.toString(), style);
        if (item.getStatus().getValue() == 2) {
            this.cbIcon.setImageIcon(this.beginIcon);
        } else if (item.getStatus().getValue() == 9) {
            this.cbIcon.setImageIcon(this.endIcon);
        } else {
            this.cbIcon.setImageIcon(this.unbeginIcon);
        }
        this.cbIcon.paint(v, g, x, y);
    }

    class TreeIcon
    implements Icon {
        ImageIcon imageICon = null;
        private int iconSize;
        private int margin;

        public TreeIcon() {
            this(9);
        }

        public TreeIcon(int iconSize) {
            this.iconSize = iconSize;
            this.margin = 2;
        }

        public int getWidth() {
            return this.iconSize;
        }

        public int getHeight() {
            return this.iconSize;
        }

        public void setImageIcon(ImageIcon imageICon) {
            this.imageICon = imageICon;
        }

        public void paint(Object value, Graphics g, int x, int y) {
            if (value instanceof Integer) {
                int type = (Integer)value;
                if (type == 0) {
                    this.drawLeaf(g, x, y);
                } else if (type == 1) {
                    this.drawCollapsed(g, x, y);
                } else {
                    this.drawExpanded(g, x, y);
                }
            }
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            g.drawImage(this.imageICon.getImage(), x, y, null);
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
            g.drawLine(x + 1 + this.iconSize / 2, y + this.margin, x + 1 + this.iconSize / 2, y + this.margin + lineSize);
        }
    }
}

