/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;

public class CostObjectUtil {
    public static CostObjectRelatedInfo getCostObjectRelatedInfoByCO(CostObjectInfo costObjectInfo) throws EASBizException, BOSException {
        return CostObjectUtil.getCostObjectRelatedInfoByCO(null, costObjectInfo);
    }

    public static CostObjectRelatedInfo getCostObjectRelatedInfoByCO(Context ctx, CostObjectInfo costObjectInfo) throws EASBizException, BOSException {
        if (costObjectInfo == null) {
            return null;
        }
        ManufactureOrderInfo manufactureOrderInfo = null;
        if (costObjectInfo.getOrderID() != null && costObjectInfo.getOrderID().length() > 0) {
            manufactureOrderInfo = CostObjectUtil.getManufactureOrderInfoByID(ctx, costObjectInfo.getOrderID());
        }
        MaterialInfo materialInfo = null;
        if (costObjectInfo.getStdProductID() != null && costObjectInfo.getStdProductID().getId() != null) {
            materialInfo = CostObjectUtil.getMaterialInfoByID(ctx, costObjectInfo.getStdProductID().getId().toString());
        }
        CostObjectRelatedInfo costObjectRelatedInfo = new CostObjectRelatedInfo();
        costObjectRelatedInfo.setCostObjectInfo(costObjectInfo);
        costObjectRelatedInfo.setManufactureOrderInfo(manufactureOrderInfo);
        costObjectRelatedInfo.setMaterialInfo(materialInfo);
        if (manufactureOrderInfo != null && manufactureOrderInfo.getProject() != null && manufactureOrderInfo.getProject().getNumber() != null) {
            costObjectRelatedInfo.setProjectNumber(manufactureOrderInfo.getProject().getNumber());
        }
        if (manufactureOrderInfo != null && manufactureOrderInfo.getTrackNumber() != null && manufactureOrderInfo.getTrackNumber().getNumber() != null) {
            costObjectRelatedInfo.setTrackNumber(manufactureOrderInfo.getTrackNumber().getNumber());
        }
        return costObjectRelatedInfo;
    }

    public static CostObjectRelatedInfo getCostObjectRelatedInfoByMat(MaterialInfo materialInfo) throws EASBizException, BOSException {
        return CostObjectUtil.getCostObjectRelatedInfoByMat(materialInfo, "", false);
    }

    public static CostObjectRelatedInfo getCostObjectRelatedInfoByMat(MaterialInfo materialInfo, String batch, boolean isBatch) throws EASBizException, BOSException {
        if (isBatch && (batch == null || batch.length() == 0)) {
            throw new BOSException("\u8bf7\u5f55\u5165\u6279\u6b21");
        }
        return CostObjectUtil.getCostObjectRelatedInfoByMat(null, materialInfo, batch);
    }

    public static CostObjectRelatedInfo getCostObjectRelatedInfo(Context ctx, MaterialInfo materialInfo, String batch, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        String getuCOSql;
        CostObjectRelatedInfo costObjectRelatedInfo = null;
        if (materialInfo == null) {
            return null;
        }
        CostObjectInfo costObjectInfo = null;
        CostObjectCollection cotObjectColl = null;
        if (materialInfo.getId() != null) {
            getuCOSql = "select id, number, name where calculateMode = 1 and isForbiden = 0 and StdProductID.id = '" + materialInfo.getId() + "' and company.id ='" + companyInfo.getId() + "'";
            cotObjectColl = ctx != null ? CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(getuCOSql) : CostObjectFactory.getRemoteInstance().getCostObjectCollection(getuCOSql);
            if (cotObjectColl != null && cotObjectColl.size() > 0) {
                costObjectInfo = cotObjectColl.get(0);
            }
        }
        if (costObjectInfo == null && materialInfo.getId() != null) {
            getuCOSql = "select id, number, name where calculateMode = 3 and isForbiden = 0 and StdProductID.id = '" + materialInfo.getId() + "' and company.id ='" + companyInfo.getId() + "'";
            cotObjectColl = ctx != null ? CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(getuCOSql) : CostObjectFactory.getRemoteInstance().getCostObjectCollection(getuCOSql);
            if (cotObjectColl != null && cotObjectColl.size() > 0) {
                costObjectInfo = cotObjectColl.get(0);
            }
        }
        if (costObjectInfo == null && materialInfo.getId() != null) {
            getuCOSql = "select id, number, name, batchNumber where calculateMode = 4 and isForbiden = 0 and StdProductID.id = '" + materialInfo.getId() + "' and company.id ='" + companyInfo.getId() + "'";
            if (batch != null && batch.length() > 0) {
                getuCOSql = "select id, number, name, batchNumber where calculateMode = 4 and isForbiden = 0 and StdProductID.id = '" + materialInfo.getId() + "' and batchNumber = '" + batch + "' and company.id ='" + companyInfo.getId() + "'";
            }
            if ((cotObjectColl = ctx != null ? CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(getuCOSql) : CostObjectFactory.getRemoteInstance().getCostObjectCollection(getuCOSql)) != null && cotObjectColl.size() > 0 && batch != null && batch.length() > 0) {
                costObjectInfo = cotObjectColl.get(0);
            }
        }
        if (costObjectInfo != null) {
            costObjectRelatedInfo = new CostObjectRelatedInfo();
            costObjectRelatedInfo.setCostObjectInfo(costObjectInfo);
            return costObjectRelatedInfo;
        }
        if (cotObjectColl != null && cotObjectColl.size() < 1 && (batch == null || batch.length() <= 0)) {
            throw new NcmBillException(NcmBillException.GETCOBYMAT_NO_RESULT);
        }
        return costObjectRelatedInfo;
    }

    public static CostObjectRelatedInfo getCostObjectRelatedInfoByMat(Context ctx, MaterialInfo materialInfo, String batch) throws EASBizException, BOSException {
        String getuCOSql;
        CostObjectRelatedInfo costObjectRelatedInfo = null;
        if (materialInfo == null) {
            return null;
        }
        CostObjectInfo costObjectInfo = null;
        CostObjectCollection cotObjectColl = null;
        if (materialInfo.getId() != null) {
            getuCOSql = "select id, number, name where calculateMode = 1 and isForbiden = 0 and StdProductID.id = '" + materialInfo.getId() + "'";
            cotObjectColl = ctx != null ? CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(getuCOSql) : CostObjectFactory.getRemoteInstance().getCostObjectCollection(getuCOSql);
            if (cotObjectColl != null && cotObjectColl.size() > 0) {
                costObjectInfo = cotObjectColl.get(0);
            }
        }
        if (costObjectInfo == null && materialInfo.getId() != null) {
            getuCOSql = "select id, number, name where calculateMode = 3 and isForbiden = 0 and StdProductID.id = '" + materialInfo.getId() + "'";
            cotObjectColl = ctx != null ? CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(getuCOSql) : CostObjectFactory.getRemoteInstance().getCostObjectCollection(getuCOSql);
            if (cotObjectColl != null && cotObjectColl.size() > 0) {
                costObjectInfo = cotObjectColl.get(0);
            }
        }
        if (costObjectInfo == null && materialInfo.getId() != null) {
            getuCOSql = "select id, number, name, batchNumber where calculateMode = 4 and isForbiden = 0 and StdProductID.id = '" + materialInfo.getId() + "'";
            if (batch != null && batch.length() > 0) {
                getuCOSql = "select id, number, name, batchNumber where calculateMode = 4 and isForbiden = 0 and StdProductID.id = '" + materialInfo.getId() + "' and batchNumber = '" + batch + "'";
            }
            if ((cotObjectColl = ctx != null ? CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(getuCOSql) : CostObjectFactory.getRemoteInstance().getCostObjectCollection(getuCOSql)) != null && cotObjectColl.size() > 0 && batch != null && batch.length() > 0) {
                costObjectInfo = cotObjectColl.get(0);
            }
        }
        if (costObjectInfo != null) {
            costObjectRelatedInfo = new CostObjectRelatedInfo();
            costObjectRelatedInfo.setCostObjectInfo(costObjectInfo);
            return costObjectRelatedInfo;
        }
        if (cotObjectColl != null && cotObjectColl.size() < 1 && (batch == null || batch.length() <= 0)) {
            throw new NcmBillException(NcmBillException.GETCOBYMAT_NO_RESULT);
        }
        return costObjectRelatedInfo;
    }

    public static CostObjectRelatedInfo getCostObjectRelatedInfoByOrder(ManufactureOrderInfo manufactureOrderInfo, String companyID) throws EASBizException, BOSException {
        return CostObjectUtil.getCostObjectRelatedInfoByOrder(null, manufactureOrderInfo, companyID);
    }

    public static CostObjectRelatedInfo getCostObjectRelatedInfoByOrder(Context ctx, ManufactureOrderInfo manufactureOrderInfo, String companyID) throws EASBizException, BOSException {
        CostObjectRelatedInfo costObjectRelatedInfo = null;
        CostObjectInfo costObjectInfo = null;
        CostObjectCollection cotObjectColl = null;
        MaterialCompanyInfoInfo materialCompanyInfoInfo = null;
        MaterialCompanyInfoCollection mcColl = null;
        if (manufactureOrderInfo != null) {
            if (manufactureOrderInfo.getCostObject() != null) {
                if (ctx != null) {
                    return CostObjectUtil.getCostObjectRelatedInfoByCO(ctx, CostObjectUtil.getCostObjectInfoByID(ctx, manufactureOrderInfo.getCostObject().getId().toString()));
                }
                return CostObjectUtil.getCostObjectRelatedInfoByCO(CostObjectUtil.getCostObjectInfoByID(null, manufactureOrderInfo.getCostObject().getId().toString()));
            }
            if (manufactureOrderInfo.getMaterial() != null) {
                String getMatCompSql = "select id,CreateCOByOrder where mateial.id = '" + manufactureOrderInfo.getMaterial().getId().toString() + "' and company.id = '" + companyID + "'";
                String getCoSql = "select id, number, name, orderID, StdProductID.id where calculateMode = 7 and isForbiden = 0 and orderID = '" + manufactureOrderInfo.getId().toString() + "'";
                if (ctx != null) {
                    mcColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(getMatCompSql);
                    cotObjectColl = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(getCoSql);
                } else {
                    mcColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(getMatCompSql);
                    cotObjectColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(getCoSql);
                }
                if (mcColl != null && mcColl.size() > 0) {
                    materialCompanyInfoInfo = mcColl.get(0);
                }
                if (cotObjectColl != null && cotObjectColl.size() > 0) {
                    costObjectInfo = cotObjectColl.get(0);
                }
                if (materialCompanyInfoInfo != null && materialCompanyInfoInfo.isCreateCOByOrder() && manufactureOrderInfo.getBaseStatus().getValue() < 5) {
                    throw new NcmBillException(NcmBillException.MANUFACTRUEORDER_NO_RELEASED);
                }
                if (costObjectInfo != null) {
                    return CostObjectUtil.getCostObjectRelatedInfoByCO(costObjectInfo);
                }
                if (materialCompanyInfoInfo != null && !materialCompanyInfoInfo.isCreateCOByOrder()) {
                    costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat(ctx, manufactureOrderInfo.getMaterial(), null);
                    MaterialInfo matInfo = CostObjectUtil.getMaterialInfoByID(ctx, manufactureOrderInfo.getMaterial().getId().toString());
                    if (costObjectRelatedInfo != null) {
                        costObjectRelatedInfo.setMaterialInfo(matInfo);
                    } else {
                        costObjectRelatedInfo = new CostObjectRelatedInfo();
                        costObjectRelatedInfo.setMaterialInfo(matInfo);
                    }
                }
            }
        }
        return costObjectRelatedInfo;
    }

    private static ManufactureOrderInfo getManufactureOrderInfoByID(Context ctx, String manufactureOrderID) throws EASBizException, BOSException {
        ManufactureOrderInfo manufactureOrderInfo = null;
        if (manufactureOrderID != null && manufactureOrderID.length() > 0) {
            SelectorItemCollection sicOrder = new SelectorItemCollection();
            sicOrder.add(new SelectorItemInfo("id"));
            sicOrder.add(new SelectorItemInfo("number"));
            sicOrder.add(new SelectorItemInfo("project.number"));
            sicOrder.add(new SelectorItemInfo("trackNumber.number"));
            manufactureOrderInfo = ctx != null ? ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(manufactureOrderID), sicOrder) : ManufactureOrderFactory.getRemoteInstance().getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(manufactureOrderID), sicOrder);
        }
        return manufactureOrderInfo;
    }

    public static MaterialInfo getMaterialInfoByID(Context ctx, String materialID) throws EASBizException, BOSException {
        MaterialInfo materialInfo = null;
        if (materialID != null && materialID.length() > 0) {
            SelectorItemCollection sicMat = new SelectorItemCollection();
            sicMat.add(new SelectorItemInfo("id"));
            sicMat.add(new SelectorItemInfo("number"));
            sicMat.add(new SelectorItemInfo("name"));
            materialInfo = ctx != null ? MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sicMat) : MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sicMat);
        }
        return materialInfo;
    }

    public static CostObjectInfo getCostObjectInfoByID(Context ctx, String costObjectID) throws EASBizException, BOSException {
        CostObjectInfo costObjectInfo = null;
        if (costObjectID != null && costObjectID.length() > 0) {
            SelectorItemCollection sicCO = new SelectorItemCollection();
            sicCO.add(new SelectorItemInfo("id"));
            sicCO.add(new SelectorItemInfo("number"));
            sicCO.add(new SelectorItemInfo("name"));
            sicCO.add(new SelectorItemInfo("StdProductID"));
            sicCO.add(new SelectorItemInfo("orderID"));
            sicCO.add(new SelectorItemInfo("batchNumber"));
            costObjectInfo = ctx != null ? CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectInfo((IObjectPK)new ObjectUuidPK(costObjectID), sicCO) : CostObjectFactory.getRemoteInstance().getCostObjectInfo((IObjectPK)new ObjectUuidPK(costObjectID), sicCO);
        }
        return costObjectInfo;
    }
}

