/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class FileUtils {
    public static Logger logger = Logger.getLogger(FileUtils.class);

    public static void delFolder(String folderPath) {
        try {
            FileUtils.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtils.delAllFile(path + "/" + tempList[i]);
            FileUtils.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public static void zip(File fDir, String pName, ZipOutputStream zos) throws IOException {
        FileInputStream fis = null;
        try {
            if (fDir.isDirectory()) {
                zos.putNextEntry(new ZipEntry(fDir.getName() + "/"));
                File[] files = fDir.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (pName.equals(files[i].getName())) continue;
                        FileUtils.zip(files[i], fDir.getName() + "/", zos);
                    }
                }
            }
            if (fDir.isFile()) {
                byte[] bt = new byte[2048];
                ZipEntry ze = new ZipEntry(pName + fDir.getName());
                ze.setSize(fDir.length());
                zos.putNextEntry(ze);
                fis = new FileInputStream(fDir);
                int i = 0;
                while ((i = fis.read(bt)) != -1) {
                    zos.write(bt, 0, i);
                }
            }
        }
        catch (IOException e) {
            throw new IOException(e.toString());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new IOException(e.toString());
                }
            }
        }
    }

    public static void unZip(String zipFileName, String outputDirectory) throws IOException {
        ZipInputStream inputStream = new ZipInputStream(new FileInputStream(zipFileName));
        ZipEntry zipEntry = null;
        FileOutputStream outputStream = null;
        while ((zipEntry = inputStream.getNextEntry()) != null) {
            int b;
            if (zipEntry.isDirectory()) {
                String name = zipEntry.getName();
                name = name.substring(0, name.length() - 1);
                File file = new File(outputDirectory + File.separator + name);
                file.mkdir();
                continue;
            }
            File file = new File(outputDirectory + File.separator + zipEntry.getName());
            file.createNewFile();
            outputStream = new FileOutputStream(file);
            while ((b = inputStream.read()) != -1) {
                outputStream.write(b);
            }
            outputStream.close();
        }
        inputStream.close();
    }
}

