/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.algorithm;

public class TestXYZ {
    private double[][] savequot = null;
    private double[] constquot = null;
    private double[] saveResult = null;

    public TestXYZ(double[][] quot) {
        int count = quot.length;
        this.savequot = new double[count][count];
        this.constquot = new double[count];
        this.saveResult = new double[count];
        int i = 0;
        int j = 0;
        for (i = 0; i < count; ++i) {
            for (j = 0; j < count; ++j) {
                this.savequot[i][j] = quot[i][j];
            }
            this.constquot[i] = quot[i][count];
            this.saveResult[i] = 0.0;
        }
    }

    private double getMatrixResult(double[][] input) {
        if (input.length == 2) {
            return input[0][0] * input[1][1] - input[0][1] * input[1][0];
        }
        double[] temp = new double[input.length];
        double[][] tempinput = new double[input.length - 1][input.length - 1];
        double result = 0.0;
        for (int i = 0; i < input.length; ++i) {
            temp[i] = input[i][0];
            int m = 0;
            int n = 0;
            for (int k = 0; k < input.length; ++k) {
                if (k == i) continue;
                for (m = 0; m < input.length - 1; ++m) {
                    tempinput[n][m] = input[k][m + 1];
                }
                ++n;
            }
            if (i % 2 == 0) {
                result += temp[i] * this.getMatrixResult(tempinput);
                continue;
            }
            result -= temp[i] * this.getMatrixResult(tempinput);
        }
        return result;
    }

    private double[][] getReplaceMatrix(int i) {
        double[][] tempresult = new double[this.savequot.length][this.savequot.length];
        for (int m = 0; m < this.savequot.length; ++m) {
            for (int n = 0; n < this.savequot.length; ++n) {
                if (i != m) {
                    tempresult[n][m] = this.savequot[n][m];
                    continue;
                }
                tempresult[n][i] = this.constquot[n];
            }
        }
        return tempresult;
    }

    public double[] getResult() {
        double basic = 0.0;
        basic = this.getMatrixResult(this.savequot);
        if (Math.abs(basic) < 1.0E-5) {
            return (double[])this.saveResult.clone();
        }
        for (int i = 0; i < this.saveResult.length; ++i) {
            this.saveResult[i] = this.getMatrixResult(this.getReplaceMatrix(i)) / basic;
        }
        return (double[])this.saveResult.clone();
    }

    public static void main(String[] args) throws Exception {
    }
}

