/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class LowLevelCodeTrees
extends JFrame {
    public static void main(String[] args) throws EASBizException, BOSException {
    }

    public static void generateTrees(Object[] obj) throws BOSException, EASBizException {
        Map objMap = (Map)obj[1];
        Map co_reference = (Map)obj[2];
        if (objMap.isEmpty() || co_reference.isEmpty()) {
            return;
        }
        Set trees = LowLevelCodeTrees.generateTrees(objMap, co_reference);
        if (trees.isEmpty()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"16_LowLevelCodeTrees"));
            SysUtil.abort();
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setPreferredSize(new Dimension(800, 600));
        Iterator ite = trees.iterator();
        JTree tree = null;
        while (ite.hasNext()) {
            tree = (JTree)ite.next();
            panel.add(new JScrollPane(tree));
        }
        JFrame frame = new JFrame(EASResource.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"17_LowLevelCodeTrees"));
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    private static Set generateTrees(Map computedResults, Map co_reference) {
        int maxLLC = 0;
        Collection refs = co_reference.values();
        LinkedHashSet hasChildrenRootSet = new LinkedHashSet();
        for (Set children : refs) {
            hasChildrenRootSet.addAll(children);
        }
        HashMap parent_children = new HashMap(co_reference.size());
        Iterator<Object> it = co_reference.entrySet().iterator();
        Iterator it2 = hasChildrenRootSet.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Set childParents = (Set)entry.getValue();
            while (it2.hasNext()) {
                String parentID = (String)it2.next();
                if (!childParents.contains(parentID)) continue;
                LinkedHashSet children = (LinkedHashSet)parent_children.get(parentID);
                if (children == null) {
                    children = new LinkedHashSet();
                    children.add(entry.getKey());
                    parent_children.put(parentID, children);
                    continue;
                }
                children.add(entry.getKey());
            }
        }
        LinkedHashSet<JTree> trees = new LinkedHashSet<JTree>();
        Set keys = computedResults.entrySet();
        Iterator ite = keys.iterator();
        Map.Entry entry = null;
        while (ite.hasNext()) {
            entry = ite.next();
            if ((Integer)entry.getValue() != 0 || !hasChildrenRootSet.contains(entry.getKey())) continue;
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(entry.getKey(), true);
            LowLevelCodeTrees.depthFirstBuild(rootNode, 1, computedResults, parent_children, maxLLC);
            JTree aTree = new JTree(rootNode);
            trees.add(aTree);
        }
        return trees;
    }

    private static void depthFirstBuild(DefaultMutableTreeNode parentNode, int sonLevel, Map computedResults, Map co_reference, int maxLLC) {
        Set refs = (Set)co_reference.get(parentNode.getUserObject());
        if (refs == null || refs.isEmpty()) {
            return;
        }
        for (String refedCO : refs) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(refedCO);
            parentNode.add(childNode);
            LowLevelCodeTrees.depthFirstBuild(childNode, sonLevel + 1, computedResults, co_reference, maxLLC);
        }
    }
}

