/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public abstract class NCMClientUtils {
    private static Logger logger = Logger.getLogger((String)NCMClientUtils.class.getName());
    public static final int DEFAULT_PRICISION = 2;
    public static final BigDecimal MAXVAL = new BigDecimal("999999999999.9999");
    public static final BigDecimal MINVAL = new BigDecimal("-999999999999.9999");
    public static final String strTakeOutZeroFormat = "%{0.##########}f";

    public static String getNcmBillResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ncm.common.client.NcmClientBillResource", (String)key);
    }

    public static void checkLoginCompanyOrgIsVirtual() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit()) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource("CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
        }
    }

    public static void menuUpgradeHint() {
        MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource("MenuUpgradeHint"));
        SysUtil.abort();
    }

    public static void setVisible(boolean b, Component[] comps) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setVisible(b);
        }
    }

    public static void setActionVisible(boolean b, ItemAction[] acts) {
        if (acts == null) {
            return;
        }
        for (int i = 0; i < acts.length; ++i) {
            acts[i].setVisible(b);
        }
    }

    public static void setActionEnabled(boolean b, ItemAction[] acts) {
        if (acts == null) {
            return;
        }
        for (int i = 0; i < acts.length; ++i) {
            acts[i].setEnabled(b);
        }
    }

    public static String[] getSelectRowFieldValue(KDTable kdtTable, String fieldname) {
        if (!NCMClientUtils.isSelectRow(kdtTable)) {
            return null;
        }
        KDTSelectManager sm = kdtTable.getSelectManager();
        int blockCount = sm.size();
        int keyField = kdtTable.getColumnIndex(fieldname);
        ArrayList<String> retList = new ArrayList<String>();
        Object value = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                String retStr;
                IRow row = kdtTable.getRow(j);
                value = row.getCell(keyField).getValue();
                if (value == null || value.toString().trim().length() == 0 || retList.contains(retStr = value.toString())) continue;
                retList.add(retStr);
            }
        }
        retList.trimToSize();
        if (retList.size() == 0) {
            return null;
        }
        String[] retStrs = new String[retList.size()];
        retStrs = retList.toArray(retStrs);
        return retStrs;
    }

    public static boolean isSelectRow(KDTable kdtTable) {
        KDTSelectManager sm = kdtTable.getSelectManager();
        return sm.size() > 0;
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, String periodTypeID) {
        NCMClientUtils.filterCompanyOrgForPeriod(prmt, periodTypeID, null);
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, String periodTypeID, CompanyOrgUnitInfo orgInfo) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeID, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, CompanyOrgUnitInfo orgInfo) {
        if (orgInfo == null) {
            throw new IllegalArgumentException("CompanyOrgUnit is NULL !");
        }
        NCMClientUtils.filterCompanyOrgForPeriod(prmt, orgInfo.getAccountPeriodType().getId().toString());
    }

    public static void setFilterForTransactionType(KDBizPromptBox bizPromptBox, String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (number != null) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("billType.number", (Object)number);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(viewInfo);
    }

    public static boolean isValidEntry(KDTable table, String[] cols, int rowIndex) {
        Object val = null;
        if (cols == null) {
            return true;
        }
        for (int i = 0; i < cols.length; ++i) {
            val = table.getCell(rowIndex, cols[i]).getValue();
            if (!(val instanceof BigDecimal ? ((BigDecimal)val).compareTo(SysConstant.BIGZERO) != 0 : val != null)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidEntry(IObjectValue ov, String[] cols) {
        Object val = null;
        if (cols == null) {
            return true;
        }
        for (int i = 0; i < cols.length; ++i) {
            val = ov.get(cols[i]);
            if (!(val instanceof BigDecimal ? ((BigDecimal)val).compareTo(SysConstant.BIGZERO) != 0 : val != null)) continue;
            return true;
        }
        return false;
    }

    public static void setNumberEnabledByCodeRule(IObjectValue caller, DataBinder dataBinder) {
        boolean isModifiable = false;
        boolean isExist = false;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            String orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            isExist = iCodingRuleManager.isExist(caller, orgID);
            if (isExist) {
                isModifiable = iCodingRuleManager.isModifiable(caller, orgID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Component txtNumber = dataBinder.getComponetByField("number");
        if (txtNumber != null) {
            boolean isEnabled = !isExist || isModifiable;
            txtNumber.setEnabled(isEnabled);
        }
        if (txtNumber != null && txtNumber.isEnabled()) {
            txtNumber.requestFocus();
        }
    }

    public static void setNumberByRule(CMBillBaseInfo info, String orgid, KDTextField txtNumber) throws Exception {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist((IObjectValue)info, orgid)) {
            txtNumber.setEnabled(false);
        } else {
            txtNumber.setEnabled(true);
        }
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, IntEnum compareValue) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)compareValue.getValue(), CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, Object compareValue) {
        FilterItemCollection filterItems = null;
        if (f7.getEntityViewInfo() == null) {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            f7.setEntityViewInfo(view);
            filterItems = filter.getFilterItems();
        } else {
            filterItems = f7.getEntityViewInfo().getFilter().getFilterItems();
        }
        filterItems.add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
    }

    public static void filterCostCenterF7(KDBizPromptBox f7, String fieldName, Object compareValue, String companyOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 5);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource("NoCostCenterDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterStorageFromCompanyF7(KDBizPromptBox f7, String fieldName, Object compareValue, String companyOrgID, String storageOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource("NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(storageOrgID, ccIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void iniColumnsPrecision(int precision, String[] fields, IRowSet rowSet) throws SQLException {
        for (int i = 0; i < fields.length; ++i) {
            NCMClientUtils.iniColumnsPrecision(precision, fields[i], rowSet);
        }
    }

    public static void iniColumnsPrecision(int precision, String field, IRowSet rowSet) throws SQLException {
        BigDecimal temp = rowSet.getBigDecimal(field);
        if (temp != null) {
            temp = temp.setScale(precision, 4);
            rowSet.updateObject(field, (Object)temp);
        }
    }

    public static void setTableColumnsFormat(KDTable kdtEntries, String[] strArray, String strFormat) {
        if (strArray == null || strArray.length == 0) {
            return;
        }
        for (int i = 0; i < strArray.length; ++i) {
            if (kdtEntries.getColumn(strArray[i]) == null) continue;
            kdtEntries.getColumn(strArray[i]).getStyleAttributes().setNumberFormat(strFormat);
        }
    }

    public static void changeTableColPrecisionByCurrency(CurrencyInfo currInfo, KDTable table, String[] fieldNames) {
        int precision = currInfo == null ? 2 : currInfo.getPrecision();
        NCMClientUtils.changeTableColPrecisionByCol(precision, table, fieldNames);
    }

    public static void changeTableRowColPrecisionByCurrency(CurrencyInfo currInfo, KDTable table, String[] fieldNames, int rowIndex) {
        int precision = currInfo == null ? 2 : currInfo.getPrecision();
        NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, rowIndex);
    }

    public static void changeTableColPrecisionByCurrency(CurrencyInfo currInfo, KDFormattedTextField[] fieldNames) {
        int precision = currInfo == null ? 2 : currInfo.getPrecision();
        NCMClientUtils.changeTableColPrecision(precision, fieldNames);
    }

    public static void changeTableColPrecisionByMaterial(MaterialInfo materialInfo, KDTable table, String[] fieldNames) {
        int precision = materialInfo == null ? 2 : materialInfo.getPricePrecision();
        NCMClientUtils.changeTableColPrecision(precision, table, fieldNames);
    }

    public static void changeTableRowColPrecisionByMaterial(MaterialInfo[] materialInfos, KDTable table, String[] fieldNames) {
        int num = materialInfos.length;
        for (int i = 0; i < num; ++i) {
            int precision = materialInfos[i] == null ? 2 : materialInfos[i].getPricePrecision();
            NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, i);
        }
    }

    public static void changeTableRowColPrecisionByMaterial(MaterialInfo materialInfo, KDTable table, String[] fieldNames, int rowIndex) {
        int precision = materialInfo == null ? 2 : materialInfo.getPricePrecision();
        NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, rowIndex);
    }

    public static void changeTableColPrecisionByMaterial(MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo, KDTable table, String[] fieldNames, int rowIndex) throws EASBizException, BOSException {
        IMultiMeasureUnit imultiUnit;
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 2;
        if (measureUnitInfo != null && materialInfo != null && (multiUnitInfo = (imultiUnit = MultiMeasureUnitFactory.getRemoteInstance()).getMultiUnit(materialInfo.getId().toString(), measureUnitInfo.getId().toString())) != null) {
            precision = multiUnitInfo.getQtyPrecision();
        }
        NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, rowIndex);
    }

    public static void changeTableColPrecisionByMaterial(MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo, KDTable table, String[] fieldNames) throws EASBizException, BOSException {
        IMultiMeasureUnit imultiUnit;
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 2;
        if (measureUnitInfo != null && materialInfo != null && (multiUnitInfo = (imultiUnit = MultiMeasureUnitFactory.getRemoteInstance()).getMultiUnit(materialInfo.getId().toString(), measureUnitInfo.getId().toString())) != null) {
            precision = multiUnitInfo.getQtyPrecision();
        }
        NCMClientUtils.changeTableColPrecision(precision, table, fieldNames);
    }

    public static void changeTableColPrecisionByMaterial(MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo, KDTable table, String[] fieldNames, int[] rows) throws EASBizException, BOSException {
        IMultiMeasureUnit imultiUnit;
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 2;
        if (measureUnitInfo != null && materialInfo != null && (multiUnitInfo = (imultiUnit = MultiMeasureUnitFactory.getRemoteInstance()).getMultiUnit(materialInfo.getId().toString(), measureUnitInfo.getId().toString())) != null) {
            precision = multiUnitInfo.getQtyPrecision();
        }
        int num = rows.length;
        for (int i = 0; i < num; ++i) {
            NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, rows[i]);
        }
    }

    public static void changeTableRowColPrecisionByMaterial(MaterialInfo[] materialInfos, MeasureUnitInfo[] measureUnitInfos, KDTable table, String[] fieldNames) throws EASBizException, BOSException {
        int precision = 2;
        if (materialInfos == null || measureUnitInfos == null) {
            int num = table.getRowCount();
            for (int i = 0; i < num; ++i) {
                NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, i);
            }
        } else {
            HashMap mulUnitMap = NCMClientUtils.getMultiMeasureUnits(materialInfos, measureUnitInfos);
            MultiMeasureUnitInfo multiUnitInfo = null;
            int num = materialInfos.length;
            for (int i = 0; i < num; ++i) {
                precision = 2;
                if (materialInfos[i] != null && measureUnitInfos[i] != null && (multiUnitInfo = (MultiMeasureUnitInfo)mulUnitMap.get(materialInfos[i].getId().toString() + measureUnitInfos[i].getId().toString())) != null) {
                    precision = multiUnitInfo.getQtyPrecision();
                }
                NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, i);
            }
        }
    }

    public static void changeTableRowColPrecisionByMaterial(MaterialInfo[] materialInfos, MeasureUnitInfo[] measureUnitInfos, KDTable table, String[] fieldNames, int[] rowIndexs) throws EASBizException, BOSException {
        int precision = 2;
        if (materialInfos == null || measureUnitInfos == null) {
            int num = table.getRowCount();
            for (int i = 0; i < num; ++i) {
                NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, i);
            }
        } else {
            HashMap mulUnitMap = NCMClientUtils.getMultiMeasureUnits(materialInfos, measureUnitInfos);
            MultiMeasureUnitInfo multiUnitInfo = null;
            int num = materialInfos.length;
            for (int i = 0; i < num; ++i) {
                precision = 2;
                if (materialInfos[i] != null && measureUnitInfos[i] != null && (multiUnitInfo = (MultiMeasureUnitInfo)mulUnitMap.get(materialInfos[i].getId().toString() + measureUnitInfos[i].getId().toString())) != null) {
                    precision = multiUnitInfo.getQtyPrecision();
                }
                NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, rowIndexs[i]);
            }
        }
    }

    public static KDFormattedTextField changeTableColPrecision(int precision, KDTable table, String[] fieldNames, boolean isNegatived) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setMaximumValue((Comparable)MAXVAL);
        colTxtField.setMinimumValue((Comparable)MINVAL);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setNegatived(isNegatived);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        String colPrecision = PrecisionUtil.getFormatString((int)precision);
        ICell iCell = null;
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            if (table.getColumn(fieldNames[i]) == null) continue;
            int rowCount = table.getRowCount();
            for (int j = 0; j < rowCount; ++j) {
                iCell = table.getRow(j).getCell(fieldNames[i]);
                if (iCell == null) continue;
                iCell.setEditor((ICellEditor)col_CellEditor);
                iCell.getStyleAttributes().setNumberFormat(colPrecision);
                BigDecimal qty = (BigDecimal)iCell.getValue();
                if (qty != null) {
                    qty = qty.setScale(precision, 4);
                }
                iCell.setValue((Object)qty);
            }
        }
        return colTxtField;
    }

    public static KDFormattedTextField changeTableColPrecision(int precision, KDTable table, String[] fieldNames) {
        return NCMClientUtils.changeTableColPrecision(precision, table, fieldNames, false);
    }

    public static KDFormattedTextField changeTableColPrecisionByCol(int precision, KDTable table, String[] fieldNames) {
        return NCMClientUtils.changeTableColPrecisionByCol(precision, table, fieldNames, false);
    }

    public static KDFormattedTextField changeTableColPrecisionByCol(int precision, KDTable table, String[] fieldNames, boolean isNegatived) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setMaximumValue((Comparable)MAXVAL);
        colTxtField.setMinimumValue((Comparable)MINVAL);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setNegatived(isNegatived);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        String colPrecision = PrecisionUtil.getFormatString((int)precision);
        IColumn aColumn = null;
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            aColumn = table.getColumn(fieldNames[i]);
            if (aColumn == null) continue;
            aColumn.setEditor((ICellEditor)col_CellEditor);
            aColumn.getStyleAttributes().setNumberFormat(colPrecision);
        }
        return colTxtField;
    }

    public static void changeTableColPrecision(int precision, KDFormattedTextField[] fieldNames) {
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            fieldNames[i].setPrecision(precision);
            fieldNames[i].setRemoveingZeroInDispaly(false);
            fieldNames[i].setSupportedEmpty(true);
        }
    }

    public static KDFormattedTextField changeTableColPrecision(int precision, KDTable table, String[] fieldNames, int rowIndex) {
        if (precision < 0) {
            precision = 2;
        }
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setMaximumValue((Comparable)MAXVAL);
        colTxtField.setMinimumValue((Comparable)MINVAL);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setNegatived(false);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        String colPrecision = PrecisionUtil.getFormatString((int)precision);
        ICell iCell = null;
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            iCell = table.getCell(rowIndex, fieldNames[i]);
            if (iCell == null) continue;
            iCell.setEditor((ICellEditor)col_CellEditor);
            iCell.getStyleAttributes().setNumberFormat(colPrecision);
            iCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            BigDecimal qty = (BigDecimal)iCell.getValue();
            if (qty != null) {
                qty = qty.setScale(precision, 4);
            }
            iCell.setValue((Object)qty);
        }
        return colTxtField;
    }

    public static String getMultiMeasureUnitOQL(String[] matId, String[] mUnitId) {
        String oqlWhere = "material.id = null or measureUnit.id = null";
        boolean isFirst = true;
        int size = matId.length;
        for (int i = 0; i < size; ++i) {
            if (StringUtils.isEmpty((String)matId[i]) || StringUtils.isEmpty((String)mUnitId[i])) continue;
            if (isFirst) {
                isFirst = false;
                oqlWhere = "(material.id = '" + matId[i] + "' and measureUnit.id = '" + mUnitId[i] + "')";
                continue;
            }
            oqlWhere = oqlWhere + " or (material.id = '" + matId[i] + "' and measureUnit.id = '" + mUnitId[i] + "')";
        }
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return oqlWhere;
        }
        oqlWhere = "select material.id, measureUnit.id, qtyPrecision where " + oqlWhere;
        return oqlWhere;
    }

    private static String getMultiMeasureUnitOQL(MaterialInfo[] materialInfos, MeasureUnitInfo[] measureUnitInfos) {
        StringBuffer oqlWhere = new StringBuffer();
        boolean isFirst = true;
        String materialID = null;
        String mesureUnitID = null;
        int size = materialInfos.length;
        for (int i = 0; i < size; ++i) {
            if (materialInfos[i] == null || measureUnitInfos[i] == null) continue;
            materialID = materialInfos[i].getId().toString();
            mesureUnitID = measureUnitInfos[i].getId().toString();
            if (StringUtils.isEmpty((String)materialID) || StringUtils.isEmpty((String)mesureUnitID)) continue;
            if (isFirst) {
                isFirst = false;
                oqlWhere.append("(material.id = '" + materialID + "' and measureUnit.id = '" + mesureUnitID + "')");
                continue;
            }
            oqlWhere.append(" or (material.id = '" + materialID + "' and measureUnit.id = '" + mesureUnitID + "')");
        }
        if (oqlWhere.length() == 0) {
            return oqlWhere.toString();
        }
        return "select material.id, measureUnit.id, qtyPrecision where " + oqlWhere.toString();
    }

    public static HashMap getMultiMeasureUnits(String[] materialId, String[] measureUnitId) throws BOSException {
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        String oqlWhere = NCMClientUtils.getMultiMeasureUnitOQL(materialId, measureUnitId);
        HashMap<String, MultiMeasureUnitInfo> mulUnitsMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return mulUnitsMap;
        }
        MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oqlWhere);
        MultiMeasureUnitInfo mulUnitInfo = null;
        int num = mulUnits.size();
        for (int i = 0; i < num; ++i) {
            mulUnitInfo = mulUnits.get(i);
            mulUnitsMap.put(mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString(), mulUnitInfo);
        }
        return mulUnitsMap;
    }

    public static HashMap getMultiMeasureUnits(MaterialInfo[] materialInfos, MeasureUnitInfo[] measureUnitInfos) throws BOSException {
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        String oqlWhere = NCMClientUtils.getMultiMeasureUnitOQL(materialInfos, measureUnitInfos);
        HashMap<String, MultiMeasureUnitInfo> mulUnitsMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return mulUnitsMap;
        }
        MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oqlWhere);
        MultiMeasureUnitInfo mulUnitInfo = null;
        int num = mulUnits.size();
        for (int i = 0; i < num; ++i) {
            mulUnitInfo = mulUnits.get(i);
            mulUnitsMap.put(mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString(), mulUnitInfo);
        }
        return mulUnitsMap;
    }

    public static void filterCostObjectF7(KDBizPromptBox f7, String companyOrgID) {
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)f7, (String)companyOrgID);
    }

    public static void checkIsStart() throws BOSException, EASBizException {
        String companyId;
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    public static void checkIsStart_OrderCost() throws BOSException, EASBizException {
        String companyId;
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1010, companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            throw new CMBillException(CMBillException.ORDERCOST_NOTON);
        }
    }

    public static void changeTableColPrecisionByCostObject(CostObjectInfo costObjectInfo, KDTable table, String[] fieldNames, int rowIndex) throws EASBizException, BOSException {
        if (costObjectInfo == null) {
            throw new IllegalArgumentException();
        }
        BOSUuid id = costObjectInfo.getStdProductID().getId();
        if (id != null) {
            IMaterial im = MaterialFactory.getRemoteInstance();
            MaterialInfo materialInfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(id));
            NCMClientUtils.changeTableColPrecisionByMaterial(materialInfo, materialInfo.getBaseUnit(), table, fieldNames, rowIndex);
        }
    }

    public static void setDefaultPeriodForClosePeriod(KDBizPromptBox company, KDBizPromptBox period) {
        try {
            if (company.getValue() != null) {
                String companyId = ((CompanyOrgUnitInfo)company.getValue()).getId().toString();
                if (SystemStatusCtrolFactory.getRemoteInstance().isStart(1001, companyId)) {
                    period.setValue((Object)SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, companyId));
                    period.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static void setDefaultPeriodForPeriod(KDBizPromptBox company, KDBizPromptBox period) {
        try {
            if (company.getValue() != null) {
                String companyId = ((CompanyOrgUnitInfo)company.getValue()).getId().toString();
                if (SystemStatusCtrolFactory.getRemoteInstance().isStart(1001, companyId)) {
                    period.setValue((Object)SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, companyId));
                    period.setEnabled(false);
                } else {
                    MsgBox.showInfo((String)(((CompanyOrgUnitInfo)company.getValue()).getName() + EASResource.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"18_NCMClientUtils")));
                    company.setValue(null);
                    period.setValue(null);
                    SysUtil.abort();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static void setDefaultPeriodForClosePeriodCan(KDBizPromptBox company, KDBizPromptBox period) {
        try {
            if (company.getValue() != null) {
                String companyId = ((CompanyOrgUnitInfo)company.getValue()).getId().toString();
                if (SystemStatusCtrolFactory.getRemoteInstance().isStart(1001, companyId)) {
                    period.setValue((Object)SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, companyId));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static String getNumberFormat(int precision, boolean fNegativeSign) {
        StringBuffer format = new StringBuffer(8);
        format.append("%").append(fNegativeSign ? "-" : "_").append("[].").append(precision).append("n");
        return format.toString();
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision) {
        if (column != null) {
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)NCMClientUtils.getBigDecimalTextField(precision, null)));
            column.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision, boolean negatived) {
        if (column != null) {
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)NCMClientUtils.getBigDecimalTextField(precision, null, negatived)));
            column.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
        }
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision, BigDecimal maxValue) {
        return NCMClientUtils.getBigDecimalTextField(precision, maxValue, true);
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision, BigDecimal maxValue, boolean negatived) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setNegatived(negatived);
        colTxtField.setHorizontalAlignment(4);
        if (NCMClientUtils.isNotNull(maxValue)) {
            colTxtField.setMaximumValue((Comparable)maxValue);
        } else {
            colTxtField.setMaximumValue((Comparable)MAXVAL);
        }
        return colTxtField;
    }

    public static String getNumberFtm(int preCurrency) {
        StringBuffer numberFormate = new StringBuffer("##,###,###,###,###,##0.");
        for (int i = 0; i < preCurrency; ++i) {
            numberFormate.append("0");
        }
        return numberFormate.toString();
    }

    public static void setNumberFormat(IRow row, String columnKey, int preCurrency) {
        String numberFormat = NCMClientUtils.getNumberFtm(preCurrency);
        StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
        styleAttributes.setNumberFormat(numberFormat);
        styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision) {
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell(cell, precision, true);
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision, boolean negatived) {
        if (cell != null) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)NCMClientUtils.getBigDecimalTextField(precision, null, negatived)));
            cell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
            Object numberObj = cell.getValue();
            if (numberObj instanceof BigDecimal) {
                BigDecimal number = ((BigDecimal)numberObj).setScale(precision, 4);
                cell.setValue((Object)number);
            }
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNotNull(Object o) {
        return !NCMClientUtils.isNull(o);
    }

    public static void addLLCListUI(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift alt L"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.ncm.cal.client.CostObjectRankListUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    public static void addNCMDebugUI(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift alt D"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.ncm.common.debug.client.NCMDebugUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    public static boolean isLogin(Component parentComponent) throws EASBizException {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            return true;
        }
        try {
            userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"49_FMIsqlUI"), pwd};
        int res = JOptionPane.showConfirmDialog(parentComponent, message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        return PermissionUtils.matchPassword((UserInfo)userInfo, (String)String.valueOf(pwd.getPassword()));
    }

    public static RuleStatus getCodingRuleAttr(CMBillBaseInfo cMBillBaseInfo) throws EASBizException, BOSException {
        RuleStatus ruleStatus = CodingRuleManagerFactory.getRemoteInstance().getRuleStatus((IObjectValue)cMBillBaseInfo, cMBillBaseInfo.getCompanyOrg().getId().toString());
        return ruleStatus;
    }

    public static void requestMutex(CoreUI ui, String comID) {
        try {
            ui.setOprtState("CLOSING");
            ui.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            ui.handUIException(t);
            SysUtil.abort();
        }
    }

    public static void releaseMutex(CoreUI ui, String comID) {
        ui.setOprtState("RELEASEALL");
        try {
            ui.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            ui.handUIException(t);
        }
    }

    public static void checkIsIncludeCostAdjustData() {
        if (!NCMUtils.isIncludeCostAdjustData(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            MsgBox.showError((String)"\u8d22\u52a1\u7ec4\u7ec7\u8bbe\u7f6e\u4e86\u201c\u6210\u672c\u8c03\u6574\u5355\u4e0d\u53c2\u4e0e\u751f\u4ea7\u6210\u672c\u8ba1\u7b97\u201d\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u53c2\u6570\u3002");
            SysUtil.abort();
        }
    }

    public static void setManufactureF7(KDBizPromptBox prmtManufactureOrder, String companyID) throws EASBizException, BOSException {
        ExtendParser parserManufactureOrder = new ExtendParser(prmtManufactureOrder);
        prmtManufactureOrder.setCommitParser((IParser)parserManufactureOrder);
        prmtManufactureOrder.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        prmtManufactureOrder.setEditable(true);
        prmtManufactureOrder.setDisplayFormat("$number$");
        prmtManufactureOrder.setEditFormat("$number$");
        prmtManufactureOrder.setCommitFormat("$number$");
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)prmtManufactureOrder, (String)companyID);
    }

    public static void setMaterialF7(KDBizPromptBox prmtMaterial, String companyID) throws EASBizException, BOSException {
        ExtendParser parserPorduct = new ExtendParser(prmtMaterial);
        prmtMaterial.setCommitParser((IParser)parserPorduct);
        prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MaterialCostObjectQuery");
        prmtMaterial.setEditable(true);
        prmtMaterial.setDisplayFormat("$number$");
        prmtMaterial.setEditFormat("$number$");
        prmtMaterial.setCommitFormat("$number$");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1)));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.CreateCOByOrder", (Object)"0"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmtMaterial.setEntityViewInfo(view);
        FilterInfo filterPrmt = prmtMaterial.getEntityViewInfo().getFilter();
        filterPrmt.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(1), CompareType.EQUALS));
        NCMUtils.materialTreeDisplay(null, prmtMaterial, filterPrmt);
    }

    public static void setCostObjectF7(KDBizPromptBox prmtCostObject, String companyID) throws EASBizException, BOSException {
        ExtendParser parserCostObject = new ExtendParser(prmtCostObject);
        prmtCostObject.setCommitParser((IParser)parserCostObject);
        prmtCostObject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector(null, prmtCostObject, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, companyID);
        prmtCostObject.setSelector((KDPromptSelector)arg0);
        prmtCostObject.setEditable(true);
        prmtCostObject.setDisplayFormat("$number$");
        prmtCostObject.setEditFormat("$number$");
        prmtCostObject.setCommitFormat("$number$");
    }

    public static CostObjectInfo getCostObjectAllInfo(CostObjectInfo costObjectInfo) throws EASBizException, BOSException {
        if (costObjectInfo == null || costObjectInfo.getId() == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("batchNumber"));
        sic.add(new SelectorItemInfo("StdProductID.id"));
        sic.add(new SelectorItemInfo("StdProductID.number"));
        sic.add(new SelectorItemInfo("StdProductID.name"));
        costObjectInfo = CostObjectFactory.getRemoteInstance().getCostObjectInfo((IObjectPK)new ObjectUuidPK(costObjectInfo.getId()), sic);
        return costObjectInfo;
    }

    public static ManufactureOrderInfo getManufactureByCostObject(CostObjectInfo costObjectInfo) throws EASBizException, BOSException {
        if (costObjectInfo == null || costObjectInfo.getOrderID() == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("trackNumber"));
        ManufactureOrderInfo manufactureOrderInfo = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(costObjectInfo.getOrderID()), sic);
        return manufactureOrderInfo;
    }

    public static void addSqlMenu(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift Q"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.ncm.common.debug.client.NCMsqlUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    public static void addNCMDataToolUI(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl F9"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.ncm.common.client.DataToolSolutionUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    public static void selectFirstRow(KDTable table) {
        if (EmptyUtil.isEmpty((Object)table) || table.getRow(0) == null) {
            return;
        }
        table.getSelectManager().select(0, 0);
    }
}

