/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.utils.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ncm.common.utils.SortUtil;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OrgUnitClientUtils {
    private static Logger logger = Logger.getLogger((String)OrgUnitClientUtils.class.getName());
    public static final Map orgF7Query = new HashMap();

    public static void setOrgF7IsEntity(KDBizPromptBox bizBox) {
        if (bizBox == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (bizBox.getEntityViewInfo() != null) {
            viewInfo = bizBox.getEntityViewInfo();
        }
        FilterInfo filterInfo = new FilterInfo();
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(filterInfo);
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        bizBox.setEntityViewInfo(viewInfo);
    }

    public static void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        OrgUnitClientUtils.setMainBizOrgF7(bizOrgUnitBox, orgType, null);
    }

    public static void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType, String[] permissionItemKeyString) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        iProducer.getModel().setShowVirtual(false);
        if (permissionItemKeyString != null && permissionItemKeyString.length > 0) {
            iProducer.getModel().setPermissionItem(permissionItemKeyString[0]);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        bizOrgUnitBox.setDisplayFormat("$name$");
        bizOrgUnitBox.setEditFormat("$number$");
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
    }

    public static OrgUnitInfo getBizOrgUnit(UserInfo userInfo, OrgType orgType, String permissionItem, OrgUnitInfo orgUnitInfo) {
        if (orgUnitInfo == null) {
            return null;
        }
        OrgUnitInfo bizSaleOrgUnitInfo = null;
        if (orgUnitInfo.getBoolean("isBizUnit")) {
            bizSaleOrgUnitInfo = orgUnitInfo;
        } else {
            try {
                OrgUnitInfo[] mainOrgs = null;
                FullOrgUnitCollection collection = OrgUnitClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(userInfo.getId().toString()), orgType, permissionItem);
                mainOrgs = SCMGroupClientUtils.getOrgUnitInfosByType((FullOrgUnitCollection)collection, (OrgType)orgType);
                if (mainOrgs == null) {
                    return null;
                }
                if (mainOrgs.length > 0) {
                    mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
                }
                bizSaleOrgUnitInfo = mainOrgs[0];
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return bizSaleOrgUnitInfo;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        ObjectUuidPK cuPk = null;
        if (cu != null) {
            cuPk = new ObjectUuidPK(cu.getId());
        }
        result = permission.getAuthorizedOrgOfIncludeSubCU((IObjectPK)cuPk, user, orgType, null, permItem);
        return result;
    }

    public static OrgUnitInfo getBizOrgUnitInfo(String addNewPermItemName, OrgType orgType, Context mainOrgContext) {
        if (addNewPermItemName == null || mainOrgContext == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mainOrgContext.get((Object)orgType);
        OrgUnitInfo retOrgUnitInfo = null;
        retOrgUnitInfo = OrgUnitClientUtils.getBizOrgUnit(SysContext.getSysContext().getCurrentUserInfo(), orgType, addNewPermItemName, orgUnitInfo);
        return retOrgUnitInfo;
    }

    public static OrgUnitInfo getBizOrgUnitInfo(String addNewPermItemName, OrgType orgType, OrgUnitInfo orgUnitInfo) {
        if (addNewPermItemName == null || orgUnitInfo == null) {
            return null;
        }
        OrgUnitInfo retOrgUnitInfo = null;
        retOrgUnitInfo = OrgUnitClientUtils.getBizOrgUnit(SysContext.getSysContext().getCurrentUserInfo(), orgType, addNewPermItemName, orgUnitInfo);
        return retOrgUnitInfo;
    }

    static {
        orgF7Query.put(OrgType.Storage, "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        orgF7Query.put(OrgType.Purchase, "com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery");
        orgF7Query.put(OrgType.Sale, "com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery");
        orgF7Query.put(OrgType.Company, "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        orgF7Query.put(OrgType.Admin, "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
    }
}

