/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.verify;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.ncm.common.utils.ArrayListMap;
import com.kingdee.eas.ncm.common.utils.ArrayMap;
import com.kingdee.eas.ncm.common.utils.SortUtil;
import com.kingdee.eas.ncm.common.verify.BatchVerifyItem;
import com.kingdee.eas.ncm.common.verify.VerifyType;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MaterialInventoryVerifyItem
extends BatchVerifyItem {
    public MaterialInventoryVerifyItem(Component component, VerifyType verifyType, Object compareValue, String errMsg) {
        super(component, verifyType, compareValue, errMsg);
    }

    public MaterialInventoryVerifyItem(Component component) {
        super(component);
    }

    @Override
    protected boolean doVerify() throws Exception {
        ArrayMap miMap = this.getMaterialInventoryMap();
        ArrayList<Object> rowList = new ArrayList<Object>();
        if (miMap != null && miMap.size() > 0) {
            Object[] storages = miMap.keySet().toArray();
            for (int i = 0; i < storages.length; ++i) {
                Object[] materials = miMap.getArray(storages[i], 0);
                String[] materialIds = new String[materials.length];
                System.arraycopy(materials, 0, materialIds, 0, materials.length);
                List result = MaterialInventoryFactory.getRemoteInstance().getMaterialsExistInvInfo(materialIds, (String)storages[i]);
                if (result == null) {
                    rowList.addAll((Collection)miMap.get(storages[i], 1));
                    continue;
                }
                if (result.size() >= materials.length) continue;
                Object[] rows = miMap.getArray(storages[i], 1);
                for (int j = 0; j < rows.length; ++j) {
                    if (result.indexOf(materials[j]) != -1) continue;
                    rowList.add(rows[j]);
                }
            }
            if (rowList.size() > 0) {
                Object[] rows = SortUtil.sortArrayByIntValue(rowList.toArray(), true);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < rows.length; ++i) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(rows[i]);
                }
                return !this.isError(sb);
            }
        }
        return true;
    }

    public ArrayMap getMaterialInventoryMap() {
        String colMaterial = (String)this.columns.get("MATERIAL");
        String colStorage = (String)this.columns.get("STORAGEORGUNIT");
        if (this.component instanceof KDTable && colMaterial != null && colStorage != null) {
            ArrayListMap map = new ArrayListMap(2);
            KDTable table = (KDTable)this.component;
            for (int i = 0; i < table.getRowCount(); ++i) {
                IRow arow = table.getRow(i);
                MaterialInfo materialInfo = (MaterialInfo)arow.getCell(colMaterial).getValue();
                StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)arow.getCell(colStorage).getValue();
                if (materialInfo == null || storageInfo == null) continue;
                map.put(storageInfo.getId().toString(), new Object[]{materialInfo.getId().toString(), i + 1});
            }
            return map;
        }
        return null;
    }
}

