/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.cal.report.client.NCMReportFilterUI;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.report.client.AbstractSTDCostSumReportFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.HashSet;

public class STDCostSumReportFilterUI
extends AbstractSTDCostSumReportFilterUI {
    private static final long serialVersionUID = 6190849618491033224L;
    private CompanyOrgUnitInfo company = null;
    private static final String _prmtStorageOrg = "prmtStorageOrg";
    private static final String _prmtScheme = "prmtScheme";
    private static final String _prmtMaterial = "prmtMaterial";
    private CustomerParams cp = null;

    public STDCostSumReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, this.company.getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new NCMReportFilterUI.SingleComPromptFilterElement((NCMReportFilterUI)this, "companyOrg", this.prmtCompany));
        elements.add((FilterElement)new F7SingleFilterElement("storageOrgUnits", (Component)this.prmtStorageOrg));
        elements.add((FilterElement)new F7SingleFilterElement("estimateSchemes", (Component)this.prmtScheme));
        elements.add((FilterElement)new SingleFilterElement("calcuType", (Component)this.calcTypeComboBox));
        elements.add((FilterElement)new F7SingleFilterElement("materials", (Component)this.prmtMaterial));
        return elements;
    }

    private void init() throws Exception {
        this.prmtCompany.setValue((Object)this.company);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterial, null);
        MaterialF7TreeListSelector selector1 = new MaterialF7TreeListSelector((Object)this, this.prmtMaterial);
        this.prmtMaterial.setSelector((KDPromptSelector)selector1);
        this.f7ContextManager.registerStorageF7(this.prmtStorageOrg);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtScheme, "com.kingdee.eas.ncm.std.basedata.app.STDCostEstimateSchemeQuery", "company.id");
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtStorageOrg.setValue(null);
                this.prmtScheme.setValue(null);
                this.calcTypeComboBox.setSelectedIndex(0);
                this.prmtMaterial.setValue(null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected String getReportViewPermissionItem() {
        return "STDCostTotalReport";
    }

    protected String getReportPrintPermissionItem() {
        return "STDCostTotalReportPrint";
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadStorageOrg(params);
            this.loadScheme(params);
            this.loadMaterial1(params);
            this.loadalcType(params);
        }
    }

    private void loadStorageOrg(CustomerParams params) {
        String storage = "";
        if (params.getCustomerParam(_prmtStorageOrg) != null) {
            storage = params.getCustomerParam(_prmtStorageOrg);
        }
        if (StringUtils.isEmpty((String)storage)) {
            this.prmtStorageOrg.setData(null);
            return;
        }
        String[] storageNumbers = storage.split(";");
        HashSet<String> storageNumbersSet = new HashSet<String>();
        for (int i = 0; i < storageNumbers.length; ++i) {
            storageNumbersSet.add(storageNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", storageNumbersSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        StorageOrgUnitCollection storageOrgUnitCol = null;
        try {
            storageOrgUnitCol = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
            if (storageOrgUnitCol != null && storageOrgUnitCol.size() > 0) {
                int size = storageOrgUnitCol.size();
                StorageOrgUnitInfo[] storages = new StorageOrgUnitInfo[size];
                for (int i = 0; i < size; ++i) {
                    storages[i] = storageOrgUnitCol.get(i);
                }
                this.prmtStorageOrg.setData((Object)storages);
            }
        }
        catch (BOSException e) {
            this.prmtStorageOrg.setData(null);
        }
    }

    private void loadScheme(CustomerParams params) {
        String scheme = "";
        if (params.getCustomerParam(_prmtScheme) != null) {
            scheme = params.getCustomerParam(_prmtScheme);
        }
        if (StringUtils.isEmpty((String)scheme)) {
            this.prmtScheme.setData(null);
            return;
        }
        String[] schemeNumbers = scheme.split(";");
        HashSet<String> schemeNumbersSet = new HashSet<String>();
        for (int i = 0; i < schemeNumbers.length; ++i) {
            schemeNumbersSet.add(schemeNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", schemeNumbersSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        STDCostEstimateSchemeCollection schemeCol = null;
        try {
            schemeCol = STDCostEstimateSchemeFactory.getRemoteInstance().getSTDCostEstimateSchemeCollection(view);
            if (schemeCol != null && schemeCol.size() > 0) {
                int size = schemeCol.size();
                STDCostEstimateSchemeInfo[] schemes = new STDCostEstimateSchemeInfo[size];
                for (int i = 0; i < size; ++i) {
                    schemes[i] = schemeCol.get(i);
                }
                this.prmtScheme.setData((Object)schemes);
            }
        }
        catch (BOSException e) {
            this.prmtScheme.setData(null);
        }
    }

    private void loadMaterial1(CustomerParams params) {
        String material = "";
        if (params.getCustomerParam(_prmtMaterial) != null) {
            material = params.getCustomerParam(_prmtMaterial);
        }
        if (StringUtils.isEmpty((String)material)) {
            this.prmtMaterial.setData(null);
            return;
        }
        String[] matNumbers = material.split(";");
        HashSet<String> matNumbersSet = new HashSet<String>();
        for (int i = 0; i < matNumbers.length; ++i) {
            matNumbersSet.add(matNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.number", matNumbersSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.name"));
        sic.add(new SelectorItemInfo("mateial.number"));
        view.setSelector(sic);
        MaterialCompanyInfoCollection expenseColl = null;
        try {
            expenseColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(view);
            if (expenseColl != null && expenseColl.size() > 0) {
                int size = expenseColl.size();
                MaterialInfo[] materials = new MaterialInfo[size];
                for (int i = 0; i < size; ++i) {
                    materials[i] = expenseColl.get(i).getMateial();
                }
                this.prmtMaterial.setData((Object)materials);
            }
        }
        catch (BOSException e) {
            this.prmtMaterial.setData(null);
        }
    }

    private void loadalcType(CustomerParams params) {
        int index = 0;
        try {
            if (params.getCustomerParam("calcTypeComboBox") != null && (index = Integer.parseInt(params.getCustomerParam("calcTypeComboBox")) + 1) >= this.calcTypeComboBox.getItemCount()) {
                index = 0;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.calcTypeComboBox.setSelectedIndex(index);
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    class F7SingleFilterElement
    extends SingleFilterElement {
        public F7SingleFilterElement(String id, Component component) {
            super(id, component);
        }

        protected void setNumber(Object obj, String value) {
            ((KDBizPromptBox)obj).setData((Object)value);
        }
    }
}

