/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.qm.basedata.QCAQLSetInfo;
import com.kingdee.eas.qm.basedata.client.AbstractQCAQLSetEditUI;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.qm.common.client.ccstrategy.IQMClientControlStrategy;
import com.kingdee.eas.qm.common.client.ccstrategy.QMClientControlStrategy;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

public class QCAQLSetEditUI
extends AbstractQCAQLSetEditUI {
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtaqlValue.setPrecision(8);
        this.txtaqlValue.setMinimumValue((Comparable)new BigDecimal("0.00000001"));
        this.txtaqlValue.setMaximumValue((Comparable)QMPrecisionUtil.BigDecimal_MaxValue);
    }

    private void checkSystemSet(String MsgInfo) {
        if (this.editData.isSystemSet()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCAQLSetResource", (String)MsgInfo));
            SysUtil.abort();
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSystemSet("AQLVALUEISSYSTEMSET_EDIT");
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSystemSet("AQLVALUEISSYSTEMSET_DELETE");
        super.actionRemove_actionPerformed(e);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSystemSet("AQLVALUEISSYSTEMSET_AUDIT");
        this.checkPermission("ACTION_AUDIT", this.getCUIDFromBizobject());
        super.actionAudit_actionPerformed(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSystemSet("AQLVALUEISSYSTEMSET_UNAUDIT");
        this.checkPermission("ACTION_UNAUDIT", this.getCUIDFromBizobject());
        super.actionUnAudit_actionPerformed(e);
    }

    private String getCUIDFromBizobject() throws Exception {
        return this.getICGF().getCUID(this.editData.getId().toString());
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    private void checkPermission(String action, String cuID) throws Exception {
        IQMClientControlStrategy stategy = this.getClientControlStrategy();
        if (stategy instanceof QMClientControlStrategy) {
            ((QMClientControlStrategy)stategy).checkPermission(action, cuID);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData(null);
        return data;
    }

    protected IObjectValue newInstanceData() {
        QCAQLSetInfo objectValue = new QCAQLSetInfo();
        return objectValue;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        QCAQLSetInfo info = (QCAQLSetInfo)arg0;
        info.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        info.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        info.setSystemSet(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BigDecimal zeno = new BigDecimal("0.0");
        BigDecimal aqlvalue = null;
        aqlvalue = new BigDecimal(this.txtaqlValue.getNumberValue().toString());
        if (zeno.compareTo(aqlvalue) >= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCAQLSetResource", (String)"MUST_MOREZONE"));
            this.txtaqlValue.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("systemSet"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("aqlValue"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        return sic;
    }

    protected boolean isSuportAudit() {
        return true;
    }
}

