/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IQualityOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitCollection;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.qm.basedata.IQCGroup;
import com.kingdee.eas.qm.basedata.QCGroupCollection;
import com.kingdee.eas.qm.basedata.QCGroupFactory;
import com.kingdee.eas.qm.basedata.QCGroupInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class QCGroupTreeBuilder {
    Icon groupIcon = EASResource.getIcon((String)"imgTree_businessgroup");
    Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    KDTreeNode lastExpandnode = null;
    KDTreeNode expandnode = null;
    private QualityOrgUnitInfo topQualityOrgUnitInfo = null;
    private Map orgInfoCache = new HashMap();

    public QCGroupTreeBuilder() {
    }

    public QCGroupTreeBuilder(KDTreeNode Lastnode) {
        this.lastExpandnode = Lastnode;
    }

    public KDTreeNode getLastExpandnode() {
        return this.lastExpandnode;
    }

    public JTree buildtree(KDTree tree) throws Exception {
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)((Object)this.createInitRootNode())));
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                    QCGroupTreeBuilder.this.getChildren(tree, treeNode);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    public void refreshChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        this.innerRefreshChildren(tree, treeNode);
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            this.innerRefreshChildren(tree, treeNode);
            treeNode.setVirtual(false);
        }
    }

    private void innerRefreshChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        TreeBaseInfo treeNodeInfo = null;
        if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
        }
        tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
        if (treeNodeInfo instanceof QCGroupInfo) {
            QCGroupCollection col = this.getChildQCGroup((QCGroupInfo)treeNodeInfo);
            this.buildChildren(tree, col, treeNode);
        } else if (treeNodeInfo instanceof QualityOrgUnitInfo) {
            QCGroupCollection col = this.getChildQCGroup((QualityOrgUnitInfo)treeNodeInfo);
            QualityOrgUnitCollection orgCol = this.getChildQualityOrg((QualityOrgUnitInfo)treeNodeInfo);
            this.buildChildren(tree, col, orgCol, treeNode);
        }
    }

    private QCGroupCollection getChildQCGroup(QCGroupInfo groupInfo) throws Exception {
        String longNumber = groupInfo.getLongNumber();
        int level = groupInfo.getLevel();
        EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
        IQCGroup iGroup = QCGroupFactory.getRemoteInstance();
        QCGroupCollection groupCollect = iGroup.getQCGroupCollection(viewInfo);
        return groupCollect;
    }

    private QCGroupCollection getChildQCGroup(QualityOrgUnitInfo orgInfo) throws Exception {
        EntityViewInfo viewInfo = this.getChildGroupFilter(orgInfo);
        IQCGroup iGroup = QCGroupFactory.getRemoteInstance();
        QCGroupCollection groupCollection = iGroup.getQCGroupCollection(viewInfo);
        return groupCollection;
    }

    private boolean isHasChildQCGroup(QualityOrgUnitInfo orgInfo) throws Exception {
        EntityViewInfo viewInfo = this.getChildGroupFilter(orgInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.qm.basedata.app.QCGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rowSet = queryExcu.executeQuery();
        return rowSet.next();
    }

    private boolean isHasChildQCGroup(List list, QualityOrgUnitInfo orgInfo) {
        String id = orgInfo.getId().toString();
        return list.contains(id);
    }

    private QualityOrgUnitCollection getChildQualityOrg(QualityOrgUnitInfo orgInfo) throws Exception {
        String longNumber = orgInfo.getLongNumber();
        int level = orgInfo.getLevel();
        EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
        SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterInfo);
        QualityOrgUnitCollection tmpCollection = null;
        tmpCollection = QualityOrgUnitFactory.getRemoteInstance().getQualityOrgUnitCollection(viewInfo);
        tmpCollection = this.removeNoPermissionOrg(tmpCollection);
        List qualityOrgUnitIDList = this.getQuiltyOrgUnitIdInQCGroup(tmpCollection, 1);
        QualityOrgUnitCollection orgCollection = new QualityOrgUnitCollection();
        Iterator iter = tmpCollection.iterator();
        while (null != iter && iter.hasNext()) {
            QualityOrgUnitInfo orginfo = (QualityOrgUnitInfo)iter.next();
            if (orginfo.isIsLeaf() && this.isHasChildQCGroup(qualityOrgUnitIDList, orginfo)) {
                orginfo.setIsLeaf(false);
            }
            orgCollection.add(orginfo);
        }
        return orgCollection;
    }

    private void buildChildren(KDTree tree, QCGroupCollection groupCollection, QualityOrgUnitCollection orgCollection, KDTreeNode parentNode) {
        if (parentNode.getUserObject() instanceof QualityOrgUnitInfo) {
            int index;
            QCGroupTreeNode tempParentNode;
            QCGroupTreeNode node;
            int i;
            int num;
            parentNode.removeAllChildren();
            HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
            QualityOrgUnitInfo parentOrgInfo = (QualityOrgUnitInfo)parentNode.getUserObject();
            nodeMap.put(parentOrgInfo.getId().toString(), parentNode);
            if (orgCollection != null && orgCollection.size() > 0) {
                num = orgCollection.size();
                for (i = 0; i < num; ++i) {
                    QualityOrgUnitInfo orgInfo = orgCollection.get(i);
                    node = new QCGroupTreeNode(orgInfo);
                    if (!orgInfo.isIsLeaf()) {
                        QCGroupInfo tempQCGroupInfo = this.getEmptyGroupNode();
                        node.add((MutableTreeNode)((Object)new QCGroupTreeNode(tempQCGroupInfo)));
                        node.setAllowsChildren(true);
                    }
                    node.setCustomIcon(this.companyIcon);
                    node.setVirtual(true);
                    nodeMap.put(orgInfo.getId().toString(), node);
                    if (orgInfo.getParent() == null || !nodeMap.containsKey(orgInfo.getParent().getId().toString())) continue;
                    tempParentNode = (QCGroupTreeNode)((Object)nodeMap.get(orgInfo.getParent().getId().toString()));
                    index = tempParentNode.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
                }
            }
            if (groupCollection != null && groupCollection.size() > 0) {
                num = groupCollection.size();
                for (i = 0; i < num; ++i) {
                    QCGroupInfo groupInfo = groupCollection.get(i);
                    node = new QCGroupTreeNode(groupInfo);
                    if (!groupInfo.isIsLeaf()) {
                        QualityOrgUnitInfo tempQualityOrgInfo = this.getEmptyNode();
                        node.add((MutableTreeNode)((Object)new QCGroupTreeNode(tempQualityOrgInfo)));
                    }
                    node.setCustomIcon(this.groupIcon);
                    node.setVirtual(true);
                    nodeMap.put(groupInfo.getId().toString(), node);
                    if (groupInfo.getQualityOrgUnit() == null || !nodeMap.containsKey(groupInfo.getQualityOrgUnit().getId().toString())) continue;
                    tempParentNode = (QCGroupTreeNode)((Object)nodeMap.get(groupInfo.getQualityOrgUnit().getId().toString()));
                    index = tempParentNode.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
                }
            }
        }
    }

    private QualityOrgUnitInfo getEmptyNode() {
        QualityOrgUnitInfo tempQualityOrgInfo = new QualityOrgUnitInfo();
        tempQualityOrgInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
        tempQualityOrgInfo.setName("");
        return tempQualityOrgInfo;
    }

    private void buildChildren(KDTree tree, QCGroupCollection groupCollection, KDTreeNode parentNode) {
        if (parentNode.getUserObject() instanceof QCGroupInfo && groupCollection != null && groupCollection.size() > 0) {
            parentNode.removeAllChildren();
            HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
            QCGroupInfo parentGroupInfo = (QCGroupInfo)parentNode.getUserObject();
            nodeMap.put(parentGroupInfo.getId().toString(), parentNode);
            int num = groupCollection.size();
            for (int i = 0; i < num; ++i) {
                QCGroupInfo groupInfo = groupCollection.get(i);
                QCGroupTreeNode node = new QCGroupTreeNode(groupInfo);
                if (!groupInfo.isIsLeaf()) {
                    QCGroupInfo tempQCGroupInfo = this.getEmptyGroupNode();
                    node.add((MutableTreeNode)((Object)new QCGroupTreeNode(tempQCGroupInfo)));
                }
                node.setCustomIcon(this.groupIcon);
                node.setVirtual(true);
                nodeMap.put(groupInfo.getId().toString(), node);
                if (groupInfo.getParent() == null || !nodeMap.containsKey(groupInfo.getParent().getId().toString())) continue;
                QCGroupTreeNode tempParentNode = (QCGroupTreeNode)((Object)nodeMap.get(groupInfo.getParent().getId().toString()));
                int index = tempParentNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
            }
        }
    }

    private QCGroupInfo getEmptyGroupNode() {
        QCGroupInfo tempQCGroupInfo = new QCGroupInfo();
        tempQCGroupInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
        tempQCGroupInfo.setName("");
        return tempQCGroupInfo;
    }

    public DefaultKingdeeTreeNode getExpandNode() {
        return this.expandnode;
    }

    private QCGroupTreeNode createInitRootNode() throws Exception {
        QCGroupTreeNode rootNode = null;
        QualityOrgUnitInfo qu = SysContext.getSysContext().getCurrentQualityUnit();
        if (qu == null) {
            return null;
        }
        String qualityOrgID = qu.getId().toString();
        QualityOrgUnitCollection orgUnitCollection = this.getInitQualityOrgRowSet(qualityOrgID, true);
        rootNode = this.buildInitTreeByRowSet(orgUnitCollection, true);
        return rootNode;
    }

    private QualityOrgUnitInfo getTopQualityOrgUnitInfo(String qualityOrgID) throws Exception {
        QualityOrgUnitInfo orgInfo = null;
        orgInfo = (QualityOrgUnitInfo)this.orgInfoCache.get(qualityOrgID);
        if (orgInfo == null) {
            IQualityOrgUnit iQuality = QualityOrgUnitFactory.getRemoteInstance();
            orgInfo = iQuality.getQualityOrgUnitInfo((IObjectPK)new ObjectStringPK(qualityOrgID));
            orgInfo.put(qualityOrgID, (Object)orgInfo);
        }
        return orgInfo;
    }

    private QualityOrgUnitCollection getInitQualityOrgRowSet(String qualityOrgID, boolean flag) throws Exception {
        QualityOrgUnitCollection orgUnitCollection = null;
        if (this.topQualityOrgUnitInfo == null) {
            this.topQualityOrgUnitInfo = this.getTopQualityOrgUnitInfo(qualityOrgID);
        }
        if (this.topQualityOrgUnitInfo != null) {
            String longNumber = this.topQualityOrgUnitInfo.getLongNumber();
            int level = this.topQualityOrgUnitInfo.getLevel();
            EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
            FilterInfo fi = viewInfo.getFilter();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.topQualityOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            fi.mergeFilter(filter, "or");
            SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
            sorterInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(sorterInfo);
            orgUnitCollection = QualityOrgUnitFactory.getRemoteInstance().getQualityOrgUnitCollection(viewInfo);
        }
        return this.removeNoPermissionOrg(orgUnitCollection);
    }

    public QualityOrgUnitCollection removeNoPermissionOrg(QualityOrgUnitCollection orgUnitCollection) throws EASBizException, BOSException {
        String permItem = "qm_QCGroupPerson_01view";
        BOSUuid id = SysContext.getSysContext().getCurrentUserInfo().getId();
        ObjectUuidPK userPK = new ObjectUuidPK(id);
        OrgUnitCollection temp = this.getAuthOrgByPermItem((IObjectPK)userPK, OrgType.Quality, permItem);
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        for (int i = 0; i < temp.size(); ++i) {
            BOSUuid orgID = temp.get(i).getId();
            list.add(orgID);
        }
        for (int j = 0; j < orgUnitCollection.size(); ++j) {
            if (list.contains(orgUnitCollection.get(j).getId())) continue;
            orgUnitCollection.removeObject(j);
            --j;
        }
        return orgUnitCollection;
    }

    public OrgUnitCollection getAuthOrgByPermItem(IObjectPK userPK, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection result = permission.getAuthorizedOrg(userPK, orgType, null, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    private EntityViewInfo getChildViewInfo(int level, String longNumber) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        viewInfo.setFilter(fi);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level + 1), CompareType.EQUALS));
        return viewInfo;
    }

    private QCGroupTreeNode buildInitTreeByRowSet(QualityOrgUnitCollection orgUnitCollection, boolean flag) throws Exception {
        ArrayList trees;
        if (null == orgUnitCollection) {
            return null;
        }
        List qualityOrgUnitIDCollection = this.getQuiltyOrgUnitIdInQCGroup(orgUnitCollection, 1);
        QCGroupTreeNode rootnode = null;
        HashMap<String, QCGroupTreeNode> nodeMap = new HashMap<String, QCGroupTreeNode>();
        Iterator iter = orgUnitCollection.iterator();
        while (null != iter && iter.hasNext()) {
            QualityOrgUnitInfo orginfo = (QualityOrgUnitInfo)iter.next();
            if (rootnode == null) {
                rootnode = new QCGroupTreeNode(orginfo);
                if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)rootnode)) {
                    this.expandnode = rootnode;
                }
                rootnode.setCustomIcon(this.companyIcon);
                nodeMap.put(orginfo.getId().toString(), rootnode);
                continue;
            }
            if (orginfo.isIsLeaf() && this.isHasChildQCGroup(qualityOrgUnitIDCollection, orginfo)) {
                orginfo.setIsLeaf(false);
            }
            QCGroupTreeNode subTreeNode = new QCGroupTreeNode(orginfo);
            subTreeNode.setVirtual(true);
            if (!orginfo.isIsLeaf()) {
                QualityOrgUnitInfo qualtyOrginfo = this.getEmptyNode();
                subTreeNode.add((MutableTreeNode)((Object)new QCGroupTreeNode(qualtyOrginfo)));
            }
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)subTreeNode)) {
                this.expandnode = subTreeNode;
            }
            subTreeNode.setCustomIcon(this.companyIcon);
            if (orginfo.getParent() != null && nodeMap.containsKey(orginfo.getParent().getId().toString())) {
                ((QCGroupTreeNode)((Object)nodeMap.get(orginfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)subTreeNode));
            }
            nodeMap.put(orginfo.getId().toString(), subTreeNode);
        }
        if (rootnode != null && null != (trees = this.getInitGroupTrees()) && trees.size() > 0) {
            for (QCGroupTreeNode tree : trees) {
                QCGroupInfo groupinfo = (QCGroupInfo)tree.getUserObject();
                if (nodeMap.containsKey(groupinfo.getQualityOrgUnit().getId().toString())) {
                    ((QCGroupTreeNode)((Object)nodeMap.get(groupinfo.getQualityOrgUnit().getId().toString()))).add((MutableTreeNode)((Object)tree));
                }
                nodeMap.put(groupinfo.getId().toString(), tree);
            }
        }
        return rootnode;
    }

    private ArrayList getInitGroupTrees() throws Exception {
        ArrayList<QCGroupTreeNode> grouptrees = new ArrayList<QCGroupTreeNode>();
        HashMap<String, QCGroupTreeNode> nodemap = new HashMap<String, QCGroupTreeNode>();
        QCGroupCollection groupCollection = this.getInitGroupRowSet(true);
        if (null == groupCollection || groupCollection.size() <= 0) {
            return null;
        }
        Iterator iter = groupCollection.iterator();
        while (null != iter && iter.hasNext()) {
            QCGroupInfo groupinfo = (QCGroupInfo)iter.next();
            QCGroupTreeNode node = new QCGroupTreeNode(groupinfo);
            if (!groupinfo.isIsLeaf()) {
                QCGroupInfo tempQCGroupInfo = this.getEmptyGroupNode();
                node.add((MutableTreeNode)((Object)new QCGroupTreeNode(tempQCGroupInfo)));
            }
            node.setVirtual(true);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)node)) {
                this.expandnode = node;
            }
            if (null == groupinfo.getParent()) {
                grouptrees.add(node);
                node.setCustomIcon(this.groupIcon);
            } else if (groupinfo.getParent() != null && nodemap.containsKey(groupinfo.getParent().getId().toString())) {
                ((QCGroupTreeNode)((Object)nodemap.get(groupinfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)node));
                node.setCustomIcon(this.groupIcon);
            }
            nodemap.put(groupinfo.getId().toString(), node);
        }
        return grouptrees;
    }

    private QCGroupCollection getInitGroupRowSet(boolean flag) throws Exception {
        QCGroupCollection groupCollection = null;
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString();
        if (this.topQualityOrgUnitInfo == null && SysContext.getSysContext().getCurrentCtrlUnit().getCU().isIsQualityOrgUnit()) {
            this.topQualityOrgUnitInfo = this.getTopQualityOrgUnitInfo(cuid);
        }
        EntityViewInfo viewInfo = this.getChildGroupFilter(this.topQualityOrgUnitInfo);
        groupCollection = QCGroupFactory.getRemoteInstance().getQCGroupCollection(viewInfo);
        return groupCollection;
    }

    private EntityViewInfo getChildGroupFilter(QualityOrgUnitInfo orgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(fi);
        return viewInfo;
    }

    private List getQuiltyOrgUnitIdInQCGroup(QualityOrgUnitCollection orgUnitCollection, int level) throws BOSException, SQLException {
        ArrayList<String> list = new ArrayList<String>();
        if (orgUnitCollection == null || orgUnitCollection.size() == 0) {
            return list;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            QualityOrgUnitInfo orgInfo = orgUnitCollection.get(i);
            String id = orgInfo.getId().toString();
            set.add(id);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("qualityOrgUnit.id", set, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level), CompareType.EQUALS));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.qm.basedata.app.QCGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rowSet = queryExcu.executeQuery();
        while (rowSet.next()) {
            String qualityOrgUnitID = rowSet.getString("qualityOrgUnit.id");
            list.add(qualityOrgUnitID);
        }
        return list;
    }

    private class QCGroupTreeNode
    extends KDTreeNode {
        private static final long serialVersionUID = 2959148492044135073L;

        public QCGroupTreeNode(Object o) {
            super(o);
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (obj != null && !(obj instanceof DefaultKingdeeTreeNode)) {
                return false;
            }
            QCGroupTreeNode node = (QCGroupTreeNode)((Object)obj);
            if (null != node && null != node.getUserObject() && null != this.getUserObject() && node.getUserObject() instanceof QCGroupInfo && this.getUserObject() instanceof QCGroupInfo) {
                QCGroupInfo groupInfo = (QCGroupInfo)this.getUserObject();
                QCGroupInfo objGroupInfo = (QCGroupInfo)node.getUserObject();
                if (null != groupInfo.getId() && null != objGroupInfo.getId() && groupInfo.getId().equals((Object)objGroupInfo.getId())) {
                    return true;
                }
            } else if (null != node && null != node.getUserObject() && null != this.getUserObject() && node.getUserObject() instanceof QualityOrgUnitInfo && this.getUserObject() instanceof QualityOrgUnitInfo) {
                QualityOrgUnitInfo orgInfo = (QualityOrgUnitInfo)this.getUserObject();
                QualityOrgUnitInfo objOrgInfo = (QualityOrgUnitInfo)node.getUserObject();
                if (null != orgInfo.getId() && null != objOrgInfo.getId() && orgInfo.getId().equals((Object)objOrgInfo.getId())) {
                    return true;
                }
            }
            return false;
        }
    }
}

