/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.qm.basedata.QCInstrumentFactory;
import com.kingdee.eas.qm.basedata.QCInstrumentGroupInfo;
import com.kingdee.eas.qm.basedata.QCInstrumentInfo;
import com.kingdee.eas.qm.basedata.client.AbstractQCInstrumentEditUI;
import com.kingdee.eas.qm.basedata.client.util.F7BDRegUtils;
import com.kingdee.eas.qm.common.DBCheckedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class QCInstrumentEditUI
extends AbstractQCInstrumentEditUI {
    private static final long serialVersionUID = -3351811032502655784L;
    private static final Logger logger = CoreUIObject.getLogger(QCInstrumentEditUI.class);

    public QCInstrumentEditUI() throws Exception {
        logger.debug((Object)"QCInstrumentEditUI");
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return QCInstrumentFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData(null);
        return data;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected IObjectValue newInstanceData() {
        QCInstrumentGroupInfo groupInfo;
        QCInstrumentInfo objectValue = new QCInstrumentInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        QualityOrgUnitInfo orgItem = (QualityOrgUnitInfo)this.getMainOrgInfo();
        objectValue.setQualityOrgUnit(orgItem);
        if (this.getUIContext().get("ParentNode") != null && this.getUIContext().get("ParentNode") instanceof QCInstrumentGroupInfo && (groupInfo = (QCInstrumentGroupInfo)this.getUIContext().get("ParentNode")).isIsLeaf()) {
            objectValue.setGroup(groupInfo);
        }
        return objectValue;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        QCInstrumentInfo info = (QCInstrumentInfo)arg0;
        info.setCheckedStatus(DBCheckedStatusEnum.UNAUDITED);
        QualityOrgUnitInfo orgItem = (QualityOrgUnitInfo)this.getMainOrgInfo();
        info.setQualityOrgUnit(orgItem);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("group.id"));
        sic.add(new SelectorItemInfo("group.number"));
        sic.add(new SelectorItemInfo("group.name"));
        sic.add(new SelectorItemInfo("status.id"));
        sic.add(new SelectorItemInfo("status.number"));
        sic.add(new SelectorItemInfo("status.name"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.id"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.number"));
        sic.add(new SelectorItemInfo("qualityOrgUnit.name"));
        return sic;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.actionUnAudit.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnAudit.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.btnBlocked.setVisible(false);
        this.btnUnBlocked.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.doQCInstrumentGroupFilter();
        this.doQCInstrumentStatusFilter();
    }

    protected void doQCInstrumentStatusFilter() {
        this.prmtstatus.setEntityViewInfo(F7BDRegUtils.getAuditedEntityView());
    }

    protected void doQCInstrumentGroupFilter() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmtGroup.setEntityViewInfo(ev);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkAuditedCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    protected void checkAuditedCanEdit() throws Exception {
        if (this.editData != null) {
            DBCheckedStatusEnum v = this.editData.getCheckedStatus();
            if (v != null && v == DBCheckedStatusEnum.AUDITED) {
                String info = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"Msg_AuditedCannotEdit");
                MsgBox.showInfo((Component)((Object)this), (String)info);
                SysUtil.abort();
            }
            QualityOrgUnitInfo billOrg = this.editData.getQualityOrgUnit();
            QualityOrgUnitInfo currentOrg = (QualityOrgUnitInfo)this.getMainOrgInfo();
            if (currentOrg == null || billOrg == null || !currentOrg.getId().toString().equals(billOrg.getId().toString())) {
                String info = EASResource.getString((String)"com.kingdee.eas.qm.basedata.QCInstrumentResource", (String)"CAN_NOT_EDIT_NOCREATOR");
                MsgBox.showInfo((Component)((Object)this), (String)info);
                SysUtil.abort();
            }
        }
    }
}

