/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.qm.basedata.IQCInstrument;
import com.kingdee.eas.qm.basedata.QCInstrumentFactory;
import com.kingdee.eas.qm.basedata.QCInstrumentGroupFactory;
import com.kingdee.eas.qm.basedata.client.AbstractQCInstrumentListUI;
import com.kingdee.eas.qm.basedata.client.QCInstrumentGroupEditUI;
import com.kingdee.eas.qm.common.client.QMDataBaseDAssignmentUI;
import com.kingdee.eas.qm.common.client.util.VOTreeCellRender;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreeCellRenderer;
import org.apache.log4j.Logger;

public class QCInstrumentListUI
extends AbstractQCInstrumentListUI {
    private static final long serialVersionUID = -5222262294834888056L;
    private static final Logger logger = CoreUIObject.getLogger(QCInstrumentListUI.class);

    public QCInstrumentListUI() throws Exception {
        logger.debug((Object)"");
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        Context mainOrgCtx = this.getMainOrgContext();
        Context newCtx = null;
        if (mainOrgCtx != null) {
            QualityOrgUnitInfo quan = (QualityOrgUnitInfo)this.getMainOrgInfo();
            newCtx = new Context();
            newCtx.put((Object)OrgType.ControlUnit, (Object)(quan == null ? null : quan.getCU()));
            newCtx.put((Object)OrgType.Quality, (Object)quan);
        }
        return QCInstrumentFactory.getRemoteInstanceWithObjectContext(newCtx);
    }

    protected Class getEntityModel() {
        return IQCInstrument.class;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return QCInstrumentGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getGroupEditUIName() {
        return QCInstrumentGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "group.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        String rootName = EASResource.getString((String)"com.kingdee.eas.qm.basedata.client.BasedataResource", (String)"QCInstrumentRootName");
        return rootName;
    }

    public String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionCancel.setEnabled(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setEnabled(false);
        this.actionCancelCancel.setVisible(false);
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    @Override
    protected String getSelectDetailTreeName() {
        return "group";
    }

    protected boolean canMoveDetailToRoot() {
        return false;
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return new VOTreeCellRender("$number$ ($name$)");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBlocked.setVisible(false);
        this.btnUnBlocked.setVisible(false);
    }

    protected MetaDataPK getQueryPKFromEntity() throws Exception {
        String queryName = "com.kingdee.eas.qm.basedata.app.QCInstrumentForAssignQuery";
        MetaDataPK queryPK = new MetaDataPK(queryName);
        return queryPK;
    }

    protected String getOnloadPermItemName() {
        return "qm_QCInstrument_01view";
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.isSameQualityOrg()) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.isSameQualityOrg()) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        super.actionRemove_actionPerformed(e);
    }

    protected String getBatchAssignUIName() {
        return QMDataBaseDAssignmentUI.class.getName();
    }

    private boolean isSameQualityOrg() {
        IRow row = this.getSelectedRow();
        ICell qualityOrgCell = row.getCell("qualityOrgUnit.id");
        if (qualityOrgCell != null) {
            String createdOrg = (String)qualityOrgCell.getValue();
            String currentOrg = ((QualityOrgUnitInfo)this.getMainOrgInfo()).getId().toString();
            return currentOrg.equals(createdOrg);
        }
        return true;
    }
}

