/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.basedata.formula.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.service.formula.api.FormulaOperator;
import com.kingdee.bos.service.formula.api.FormulaVarInfoParser;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.builder.TableModelVar;
import com.kingdee.bos.service.formula.builder.TableVarInfo;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSMetaTreeModelCreator;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObj;
import com.kingdee.bos.service.formula.engine.FormulaTransformer;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.formula.utils.QMFormulaPromptHelper;
import com.kingdee.eas.qm.basedata.formula.utils.QMFormulaTokenHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class QMFormulaUtils {
    public static String getVarNameByQCItemNumber(String qcItemNumber) {
        String number = "var_";
        if (qcItemNumber != null) {
            number = number + QMFormulaTokenHelper.parserStringByMD5(qcItemNumber, false);
        }
        return number;
    }

    public static String getVarOtherNameByQCItemName(String qcItemName) {
        String name = QMFormulaTokenHelper.parserStringByTokenList(qcItemName);
        return name;
    }

    public static String[] parseQCItemNumber(String formulaString) {
        ArrayList<String> ls = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)formulaString)) {
            Pattern pt = Pattern.compile("(var_name=var_)(.+)(\\|var_type)(.+)(})");
            Matcher matcher = pt.matcher(formulaString);
            String itemNumber = null;
            while (matcher.find()) {
                if (matcher != null && matcher.group(2) != null) {
                    itemNumber = matcher.group(2).toString();
                }
                if (StringUtils.isEmpty(itemNumber)) continue;
                ls.add(itemNumber);
            }
        }
        String[] result = null;
        if (ls.size() > 0) {
            result = new String[ls.size()];
            ls.toArray(result);
        }
        return result;
    }

    public static String getInitFormulaFromSelectQCItemList(List qcItemList) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("var formula_result; //{bos_formula_comments_var:var_name=formula_result|var_type=|var_scope=return|var_alias=\u516c\u5f0f\u7ed3\u679c|var_desc=\u516c\u5f0f\u8fd4\u56de\u7ed3\u679c}\r\n");
        Object o = null;
        int count = qcItemList.size();
        for (int i = 0; i < count; ++i) {
            o = qcItemList.get(i);
            for (int k = 0; o != null && o instanceof List && k < ((List)o).size(); ++k) {
                if (!(((List)o).get(k) instanceof QCItemInfo)) continue;
                buffer.append(QMFormulaUtils.getQCItemFormula((QCItemInfo)((List)o).get(k)));
            }
        }
        return buffer.toString();
    }

    public static String getInitFormulaFromSelectReceiveStandard(KDTable table, String[] ColumnNameArray) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("var formula_result; //{bos_formula_comments_var:var_name=formula_result|var_type=|var_scope=return|var_alias=\u516c\u5f0f\u7ed3\u679c|var_desc=\u516c\u5f0f\u8fd4\u56de\u7ed3\u679c}\r\n");
        for (int i = 0; i < ColumnNameArray.length; ++i) {
            String number = table.getColumn(ColumnNameArray[i]).getKey();
            String name = table.getHeadRow(0).getCell(ColumnNameArray[i]).getValue().toString();
            buffer.append(QMFormulaUtils.getQCItemFormula(number, name));
        }
        return buffer.toString();
    }

    public static String getQCItemFormula(QCItemInfo qcItemInfo) {
        String qcItemFormula = null;
        if (qcItemInfo != null) {
            String varName = QMFormulaUtils.getVarNameByQCItemNumber(qcItemInfo.getNumber());
            String name = QMFormulaUtils.getVarOtherNameByQCItemName(qcItemInfo.getName());
            String descript = QMFormulaPromptHelper.getMsg("Var_Description", new String[]{qcItemInfo.getNumber() + ":" + qcItemInfo.getName()});
            qcItemFormula = "var " + varName + ";//{bos_formula_comments_var:var_name=" + varName + "|var_type=BigDecimal|var_scope=in|var_alias=" + name + "|var_desc=" + descript + "}\r\n";
        }
        return qcItemFormula;
    }

    public static String getQCItemFormula(String number, String name) {
        String formula = null;
        String varName = "var_" + number;
        String alias = QMFormulaUtils.getVarOtherNameByQCItemName(name);
        formula = "var " + varName + ";//{bos_formula_comments_var:var_name=" + varName + "|var_type=BigDecimal|var_scope=in|var_alias=" + alias + "|var_desc=}\r\n";
        return formula;
    }

    public static Object evalFormula(Context ctx, String exp, Map localCtx) throws Exception {
        Interpreter interpreter = new Interpreter(ctx);
        localCtx.put("__bosContext", ctx);
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(false);
        Object object = interpreter.eval(exp, localCtx);
        return object;
    }

    private static TableModelVar getTableModelVar(String formulaStr) {
        TableModelVar modelVars = new TableModelVar();
        IVarInfo[] varInfos = new FormulaVarInfoParser().getFormulaVars(formulaStr);
        if (varInfos != null) {
            TableVarInfo varInfo;
            int i;
            boolean hasResultVar = false;
            for (i = 0; i < varInfos.length; ++i) {
                if (!varInfos[i].getVarName().equals("formula_result")) continue;
                varInfo = new TableVarInfo(varInfos[i].getVarName(), varInfos[i].getVarAlias(), varInfos[i].getVarType(), varInfos[i].getVarInitval(), varInfos[i].getVarScope(), varInfos[i].getVarDesc(), 3);
                modelVars.addVar(varInfo);
                hasResultVar = true;
            }
            if (!hasResultVar) {
                modelVars.init();
            }
            for (i = 0; i < varInfos.length; ++i) {
                BOSObj bobj;
                varInfo = new TableVarInfo(varInfos[i].getVarName(), varInfos[i].getVarAlias(), varInfos[i].getVarType(), varInfos[i].getVarInitval(), varInfos[i].getVarScope(), varInfos[i].getVarDesc(), 3);
                if ((varInfo.getVarAlias() == null || varInfo.getVarAlias().trim().length() == 0) && (bobj = BOSMetaTreeModelCreator.getBOSObjFromClassName((String)varInfo.getVarType())) != null) {
                    varInfo.setVarAlias(bobj.getAlias());
                }
                modelVars.addVar(varInfo);
            }
        }
        return modelVars;
    }

    public static String parserFormulaToDisplayString(String exp) throws Exception {
        String displayStr = FormulaOperator.getDisplayString((String)exp);
        return displayStr;
    }

    public static String parserFormulaToAliasString(String exp) throws Exception {
        Vector enumInfos = FormulaOperator.getEnumsVector((String)exp);
        TableModelVar modelVars = QMFormulaUtils.getTableModelVar(exp);
        String displayStr = QMFormulaUtils.parserFormulaToDisplayString(exp);
        FormulaTransformer tran = new FormulaTransformer(modelVars.getVars(), enumInfos);
        String alias = tran.reverseTransform(displayStr);
        return alias;
    }

    public static String getVarAliasFromExpByVarName(String formulaString, String varName) {
        String varAlias = "";
        if (!StringUtils.isEmpty((String)formulaString)) {
            Pattern pt = Pattern.compile("(var_name=" + varName + ")(.+)(\\|var_alias=)(.+)(\\|var_desc=)(.+)(})");
            Matcher matcher = pt.matcher(formulaString);
            while (matcher.find()) {
                if (matcher == null || matcher.group(4) == null) continue;
                varAlias = matcher.group(4);
                break;
            }
        }
        return varAlias;
    }
}

