/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.InvokeStackCache;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.common.GeneCommonFacadeFactory;
import com.kingdee.eas.barcode.common.cache.GeneBatchExecuteParam;
import com.kingdee.eas.barcode.common.cache.GeneBatchExecuteResult;
import com.kingdee.eas.barcode.common.cache.IGeneCacheManager;
import com.kingdee.eas.common.EASBizException;
import java.util.Map;
import org.apache.log4j.Logger;

public class GeneCacheManager
implements IGeneCacheManager {
    private static final Logger logger = CoreUIObject.getLogger(GeneCacheManager.class);

    public static IGeneCacheManager getInstance() {
        return new GeneCacheManager();
    }

    @Override
    public void batchInvoke(Context ctx, GeneBatchExecuteParam[] params) throws BOSException, EASBizException {
        if (params == null || params.length == 0) {
            return;
        }
        if (params.length == 1) {
            GeneBatchExecuteParam p = params[0];
            if (p.isEnable()) {
                try {
                    p.invokeRemote(ctx);
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                ActionCache.put((Map)params[0].getResponse());
            }
        } else {
            GeneBatchExecuteParam[] request = new GeneBatchExecuteParam[params.length];
            boolean isOK = false;
            for (int i = 0; i < params.length; ++i) {
                GeneBatchExecuteParam qmBatchExecuteParam = params[i];
                if (GeneCacheManager.hasCache(ctx, qmBatchExecuteParam)) {
                    logger.debug((Object)(qmBatchExecuteParam + "has Cache"));
                    qmBatchExecuteParam.setEnable(false);
                    continue;
                }
                request[i] = qmBatchExecuteParam;
                isOK = true;
            }
            if (isOK) {
                GeneBatchExecuteResult[] rst = GeneCommonFacadeFactory.getRemoteInstanceWithObjectContext(ctx).batchExcute(request);
                for (int i = 0; rst != null && i < rst.length; ++i) {
                    GeneBatchExecuteParam qmBatchExecuteParam = params[i];
                    if (!qmBatchExecuteParam.isEnable()) continue;
                    GeneBatchExecuteResult batchExecuteResult = rst[i];
                    Throwable exception = batchExecuteResult.getException();
                    if (exception != null) {
                        if (exception instanceof BOSException) {
                            throw (BOSException)exception;
                        }
                        if (exception instanceof EASBizException) {
                            throw (EASBizException)exception;
                        }
                        if (exception instanceof RuntimeException) {
                            throw (RuntimeException)exception;
                        }
                        throw new BOSException(exception);
                    }
                    qmBatchExecuteParam.setResult(batchExecuteResult.getReturnValue());
                    ActionCache.put((Map)qmBatchExecuteParam.getResponse());
                }
            }
        }
    }

    public static boolean hasCache(Context ctx, GeneBatchExecuteParam qmBatchExecuteParam) {
        String responseKey;
        String responseKey2;
        if (!ActionCache.isEmpty() && ActionCache.containsKey((Object)(responseKey2 = qmBatchExecuteParam.getActionCacheKey()))) {
            return true;
        }
        InvokeStackCache localCache = InvokeStackCache.getInstance();
        if (localCache.depth() > 0 && localCache.containsKey((Object)(responseKey = qmBatchExecuteParam.getActionCacheKey()))) {
            return true;
        }
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null && config.needCache(qmBatchExecuteParam.getBosType())) {
            ICacheService svc = CacheServiceFactory.getInstance();
            MultiParamKey key = MultiParamKey.create((String)qmBatchExecuteParam.getMethodName(), (Object[])qmBatchExecuteParam.toArray());
            boolean isHit = svc.contains(qmBatchExecuteParam.getBosType(), key);
            if (isHit) {
                return true;
            }
        }
        return false;
    }
}

