/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.common.BillBaseStatusEnum;
import com.kingdee.eas.barcode.common.GeneBillBaseInfo;
import com.kingdee.eas.barcode.common.GeneCommonFacadeFactory;
import com.kingdee.eas.barcode.common.IGeneBillBase;
import com.kingdee.eas.barcode.common.cache.GeneBatchExecuteParam;
import com.kingdee.eas.barcode.common.cache.GeneCacheManager;
import com.kingdee.eas.barcode.common.cache.IGeneCacheManager;
import com.kingdee.eas.barcode.common.client.AbstractGeneBillBaseEditUI;
import com.kingdee.eas.barcode.common.client.action.IUIContextManager;
import com.kingdee.eas.barcode.common.client.action.UIContextManager;
import com.kingdee.eas.barcode.common.client.botp.BOTPCreateFromParameter;
import com.kingdee.eas.barcode.common.client.util.GeneClientUtils;
import com.kingdee.eas.barcode.common.client.util.GeneUICompentCreatorFactory;
import com.kingdee.eas.barcode.common.client.util.IGeneUIComponentCreator;
import com.kingdee.eas.barcode.common.client.verify.UIControlEmptyVerifyItem;
import com.kingdee.eas.barcode.common.core.codingrule.ClientCodingRuleStrategy;
import com.kingdee.eas.barcode.common.core.codingrule.GeneCodingRuleData;
import com.kingdee.eas.barcode.common.core.print.GenePrintIntegrationHelper;
import com.kingdee.eas.barcode.common.core.print.GeneTDHelper;
import com.kingdee.eas.barcode.common.core.print.ITDPrintStrategy;
import com.kingdee.eas.barcode.common.util.GeneEqualsUtils;
import com.kingdee.eas.barcode.common.util.GeneResourceUtil;
import com.kingdee.eas.barcode.common.util.GeneSelectorUtils;
import com.kingdee.eas.barcode.common.util.backup.QMPermissionUtils;
import com.kingdee.eas.barcode.common.util.backup.QMSortUtils;
import com.kingdee.eas.barcode.common.verify.IVerifyManager;
import com.kingdee.eas.barcode.common.verify.VerifyManager;
import com.kingdee.eas.barcode.eqm.client.util.ControlledItems;
import com.kingdee.eas.barcode.eqm.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class GeneBillBaseEditUI
extends AbstractGeneBillBaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GeneBillBaseEditUI.class);
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitInfo mainOrg = null;
    private IVerifyManager verifyManager = null;
    private Map uiContextManagers = new HashMap();
    private IGeneCacheManager cacheManager = null;
    private Map localeCache = null;
    public static final String OPER_COPY = "COPY";
    private ClientCodingRuleStrategy codingRuleStrategy = null;
    private boolean isLoading = false;
    private DataBinder hddDataBinder = null;
    private IGeneUIComponentCreator creator = null;

    public GeneBillBaseEditUI() throws Exception {
        List list = this.getInitCache();
        this.getCacheManager().batchInvoke(null, list.toArray(new GeneBatchExecuteParam[list.size()]));
    }

    public ClientCodingRuleStrategy getCodingRuleStrategy() {
        if (this.codingRuleStrategy == null) {
            this.codingRuleStrategy = new ClientCodingRuleStrategy();
        }
        return this.codingRuleStrategy;
    }

    protected IUIContextManager initUIContextManager(String key) {
        IUIContextManager uiContextManager = (IUIContextManager)this.uiContextManagers.get(key);
        if (uiContextManager == null) {
            uiContextManager = new UIContextManager((CoreUIObject)this);
            uiContextManager.setType(key);
            this.uiContextManagers.put(key, uiContextManager);
            this.registerUIManager(uiContextManager);
        }
        return uiContextManager;
    }

    public IUIContextManager initUIContextManager(JComponent comp, String uictx) {
        IUIContextManager managers = this.initUIContextManager(uictx);
        managers.addChangeListener(comp);
        return managers;
    }

    public IUIContextManager initUIContextManager(KDTable comp, String uictx, String colName) {
        IUIContextManager managers = this.initUIContextManager(uictx);
        managers.addChangeListener(comp, colName);
        return managers;
    }

    public IUIContextManager initUIContextManager(KDTable comp, String uictx, String[] colName) {
        IUIContextManager managers = this.initUIContextManager(uictx);
        managers.addChangeListener(comp, colName);
        return managers;
    }

    public IUIContextManager initUIContextManager(KDTable comp, String uictx, int type) {
        if (type == 1) {
            IUIContextManager managers = this.initUIContextManager(uictx);
            managers.addKDTSelectListener(comp);
            return managers;
        }
        if (type == 2) {
            IUIContextManager managers = this.initUIContextManager(uictx);
            managers.addRowLoadedListener(comp, this.dataBinder);
            return managers;
        }
        if (type == 3) {
            IUIContextManager managers = this.initUIContextManager(uictx);
            managers.addRowStoredListener(comp, this.dataBinder);
            return managers;
        }
        return null;
    }

    public IUIContextManager initUIContextManager(KDTable comp, String uictx) {
        IUIContextManager managers = this.initUIContextManager(uictx);
        managers.addChangeListener((JComponent)comp);
        return managers;
    }

    public IUIContextManager initUIContextManager(KDTabbedPane comp, String uictx, KDPanel panel) {
        IUIContextManager managers = this.initUIContextManager(uictx);
        managers.addChangeListener(comp, panel);
        return managers;
    }

    public IUIContextManager getUIContextManager(String key) {
        IUIContextManager uiContextManager = (IUIContextManager)this.uiContextManagers.get(key);
        if (uiContextManager == null) {
            uiContextManager = this.initUIContextManager(key);
        }
        return uiContextManager;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    public void onLoad() throws Exception {
        List list = this.getOnloadCache();
        this.getCacheManager().batchInvoke(null, list.toArray(new GeneBatchExecuteParam[list.size()]));
        if (this.uiContextManagers.size() == 0) {
            this.initUIContextManager();
        }
        super.onLoad();
        this.registerCustomerBindings();
        UIControlEmptyVerifyItem verifyItem = new UIControlEmptyVerifyItem((CoreUIObject)this);
        this.getVerifyManager().addVerifyItem(verifyItem);
        if (this.getDetailTable() != null) {
            this.getDetailTable().setColumnMoveable(true);
            this.getDetailTable().setActiveCellStatus(1);
            this.getDetailTable().getActionMap().remove("AddRow");
            this.getDetailTable().getActionMap().remove("RemoveRow");
            this.getDetailTable().getActionMap().remove("Delete");
            this.getDetailTable().getActionMap().remove("Paste");
        }
    }

    public void initUIContextManager() {
        this.initUIContextManager("MainOrgUnit");
    }

    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData(null);
        return data;
    }

    protected IObjectValue doCreateNewData(GeneBillBaseInfo info) {
        Map map = this.getUIContext();
        String actionCopy = (String)map.get(OPER_COPY);
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        GeneBillBaseInfo data = null;
        try {
            GeneBillBaseInfo oldInfo;
            if (info != null) {
                oldInfo = info;
                data = (GeneBillBaseInfo)oldInfo.copy();
            } else if (actionCopy != null && id != null && actionCopy.equals(OPER_COPY)) {
                oldInfo = (GeneBillBaseInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                data = (GeneBillBaseInfo)oldInfo.copy();
                map.remove(OPER_COPY);
            } else {
                data = (GeneBillBaseInfo)this.newInstanceData();
                if (data.getMainOrgUnit() == null) {
                    OrgUnitInfo mainOrgInfo = this.getMainOrgInfo();
                    if (mainOrgInfo.isIsCU()) {
                        mainOrgInfo = this.getDefaultMainBizOrg();
                    }
                    data.setMainOrgUnit(mainOrgInfo);
                }
                data.setBillStatus(BillBaseStatusEnum.ADD);
                data.setBizDate(DateUtil.getDayBegin());
                this.setOprtState("ADDNEW");
            }
            this.setFieldsNull((AbstractObjectValue)data);
            KDTextField txtNumber = this.getNumTextField();
            String orgId = data.getMainOrgUnit().getId().toString();
            this.getCodingRuleStrategy().processCodingRuleNumber(this.getMainOrgContext(), txtNumber, data, orgId);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
            this.abort();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
            this.abort();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.applyBillDefaultValue(data);
        return data;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        newData.put("number", null);
        newData.put("createTime", null);
        newData.put("creator", null);
        newData.put("auditor", null);
        newData.put("auditTime", null);
    }

    protected abstract IObjectValue newInstanceData() throws EASBizException, BOSException;

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    protected boolean isBotpBill(GeneBillBaseInfo info) {
        if (info == null) {
            return false;
        }
        String billId = info.getSourceBillId();
        return billId != null;
    }

    public boolean isModify() {
        if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals("VIEW")) {
            this.checkCanEdit(this.editData);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setNumberEnableByCodingRule();
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
        Thread.sleep(6000L);
        this.setUnAuditStatus(true);
        this.setOprtState(OprtState.VIEW);
        this.refreshCurPage();
    }

    protected void setUnAuditStatus(boolean status) {
        this.actionUnAudit.setEnabled(status);
        this.menuItemUnAudit.setEnabled(status);
        this.btnUnAudit.setEnabled(status);
    }

    private void setNumberEnableByCodingRule() {
        if (this.getDataObject() == null || this.getNumTextField() == null) {
            return;
        }
        GeneCodingRuleData codingRuleData = (GeneCodingRuleData)this.getDataObject().get("codingRuleData");
        if ("EDIT".equals(this.getOprtState())) {
            this.getNumTextField().setEnabled(true);
            return;
        }
        if (codingRuleData != null && codingRuleData.isExistRule()) {
            if (codingRuleData.isUseIntermitNumber()) {
                this.getNumTextField().setEnabled(false);
            } else if (codingRuleData.isAddView() && !codingRuleData.isModifable()) {
                this.getNumTextField().setEnabled(false);
            } else if (codingRuleData.isAddView() && codingRuleData.isModifable()) {
                this.getNumTextField().setEnabled(true);
            } else if (codingRuleData.isAddView() && !codingRuleData.isUseIntermitNumber()) {
                this.getNumTextField().setEnabled(false);
            } else if (!codingRuleData.isAddView()) {
                this.getNumTextField().setEnabled(false);
            }
        } else {
            this.getNumTextField().setEnabled(true);
        }
    }

    protected void checkCanEdit(GeneBillBaseInfo editData) throws Exception {
        if (editData == null || editData.getId() == null) {
            SysUtil.abort();
        } else {
            BillBaseStatusEnum baseStatus = editData.getBillStatus();
            if (baseStatus == BillBaseStatusEnum.AUDITED) {
                MsgBox.showWarning((Component)((Object)this), (String)(GeneClientUtils.getResource("BillAt") + baseStatus.getAlias() + GeneClientUtils.getResource("CantBeEdited")));
                SysUtil.abort();
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            if (this.getNumTextField().getText() != null && this.getNumTextField().getText().trim().equals("")) {
                this.getCodingRuleStrategy().processCodingRuleNumber(this.getMainOrgContext(), this.getNumTextField(), this.editData, this.getMainOrgInfo().getId().toString());
            }
            super.actionSubmit_actionPerformed(e);
        }
        catch (BTPException e1) {
            if (e1.getSubCode().equals("904")) {
                String msg = ExceptionMessageUtility.getMessage((Throwable)new BTPException(BTPException.CALLBACKBIZERR));
                msg = MessageFormat.format(msg, "");
                String exceptionMsg = ExceptionMessageUtility.getMessage((Throwable)e1);
                if (exceptionMsg.indexOf(msg) > -1) {
                    int length = exceptionMsg.indexOf(":") - exceptionMsg.indexOf(msg) + 1;
                    exceptionMsg = exceptionMsg.substring(exceptionMsg.indexOf(msg) + length);
                }
                MsgBox.showWarning((String)exceptionMsg);
                SysUtil.abort();
            }
            throw e1;
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSave_actionPerformed(e);
        }
        catch (BTPException e1) {
            if (e1.getSubCode().equals("904")) {
                String msg = ExceptionMessageUtility.getMessage((Throwable)new BTPException(BTPException.CALLBACKBIZERR));
                msg = MessageFormat.format(msg, "");
                String exceptionMsg = ExceptionMessageUtility.getMessage((Throwable)e1);
                if (exceptionMsg.indexOf(msg) > -1) {
                    int length = exceptionMsg.indexOf(":") - exceptionMsg.indexOf(msg) + 1;
                    exceptionMsg = exceptionMsg.substring(exceptionMsg.indexOf(msg) + length);
                }
                MsgBox.showWarning((String)exceptionMsg);
                SysUtil.abort();
            }
            throw e1;
        }
    }

    public int getBtpCreateFromType() {
        return 1;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        GeneBillBaseInfo info = (GeneBillBaseInfo)dataObject;
        if (this.getBOTPViewStatus() == 1 && this.getOprtState().equals(OprtState.ADDNEW) && EmptyUtil.isEmpty((String)info.getNumber())) {
            try {
                this.getCodingRuleStrategy().processCodingRuleNumber(this.getMainOrgContext(), this.getNumTextField(), info, this.getMainOrgInfo().getId().toString());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            this.applyBillDefaultValue(info);
        }
        if (this.getBOTPViewStatus() == 1 && this.getOprtState().equals(OprtState.ADDNEW) && info.getMainOrgUnit() == null) {
            info.setMainOrgUnit(this.getMainOrgInfo());
        }
        super.setDataObject(dataObject);
        this.setNumberEnableByCodingRule();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionTDPrintPreview.putValue("SmallIcon", GeneClientUtils.getIcon("imgTbtn_templatepreview"));
        this.actionTDPrint.putValue("SmallIcon", GeneClientUtils.getIcon("imgTbtn_templateprint"));
        this.actionCreateTo.putValue("SmallIcon", (Object)GeneClientUtils.getIcon("imgTbtn_zoomdown"));
        this.actionCreateFrom.putValue("SmallIcon", (Object)GeneClientUtils.getIcon("imgTbtn_takebill"));
        this.menuItemMultiapprove.setIcon(EASResource.getIcon((String)"imgTbtn_dealmultilevelaudit"));
        this.menuItemNextPerson.setIcon(EASResource.getIcon((String)"imgTbtn_nextactor"));
        this.actionPrint.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.menuSubmitOption.setVisible(false);
        this.menuSubmitOption.setEnabled(false);
        this.menuItemMsgFormat.setVisible(false);
        this.menuItemMsgFormat.setEnabled(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.menuItemCancelCancel.setAccelerator(KeyStroke.getKeyStroke("shift F8"));
        this.menuItemCancel.setAccelerator(KeyStroke.getKeyStroke("shift F9"));
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo mainOrg = null;
        BOTPCreateFromParameter botpMap = null;
        if (this.getMainBizOrg() != null && this.getMainBizOrg().getValue() != null) {
            mainOrg = (OrgUnitInfo)this.getMainBizOrg().getValue();
        }
        if (mainOrg == null) {
            if (this.getMainBizOrg() != null) {
                this.getMainBizOrg().requestFocus();
            }
            throw new SCMBillException(SCMBillException.NOMAINBIZORG);
        }
        botpMap = this.getBOTPCreateFromParameter();
        this.getBillEdit().createFrom(this.getMainOrgContext(), (HashMap)botpMap);
    }

    public BOTPCreateFromParameter getBOTPCreateFromParameter() {
        BOTPCreateFromParameter botpMap = new BOTPCreateFromParameter();
        botpMap.put("MAINBIZORG.TYPE", this.getMainBizOrgType());
        botpMap.put("MAINBIZORG", this.getMainOrgInfo());
        botpMap.put("IGNORE_DATAPERMISSION_CHECK", Boolean.TRUE);
        return botpMap;
    }

    protected void applyBillDefaultValue(GeneBillBaseInfo vo) {
        GeneBillBaseInfo billInfo = vo;
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date today = new Date();
        billInfo.setCreateTime(new Timestamp(today.getTime()));
        billInfo.setLastUpdateUser(null);
        billInfo.setLastUpdateTime(null);
        billInfo.setBillStatus(BillBaseStatusEnum.ADD);
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.loadFields();
            this.setSave(true);
            this.initOldData(this.editData);
        }
    }

    public IVerifyManager getVerifyManager() {
        if (this.verifyManager == null) {
            this.verifyManager = new VerifyManager();
        }
        return this.verifyManager;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.isSaveAction(e)) {
            return;
        }
        if (this.getNumTextField().getText() != null && this.getNumTextField().getText().trim().equals("") && this.getCodingRuleStrategy() != null) {
            this.getCodingRuleStrategy().processCodingRuleNumber(this.getMainOrgContext(), this.getNumTextField(), this.editData, this.getMainOrgInfo().getId().toString());
        }
        super.verifyInput(e);
        this.getVerifyManager().verify();
    }

    protected boolean isSaveAction(ActionEvent e) {
        if (e != null) {
            ItemAction action = this.getActionFromActionEvent(e);
            if (action == null) {
                return false;
            }
            return action.equals(this.actionSave);
        }
        return false;
    }

    @Override
    public abstract SelectorItemCollection getSelectors();

    public abstract KDTextField getNumTextField();

    protected void initContextOrg() {
        IObjectValue info = this.getDataObject();
        String state = this.getOprtState();
        if (OprtState.ADDNEW.equals(state) && this.getBOTPViewStatus() == 1) {
            GeneBillBaseInfo data = (GeneBillBaseInfo)this.getUIContext().get("InitDataObject");
            if (data != null && data.getMainOrgUnit() != null) {
                this.initUIMainOrgContext(data.getMainOrgUnit().getId().toString());
            }
        } else if (OprtState.ADDNEW.equals(state) && info == null) {
            OrgUnitInfo defaultMainOrg = this.getMainOrgInfo();
            if (defaultMainOrg == null || defaultMainOrg.isIsCU()) {
                defaultMainOrg = this.getDefaultMainBizOrg();
            }
            if (defaultMainOrg != null) {
                this.initUIMainOrgContext(defaultMainOrg.getId().toString());
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.common.GeneResource", (String)"NoBizUnit"));
                SysUtil.abort();
            }
        } else {
            OrgUnitInfo orgUnitInfo = this.getMainOrgInfo();
            Object id = this.getUIContext().get("ID");
            if (orgUnitInfo == null && id != null) {
                try {
                    SelectorItemCollection se = new SelectorItemCollection();
                    se.add("*");
                    GeneBillBaseInfo qcBill = (GeneBillBaseInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(id.toString()), se);
                    orgUnitInfo = qcBill.getMainOrgUnit();
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (orgUnitInfo == null) {
                orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
            }
            if (orgUnitInfo != null) {
                this.initUIMainOrgContext(orgUnitInfo.getId().toString());
            }
        }
        OrgUnitInfo mainOrgInfo = this.getMainOrgInfo();
        if (mainOrgInfo != null) {
            String newOrgId = mainOrgInfo.getId().toString();
            this.afterMainOrgChanged(null, newOrgId);
        }
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.mainOrg != null) {
            return this.mainOrg;
        }
        if (this.idxDefaultMainOrg > -1) {
            OrgUnitInfo currentMainOrg2 = this.getMainOrgInfo();
            if (currentMainOrg2 != null && this.mainOrgs != null && this.mainOrgs.length > 0) {
                for (int i = 0; i < this.mainOrgs.length; ++i) {
                    if (!currentMainOrg2.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                    this.idxDefaultMainOrg = i;
                    return currentMainOrg2;
                }
            }
            OrgUnitInfo lastOrgUnitInfo = this.mainOrgs[this.idxDefaultMainOrg];
            return lastOrgUnitInfo;
        }
        if (this.mainOrgs == null) {
            try {
                String addNewPermItemName = this.getAddNewPermItemName();
                this.mainOrgs = GeneCommonFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getAuthorizedBizOrgUnits(this.getMainBizOrgType(), addNewPermItemName);
                if (this.mainOrgs == null || this.mainOrgs.length == 0) {
                    return null;
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])QMSortUtils.sortDataByNumber((DataBaseInfo[])this.mainOrgs, true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs != null && this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    protected String getAddNewPermItemName() {
        try {
            String addNewPermItemName = QMPermissionUtils.getAddNewPermItemName(this.getMainOrgContext(), this.getBizType());
            return addNewPermItemName;
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    protected String getViewPermItemName() {
        try {
            String viewPermItemName = QMPermissionUtils.getViewPermItemName(this.getMainOrgContext(), this.getBizType());
            return viewPermItemName;
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    protected void setMainOrgStatus() {
        GeneBillBaseInfo billbaseInfo = (GeneBillBaseInfo)this.getDataObject();
        if (this.getMainBizOrg() != null) {
            boolean isBotp;
            boolean bl = isBotp = billbaseInfo.getSourceBillId() != null;
            if (billbaseInfo != null && (billbaseInfo.getId() != null || isBotp) && this.getMainBizOrg().getValue() != null) {
                this.getMainBizOrg().setEnabled(false);
            } else {
                this.getMainBizOrg().setEnabled(true);
            }
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        GeneBillBaseInfo info = (GeneBillBaseInfo)this.getDataObject();
        KDBizPromptBox mainOrgUnit = this.getMainBizOrg();
        String opr = this.getOprtState();
        if (mainOrgUnit != null) {
            boolean canModifyMainOrgUnit = "ADDNEW".equals(opr) && !this.isBotpBill(info);
            mainOrgUnit.setEnabled(canModifyMainOrgUnit);
        }
        if (this.isSuportAudit()) {
            boolean canAudit = info.getBillStatus() != null && info.getBillStatus().getValue() == 2;
            boolean canUnAudit = info.getBillStatus() != null && info.getBillStatus().getValue() == 4;
            this.actionAudit.setEnabled(canAudit);
            this.actionUnAudit.setEnabled(canUnAudit);
        } else {
            this.actionAudit.setVisible(this.isSuportAudit());
            this.actionAudit.setEnabled(this.isSuportAudit());
            this.actionUnAudit.setVisible(this.isSuportAudit());
            this.actionUnAudit.setEnabled(this.isSuportAudit());
        }
        this.actionSendMail.setEnabled(this.isSuportSendMail());
        this.actionSendMail.setEnabled(this.isSuportSendMail());
        boolean canTrance = !"ADDNEW".equals(this.getOprtState());
        this.actionTraceUp.setEnabled(canTrance);
        this.actionTraceDown.setEnabled(canTrance);
        if (info.getAuditor() != null) {
            // empty if block
        }
        if ("VIEW".equals(this.getOprtState())) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
        this.actionCopyLine.setEnabled(false);
        this.actionCopyLine.setVisible(false);
        if (this.getParentPrompt() != null) {
            try {
                EQMPromptDialogFactory.createParentDialog(this.getParentPrompt(), (CoreBaseInfo)this.editData);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.actionSave.setEnabled(true);
            this.actionSubmit.setEnabled(true);
        }
        if (info != null && (info.getBillStatus().getValue() == 0 || info.getBillStatus().getValue() == 1)) {
            this.actionSave.setEnabled(true);
        } else {
            this.actionSave.setEnabled(false);
        }
        if ("VIEW".equals(this.getOprtState())) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        this.setMainOrgStatus();
    }

    protected boolean isSuportAudit() {
        return true;
    }

    protected boolean isSuportSendMail() {
        return false;
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return this.getAddNewPermItemName();
        }
        return this.getViewPermItemName();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return super.getOrgPK(action);
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        if (newOrgId != null && !newOrgId.equals(oldOrgId)) {
            this.getUIContextManager("MainOrgUnit").changeUIContext(this.getMainOrgContext());
            try {
                EQMPromptDialogFactory.createPrmptList(this.getMainOrgContext(), this.getNeedMainOrgControl(), new OrgUnitInfo[]{this.getMainOrgInfo()}, this.getMainBizOrgField() + ".id");
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            try {
                if (oldOrgId != null && !GeneEqualsUtils.equals(newOrgId, oldOrgId) && !this.isLoading && "ADDNEW".equalsIgnoreCase(this.getOprtState())) {
                    this.setOprtState(OprtState.VIEW);
                    this.initUIMainOrgContext(newOrgId);
                    this.actionAddNew_actionPerformed(null);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else if (newOrgId == null) {
            OrgUnitInfo defaultMainOrg;
            logger.error((Object)"this is error, pls check u code!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            String state = this.getOprtState();
            if (OprtState.ADDNEW.equals(state) && (defaultMainOrg = this.getDefaultMainBizOrg()) != null) {
                this.initUIMainOrgContext(defaultMainOrg.getId().toString());
            }
        }
    }

    protected ControlledItems[] getNeedMainOrgControl() {
        return null;
    }

    public void registerUIManager(IUIContextManager manager) {
        if (manager.getType().equals("MainOrgUnit")) {
            KDBizPromptBox bizOrgUnitBox = this.getMainBizOrg();
            if (bizOrgUnitBox == null) {
                logger.error((Object)"mainBizOrg KDBizPromptBox is null, pls override getMainBizOrg()");
                return;
            }
            OrgType orgType = this.getMainBizOrgType();
            this.getUIContextManager("MainOrgUnit").registerMainBizOrgF7(bizOrgUnitBox, orgType, this.getAddNewPermItemName(), false);
            PreChangeListener prmtBizOrgPreChangeListener = this.getMainBizOrgPreChangeListener();
            bizOrgUnitBox.addPreChangeListener(prmtBizOrgPreChangeListener);
        }
    }

    public PreChangeListener getMainBizOrgPreChangeListener() {
        PreChangeListener prmtBizOrgPreChangeListener = new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                String strTemp;
                int ret;
                if (GeneBillBaseEditUI.this.isLoading()) {
                    return;
                }
                if (arg0.getData() == null) {
                    GeneBillBaseEditUI.this.getMainBizOrg().setDataNoNotify(arg0.getOldData());
                    MsgBox.showWarning((String)GeneResourceUtil.getMsg("MAINBIZORG_REQUIRED"));
                    arg0.setResult(0);
                    return;
                }
                if (arg0.getData() != null && GeneEqualsUtils.equals(arg0.getData(), arg0.getOldData())) {
                    return;
                }
                if ("ADDNEW".equalsIgnoreCase(GeneBillBaseEditUI.this.getOprtState()) && (ret = MsgBox.showConfirm2((String)(strTemp = SCMClientUtils.getResource((String)"CLEARENTRYAFTERORGCHANGED")))) == 2) {
                    arg0.setResult(0);
                    return;
                }
            }
        };
        return prmtBizOrgPreChangeListener;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        String[] idListArray = new String[]{this.editData.getId().toString()};
        ArrayList IDsInWF = GeneClientUtils.getIDsInActiveWorkFlow(idListArray);
        if (IDsInWF.size() != 0) {
            this.actionMultiapprove_actionPerformed(null);
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            if (this.editData.getId() != null) {
                this.editData = (GeneBillBaseInfo)this.getValue((IObjectPK)pk);
                if (this.editData.getBillStatus().getValue() != 4) {
                    Thread.sleep(2000L);
                    this.editData = (GeneBillBaseInfo)this.getValue((IObjectPK)pk);
                }
                if (this.editData.getBillStatus().getValue() == 4) {
                    this.setOprtState(OprtState.VIEW);
                } else {
                    this.setOprtState(OprtState.EDIT);
                }
                this.setDataObject(this.editData);
                this.loadFields();
                this.setSave(true);
                this.setSaved(true);
                this.actionTraceUp.setEnabled(true);
                this.actionTraceDown.setEnabled(true);
            }
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneBillBase biz = (IGeneBillBase)this.getBizInterface();
        biz.audit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.setOprtState("VIEW");
        this.afterDoAction(e, (IObjectPK)pk);
    }

    protected void afterDoAction(ActionEvent e, IObjectPK pk) throws Exception {
        GeneClientUtils.showSuccessMessage((CoreUI)this, e);
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData(this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneBillBase biz = (IGeneBillBase)this.getBizInterface();
        biz.unAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokeTDPrint(true);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokeTDPrint(false);
    }

    public ITDPrintStrategy getTDPrintStrategy() throws Exception {
        return null;
    }

    protected void doInvokeTDPrint(boolean isPrint) throws Exception {
        this.checkCanPrint();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        BOSObjectType bosType = this.getBizType();
        ITDPrintStrategy printStrategy = this.getTDPrintStrategy();
        if (printStrategy == null) {
            return;
        }
        printStrategy.invokeTDPrintFunction((CoreUI)this, bosType, idList, isPrint);
        Map printedErrorMap = printStrategy.getPrintedErrorMap();
        Map willPrintedErrorMap = printStrategy.getWillPrintedErrorMap();
        GeneTDHelper.processTDResultInfoForEditUI((CoreUI)this, this.editData.getNumber(), printedErrorMap, willPrintedErrorMap);
        this.doPrintNumInfo();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokePrint(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.doInvokePrint(false);
    }

    protected void doInvokePrint(boolean isPrint) throws Exception {
        if (this.editData == null) {
            return;
        }
    }

    protected void checkCanPrint() {
        if (this.editData == null || this.editData.getId() == null || this.editData.getBillStatus() == BillBaseStatusEnum.ADD || this.editData.getBillStatus() == BillBaseStatusEnum.TEMPORARILYSAVED) {
            MsgBox.showWarning((Component)((Object)this), (String)GeneResourceUtil.getMsg("TD_CannotPrint"));
            SysUtil.abort();
        }
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.isLoading = true;
        try {
            super.loadLineFields(table, row, obj);
        }
        finally {
            this.isLoading = false;
        }
    }

    protected void loadData() throws Exception {
        this.setLoading(true);
        try {
            super.loadData();
        }
        finally {
            this.setLoading(false);
        }
    }

    @Override
    public void loadFields() {
        this.beforLoadFields();
        super.loadFields();
        this.afterLoadFields();
    }

    public void afterLoadFields() {
        this.setLoading(false);
        this.doPrintNumInfo();
    }

    public void beforLoadFields() {
        this.setLoading(true);
    }

    protected void doPrintNumInfo() {
        if (!this.isSupportTDPrint() || this.getTDPrintNumTxtField() == null) {
            return;
        }
        if (this.editData == null || this.editData.getId() == null || "ADDNEW".equals(this.getOprtState())) {
            return;
        }
        try {
            int printNum = GenePrintIntegrationHelper.getPrintNum(null, this.getBizType(), this.editData.getId().toString());
            this.getTDPrintNumTxtField().setText(String.valueOf(printNum));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected JTextField getTDPrintNumTxtField() {
        return null;
    }

    protected boolean isSupportTDPrint() {
        return false;
    }

    public DataBinder getHDDBinder() {
        if (this.hddDataBinder == null) {
            this.hddDataBinder = new DataBinder();
        }
        return this.hddDataBinder;
    }

    public void loadHDDLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.getHDDBinder().loadLineFields(table, row, obj);
    }

    public void storeHDDLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.getHDDBinder().storeLineFields(table, row, obj);
    }

    public void actionHDDAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getHDDDetailTable() != null) {
            this.addLine(this.getHDDDetailTable());
            this.appendFootRow(this.getHDDDetailTable());
        }
    }

    protected KDTable getHDDDetailTable() {
        return null;
    }

    public void actionHDDCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
        KDTable table = this.getHDDDetailTable();
        if (table == null) {
            return;
        }
        KDTSelectManager manager = table.getSelectManager();
        if (manager.getBlocks().size() > 0) {
            this.addLine(table);
            this.appendFootRow(table);
            IRow copyFromRowObj = null;
            IRow copyToRowObj = null;
            int copyFromRowIndex = 0;
            int copyToRowIndex = 0;
            KDTSelectBlock selectedBlock = (KDTSelectBlock)manager.getBlocks().get(0);
            int beginBlockRow = selectedBlock.getBeginRow();
            int endBlockRow = selectedBlock.getEndRow();
            if (manager.getBlocks().size() > 1 || beginBlockRow != endBlockRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MultiRows"));
                return;
            }
            copyFromRowIndex = selectedBlock.getEndRow();
            copyToRowIndex = KDTableUtil.getLastVisibleRowIndex((KDTable)table);
            copyFromRowObj = table.getRow(copyFromRowIndex);
            copyToRowObj = table.getRow(copyToRowIndex);
            for (int cellIndex = 0; cellIndex < table.getColumnCount(); ++cellIndex) {
                ICell copyFromCell = copyFromRowObj.getCell(cellIndex);
                ICell copyToCell = copyToRowObj.getCell(cellIndex);
                if (copyFromCell == null || copyToCell == null) continue;
                Object orgValue = copyFromCell.getValue();
                copyToCell.setValue(orgValue);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
            return;
        }
    }

    public void actionHDDInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable detailTable = this.getHDDDetailTable();
        if (detailTable != null) {
            this.insertLine(detailTable);
            this.appendFootRow(detailTable);
        }
    }

    public void actionHDDRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable detailTable = this.getHDDDetailTable();
        if (detailTable != null) {
            this.removeLine(detailTable);
            this.appendFootRow(detailTable);
            if (detailTable.getRowCount() == 0) {
                FocusTraversalPolicy policy = null;
                Object container = null;
                Component initComponent = null;
                if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                    policy = this.getFocusTraversalPolicy();
                    container = this;
                    Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                    for (int i = 0; i < traverComponent.length; ++i) {
                        if (traverComponent[i] != detailTable) continue;
                        initComponent = traverComponent[i];
                        break;
                    }
                    if (initComponent == null) {
                        initComponent = policy.getLastComponent((Container)container);
                        initComponent.requestFocusInWindow();
                    } else if (initComponent != null) {
                        Component component = policy.getComponentBefore((Container)container, initComponent);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                } else if (policy == null) {
                    if (this.getUIWindow() instanceof Dialog) {
                        policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                        container = (Dialog)this.uiWindow;
                    } else if (this.getUIWindow() instanceof Window) {
                        policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                        container = (Window)this.uiWindow;
                    }
                    if (policy != null) {
                        try {
                            Component component = policy.getComponentBefore((Container)container, (Component)detailTable);
                            while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                                component = policy.getComponentBefore((Container)container, component);
                            }
                            component.requestFocusInWindow();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    protected KDBizPromptBox getParentPrompt() {
        return null;
    }

    public void registerCustomerBindings() {
        this.setMainOrgStatus();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue objectValue;
        this.checkModified();
        if (this.editData != null && !OprtState.VIEW.equals(this.getOprtState()) && (objectValue = (IObjectValue)this.getUIContext().get("CURRENT.VO")) != null) {
            try {
                String id = this.idList.getID(this.idList.getCurrentIndex());
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.unLockUI();
        this.editData = (GeneBillBaseInfo)this.doCreateNewData(this.editData);
        this.setOprtState("ADDNEW");
        this.setDataObject(this.editData);
        this.loadFields();
        this.showCopyAddNew();
        this.actionCopy.setEnabled(false);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
        this.setDefaultFocused();
        this.setMakeRelations(null);
    }

    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectedBlock;
        IRow copyFromRowObj;
        KDTable table = this.getDetailTable();
        if (table == null) {
            return;
        }
        KDTSelectManager manager = table.getSelectManager();
        if (manager.getBlocks().size() > 0) {
            copyFromRowObj = null;
            selectedBlock = (KDTSelectBlock)manager.getBlocks().get(0);
            int beginBlockRow = selectedBlock.getBeginRow();
            int endBlockRow = selectedBlock.getEndRow();
            if (manager.getBlocks().size() > 1 || beginBlockRow != endBlockRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MultiRows"));
                return;
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
            return;
        }
        int copyFromRowIndex = 0;
        copyFromRowIndex = selectedBlock.getEndRow();
        copyFromRowObj = table.getRow(copyFromRowIndex);
        this.copyLine(this.getDetailTable(), copyFromRowObj);
        this.appendFootRow(this.getDetailTable());
    }

    protected void copyLine(KDTable table, IRow srcrow) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table, srcrow);
        if (detailData != null) {
            IRow row = table.addRow();
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
            this.loadLineFields(table, row, detailData);
            this.afterAddLine(table, detailData);
        }
    }

    protected abstract IObjectValue createNewDetailData(KDTable var1, IRow var2);

    protected IObjectValue createNewDetailData(KDTable table) {
        return this.createNewDetailData(table, null);
    }

    public Component getComponentByName(String name) {
        return GeneClientUtils.getComponentByName((CoreUIObject)this, name);
    }

    public IGeneUIComponentCreator getUICompentCreatorFacotry() {
        if (this.creator == null) {
            this.creator = GeneUICompentCreatorFactory.getInstance();
        }
        return this.creator;
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setScrollButtons();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setScrollButtons();
    }

    protected void setScrollButtons() {
        int currentIndex = this.idList.getCurrentIndex();
        int nextIndex = currentIndex + 1;
        String nextId = this.idList.getID(nextIndex);
        if (nextId == null) {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        }
    }

    protected String getTDFileName() {
        return null;
    }

    protected IMetaDataPK getTDQueryPK() {
        return null;
    }

    protected void unLockUI() {
        KDTextField txt = this.getNumTextField();
        boolean old = txt.isEnabled();
        super.unLockUI();
        txt.setEnabled(old);
    }

    public OrgUnitCollection getFromUnits(OrgTypeRelationInfo orgtyperelationinfo) throws EASBizException, BOSException {
        OrgUnitInfo main = this.getMainOrgInfo();
        return OrgUnitRelationFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getFromUnits(orgtyperelationinfo, main);
    }

    public Context getDeleOrgContext(String key) {
        Component comp = this.getComponentByName(key);
        if (comp == null) {
            return super.getMainOrgContext();
        }
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox b = (KDBizPromptBox)comp;
            OrgUnitInfo o = (OrgUnitInfo)b.getValue();
            if (o == null) {
                return null;
            }
            try {
                String string = o.getId().toString();
                Context mainOrgContext = (Context)this.getLocaleCache().get("deleOrgContext" + string);
                if (mainOrgContext != null) {
                    return mainOrgContext;
                }
                mainOrgContext = new Context();
                FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)string);
                this.getLocaleCache().put("deleOrgContext" + string, mainOrgContext);
                return mainOrgContext;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    protected Context getMainOrgContext() {
        Context ctx = super.getMainOrgContext();
        if (ctx != null) {
            ctx.put((Object)"PIN", (Object)new Long(System.currentTimeMillis()));
        }
        return ctx;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        CoreBaseInfo value = this.getBizInterface().getValue(pk, this.getMergedSelector());
        List list = this.getValueFecthCache((IObjectValue)value);
        this.getCacheManager().batchInvoke(this.getMainOrgContext(), list.toArray(new GeneBatchExecuteParam[list.size()]));
        return value;
    }

    public List getInitCache() {
        ArrayList params = new ArrayList();
        return params;
    }

    public List getOnloadCache() {
        ArrayList params = new ArrayList();
        return params;
    }

    public List getValueFecthCache(IObjectValue value) throws Exception {
        GeneBatchExecuteParam p1;
        ArrayList<GeneBatchExecuteParam> params = new ArrayList<GeneBatchExecuteParam>();
        if (this.isSupportTDPrint() && value.get(value.getPKField()) != null) {
            p1 = new GeneBatchExecuteParam(BOSObjectType.create((String)"4F3E91B2"), IPrintIntegration.class, "getBillPrintInfo", new Class[]{String.class, String.class}, new Object[]{this.getBizType().toString(), value.get(value.getPKField()).toString()});
            params.add(p1);
        }
        p1 = new GeneBatchExecuteParam(BOSObjectType.create((String)"D404A864"), IBTPManager.class, "getRelationCollection", new Class[]{String.class}, new Object[]{value.get(value.getPKField()).toString()});
        params.add(p1);
        return params;
    }

    public Map getLocaleCache() {
        if (this.localeCache == null) {
            this.localeCache = new HashMap();
        }
        return this.localeCache;
    }

    public IGeneCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = GeneCacheManager.getInstance();
        }
        return this.cacheManager;
    }

    public ICoreBase getBizCaller() throws Exception {
        return this.getBizInterface();
    }

    protected void afterSubmitPrint() {
        try {
            super.afterSubmitPrint();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public SelectorItemCollection getInnerSelectors() {
        try {
            return GeneSelectorUtils.getSelector(this.getBizType(), "", true, true, false);
        }
        catch (Exception e) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName(sic, this.getMainBizOrgField());
            return sic;
        }
    }

    protected abstract String getMainBizOrgField();

    public String getResourceName() {
        return this.getMetaDataPK().getFullName() + "Resource";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkBeforeWindowClosing() {
        boolean flag = super.checkBeforeWindowClosing();
        if (!flag || !this.oprtState.equals(OprtState.ADDNEW) || !this.actionRelationDoc.isEnabled() || this.editData == null || this.editData.getId() == null) return flag;
        try {
            if (this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()))) return flag;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return flag;
    }

    @Override
    public void actionRelationDoc_actionPerformed(ActionEvent e) throws Exception {
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public void removeKey(final KDTable table) {
        if (table != null) {
            table.setColumnMoveable(true);
            table.setActiveCellStatus(1);
            table.getActionMap().remove("AddRow");
            table.getActionMap().remove("RemoveRow");
            table.getActionMap().remove("Delete");
            table.getActionMap().remove("Paste");
        }
        AbstractAction actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (table != null) {
                    table.removeRow(table.getRowCount() - 1);
                    GeneBillBaseEditUI.this.addLine(table);
                }
            }
        };
        KDTableHelper.updateEnterWithTab((KDTable)table, (boolean)true, (Action)actionTable);
        KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)true, (Action)actionTable);
    }
}

