/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.client.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.common.client.action.AbstractUIContextAction;
import com.kingdee.eas.barcode.common.client.action.IUIContextAction;
import com.kingdee.eas.base.permission.MutiOrgPermParam;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierSimpleSelector;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.awt.Component;
import java.util.List;
import org.apache.log4j.Logger;

public class SupplierAction
extends AbstractUIContextAction
implements IUIContextAction {
    private static final Logger logger = CoreUIObject.getLogger(SupplierAction.class);
    private static final String QUERY = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierSimpleQuery";
    private KDBizPromptBox prmtBox;
    private OrgType mainOrgType;
    F7SupplierSimpleSelector select;

    public SupplierAction(Component owner, KDBizPromptBox prmtBox, OrgType mainOrgType) {
        this.prmtBox = prmtBox;
        this.mainOrgType = mainOrgType;
        prmtBox.setQueryInfo(QUERY);
        prmtBox.setDisplayFormat("$name$");
        prmtBox.setEditFormat("$number$");
        prmtBox.setCommitFormat("$number$;$name$;$mnemonicCode$");
        this.select = new F7SupplierSimpleSelector((Object)owner, prmtBox);
        this.select.setMulSelect(prmtBox.isEnabledMultiSelection());
        prmtBox.setSelector((KDPromptSelector)this.select);
        EntityViewInfo ev = this.getSupplierFilter(null, mainOrgType);
        this.select.setBaseFilter(ev.getFilter());
        prmtBox.setEntityViewInfo(ev);
    }

    private EntityViewInfo getSupplierFilter(OrgUnitInfo mainOrg, List orgPKList, OrgType mainOrgType) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (mainOrg == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
            ev.setFilter(filter);
            return ev;
        }
        if (mainOrgType == OrgType.Quality) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)mainOrg.getCU().getId().toString()));
        }
        if (mainOrgType == OrgType.Storage) {
            try {
                filter = SupplierFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(mainOrg.getCU().getId()), "id", "cu.id");
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        } else if (mainOrgType == OrgType.ControlUnit) {
            try {
                filter = SupplierFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(mainOrg.getId()), "id", "cu.id");
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        } else if (mainOrgType == OrgType.Company) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FSupplierID from T_BD_SupplierCompanyInfo where FComOrgID='" + mainOrg.getId().toString() + "'"), CompareType.INNER));
        } else if (mainOrgType == OrgType.Purchase) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FSupplierID from T_BD_SupplierPurchaseInfo where FPurchaseOrgID='" + mainOrg.getId().toString() + "'"), CompareType.INNER));
        }
        ev.setFilter(filter);
        return ev;
    }

    private EntityViewInfo getSupplierFilter(OrgUnitInfo mainOrg, OrgType mainOrgType) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (mainOrg == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
            ev.setFilter(filter);
            return ev;
        }
        if (mainOrgType == OrgType.Quality) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)mainOrg.getCU().getId().toString()));
        }
        if (mainOrgType == OrgType.Storage) {
            try {
                filter = SupplierFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(mainOrg.getCU().getId()), "id", "cu.id");
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        } else if (mainOrgType == OrgType.ControlUnit) {
            try {
                filter = SupplierFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(mainOrg.getId()), "id", "cu.id");
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        } else if (mainOrgType == OrgType.Company) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FSupplierID from T_BD_SupplierCompanyInfo where FComOrgID='" + mainOrg.getId().toString() + "'"), CompareType.INNER));
        } else if (mainOrgType == OrgType.Purchase) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FSupplierID from T_BD_SupplierPurchaseInfo where FPurchaseOrgID='" + mainOrg.getId().toString() + "'"), CompareType.INNER));
        }
        ev.setFilter(filter);
        return ev;
    }

    @Override
    public void changeUIContext(CoreUIObject owner, Context context) {
        OrgUnitInfo mainOrg = (OrgUnitInfo)context.get((Object)this.mainOrgType);
        if (mainOrg == null) {
            EntityViewInfo ev = this.getSupplierFilter(mainOrg, this.mainOrgType);
            this.prmtBox.setEntityViewInfo(ev);
            if (ev != null) {
                this.select.setBaseFilter(ev.getFilter());
            }
            this.clean(owner);
            return;
        }
        MutiOrgPermParam mutiOrgInfo = (MutiOrgPermParam)context.get((Object)"MUTI_ORG_INFO");
        EntityViewInfo ev = null;
        ev = mutiOrgInfo == null ? this.getSupplierFilter(mainOrg, this.mainOrgType) : this.getSupplierFilter(mainOrg, mutiOrgInfo.getOrgIdList(), this.mainOrgType);
        this.prmtBox.setEntityViewInfo(ev);
        this.prmtBox.setF7Context(context);
        this.prmtBox.setCurrentCtrlUnit((CtrlUnitInfo)context.get((Object)OrgType.ControlUnit));
        this.clean(owner);
        this.select.setBaseFilter(ev.getFilter());
    }

    private void clean(CoreUIObject owner) {
        if (!this.isloading(owner)) {
            this.prmtBox.setData(null);
        }
    }
}

