/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.client.ccstrategy;

import com.kingdee.eas.barcode.common.client.ccstrategy.GeneClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.GeneDEditClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.GeneDataBaseIClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.GeneS1ClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.GeneS2ClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.GeneS3ClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.GeneS4ClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.IGeneClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.IGeneControlModeEditUIProxy;
import com.kingdee.eas.barcode.common.client.ccstrategy.IGeneControlModeListUIProxy;
import com.kingdee.eas.barcode.common.client.ccstrategy.IGeneControlModeUIProxy;
import org.apache.log4j.Logger;

public class GeneClientControlStrategyFactory {
    private static Logger logger = Logger.getLogger(GeneClientControlStrategyFactory.class);

    public static IGeneClientControlStrategy create(String controlType, IGeneControlModeUIProxy ui) {
        GeneClientControlStrategy ccStrategy = null;
        if (controlType.equals("I")) {
            ccStrategy = new GeneDataBaseIClientControlStrategy(ui);
        } else if (controlType.equals("S1")) {
            ccStrategy = new GeneS1ClientControlStrategy(ui);
        } else if (controlType.equals("S2")) {
            ccStrategy = new GeneS2ClientControlStrategy(ui);
        } else if (controlType.equals("S3")) {
            ccStrategy = new GeneS3ClientControlStrategy(ui);
        } else if (controlType.equals("S4")) {
            ccStrategy = new GeneS4ClientControlStrategy(ui);
        } else if (controlType.equals("D") && !(ui instanceof IGeneControlModeListUIProxy) && ui instanceof IGeneControlModeEditUIProxy) {
            ccStrategy = new GeneDEditClientControlStrategy((IGeneControlModeEditUIProxy)ui);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ui" + ui + " controlType: " + controlType + " ccStrategy:" + ccStrategy));
        }
        return ccStrategy;
    }
}

