/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.client.ccstrategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.common.GeneDataBaseInfo;
import com.kingdee.eas.barcode.common.client.ccstrategy.GeneClientControlStrategy;
import com.kingdee.eas.barcode.common.client.ccstrategy.IGeneControlModeUIProxy;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;

public class GeneDClientControlStrategy
extends GeneClientControlStrategy {
    public GeneDClientControlStrategy(IGeneControlModeUIProxy ui) {
        super(ui);
    }

    @Override
    public String getControlType() {
        return "D";
    }

    @Override
    public FilterInfo getDefaultFilterForControlType() {
        return null;
    }

    public void checkCanAdd() throws Exception {
        this.checkAddPolicy(this.getCurrentCUID(), this._ui.getBizObjectType());
    }

    public void checkCanUpdate(String sltedKeyValue) throws Exception {
        ObjectUuidPK objectPK = new ObjectUuidPK(sltedKeyValue);
        GeneDataBaseInfo dataBaseDInfo = (GeneDataBaseInfo)this._ui.getBizInterface1().getValue((IObjectPK)objectPK);
        if (!dataBaseDInfo.getCU().getId().toString().equals(this.getCurrentCUID())) {
            this.checkUpdatePolicy(this.getCurrentCUID(), this._ui.getBizObjectType());
        }
    }

    public void checkCanDelete(String sltedKeyValue) throws Exception {
        ObjectUuidPK objectPK = new ObjectUuidPK(sltedKeyValue);
        GeneDataBaseInfo dataBaseDInfo = (GeneDataBaseInfo)this._ui.getBizInterface1().getValue((IObjectPK)objectPK);
        if (!dataBaseDInfo.getCU().getId().toString().equals(this.getCurrentCUID())) {
            this.checkDelPolicy(this.getCurrentCUID(), this._ui.getBizObjectType());
        }
    }

    protected void checkAddPolicy(String ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK);
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    protected void checkUpdatePolicy(String ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK);
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    protected void checkDelPolicy(String ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitPK);
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
    }
}

