/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.common.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.common.GeneCommonFacadeFactory;
import com.kingdee.eas.barcode.common.util.SortUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public abstract class GeneClinetOrgUtils {
    private static final Logger logger = CoreUIObject.getLogger(GeneClinetOrgUtils.class);

    public static IObjectValue getObjectValue(String id) {
        try {
            if (id == null || id.length() == 0) {
                return null;
            }
            BOSUuid oid = BOSUuid.read((String)id);
            IDynamicObject iOrgUnit = DynamicObjectFactory.getRemoteInstance();
            IObjectValue orgInfo = iOrgUnit.getValue(oid.getType(), (IObjectPK)new ObjectStringPK(id));
            return orgInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static Object[] getObjectCollection(String ids) {
        if (ids == null || ids.length() == 0) {
            return null;
        }
        try {
            String[] oid = ids.split(",");
            if (oid.length == 0 || oid[0] == null) {
                return null;
            }
            BOSUuid oid0 = BOSUuid.read((String)oid[0]);
            IDynamicObject iOrgUnit = DynamicObjectFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            view.setFilter(filter);
            IObjectCollection collection = iOrgUnit.getCollection(oid0.getType(), view);
            Object[] results = new IObjectValue[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                results[i] = collection.getObject(i);
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static OrgUnitInfo[] getOrgUnitInfos(String ids) {
        if (ids == null || ids.length() == 0) {
            return null;
        }
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            view.setFilter(filter);
            FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
            OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                results[i] = collection.get(i);
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static OrgUnitInfo getDefaultMainBizOrg(OrgType orgType) throws EASBizException, BOSException {
        OrgUnitInfo[] mainOrgs = null;
        mainOrgs = GeneClinetOrgUtils.getAuthorizedBizOrgUnits(orgType);
        if (mainOrgs == null || mainOrgs.length == 0) {
            return null;
        }
        if (mainOrgs.length > 0) {
            mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
        }
        if (mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    public static OrgUnitCollection getOrgByDelegateRelation(OrgType srcType, OrgType destType, String orgID, boolean isto) throws Exception {
        IOrgUnitRelation iorgRelation = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgCols = null;
        orgCols = isto ? iorgRelation.getToUnit(orgID, srcType.getValue(), destType.getValue()) : iorgRelation.getFromUnit(orgID, destType.getValue(), srcType.getValue());
        return orgCols;
    }

    public static OrgUnitInfo[] getAuthorizedBizOrgUnits(OrgType orgType) throws BOSException, EASBizException {
        return GeneCommonFacadeFactory.getRemoteInstance().getAuthorizedBizOrgUnits(orgType, null);
    }

    public static OrgUnitInfo[] getAuthorizedOrgUnits(OrgType orgType) throws BOSException, EASBizException {
        return GeneCommonFacadeFactory.getRemoteInstance().getAuthorizedOrgUnits(orgType, null);
    }

    public static boolean isDiffrent4OrgCollection(OrgUnitCollection collection1, OrgUnitCollection collection2) {
        boolean isChanged = false;
        if (collection1 == null && collection2 != null) {
            isChanged = collection2.size() > 0;
        } else if (collection1 != null && collection2 == null) {
            isChanged = collection1.size() > 0;
        } else if (collection1 != null && collection2 != null) {
            if (collection1.size() != collection2.size()) {
                isChanged = true;
            } else {
                int i;
                ArrayList<String> list = new ArrayList<String>();
                for (i = 0; i < collection1.size(); ++i) {
                    list.add(collection1.get(i).getId().toString());
                }
                for (i = 0; i < collection2.size(); ++i) {
                    if (list.contains(collection2.get(i).getId().toString())) continue;
                    isChanged = true;
                    break;
                }
            }
        }
        return isChanged;
    }
}

