/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.eqm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.common.BillBaseStatusEnum;
import com.kingdee.eas.barcode.common.GeneSysDefinedEnum;
import com.kingdee.eas.barcode.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.barcode.common.core.filter.DateCasterEnum;
import com.kingdee.eas.barcode.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.barcode.common.core.filter.RangeFilterElement;
import com.kingdee.eas.barcode.common.core.filter.SingleFilterElement;
import com.kingdee.eas.barcode.common.util.GeneDateUtils;
import com.kingdee.eas.barcode.common.util.GeneResourceUtil;
import com.kingdee.eas.barcode.common.util.GeneSelectorUtils;
import com.kingdee.eas.barcode.eqm.basedata.EquipmentBizStatus;
import com.kingdee.eas.barcode.eqm.basedata.client.AbstractEquipmentArchivesGroupFilterUI;
import com.kingdee.eas.barcode.eqm.client.util.ControlledItems;
import com.kingdee.eas.barcode.eqm.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EquipmentArchivesGroupFilterUI
extends AbstractEquipmentArchivesGroupFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentArchivesGroupFilterUI.class);
    Map map = new HashMap();

    @Override
    public boolean isSupportMultiOrgs() {
        return false;
    }

    @Override
    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        RangeFilterElement numberElement = new RangeFilterElement("number", (Component)this.txtNumberFrom, (Component)this.txtNumberTo);
        numberElement.getFrom().putUserInfo("key", "number");
        numberElement.getTo().putUserInfo("key", "number");
        numberElement.getFrom().putUserInfo("bosType", "F6065B07");
        numberElement.getTo().putUserInfo("bosType", "F6065B07");
        rootElement.add(numberElement);
        rootElement.add(new SingleFilterElement("category.id", (Component)this.prmtcategory));
        rootElement.add(new SingleFilterElement("type.id", (Component)this.prmttype));
        rootElement.add(new SingleFilterElement("material.id", (Component)this.prmtmaterial));
        RangeFilterElement dateElement = new RangeFilterElement("effectDate", (Component)this.pkeffectDateStart, (Component)this.pkeffectDateEnd);
        dateElement.setDefaultValue(new String[]{GeneDateUtils.getLastMonthString(), GeneDateUtils.getDayBeginString()});
        rootElement.add(dateElement);
        rootElement.add(new SingleFilterElement("location.id", (Component)this.prmtlocation));
        SingleFilterElement bizStatusFilterElement = new SingleFilterElement("bizStatus", (Component)this.bizStatus);
        bizStatusFilterElement.setBlankValue((Object)GeneSysDefinedEnum.SELECT_ALL);
        bizStatusFilterElement.setDefaultValue(String.valueOf(999));
        bizStatusFilterElement.setDataCaster(DateCasterEnum.IINTEGER_DC);
        rootElement.add(bizStatusFilterElement);
        SingleFilterElement billStatusElement = new SingleFilterElement("billStatus", (Component)this.cboBillStatus);
        billStatusElement.setBlankValue((Object)GeneSysDefinedEnum.SELECT_ALL);
        billStatusElement.setDefaultValue(String.valueOf(999));
        billStatusElement.setDataCaster(DateCasterEnum.IINTEGER_DC);
        rootElement.add(billStatusElement);
    }

    @Override
    public boolean verify() {
        Date endDate;
        Date startDate;
        if (this.pkeffectDateStart.getValue() != null && this.pkeffectDateEnd.getValue() != null && (startDate = (Date)this.pkeffectDateStart.getValue()).compareTo(endDate = (Date)this.pkeffectDateEnd.getValue()) > 0) {
            MsgBox.showInfo((String)GeneResourceUtil.getMsg("com.kingdee.eas.eqm.archives.EquipmentArchivesResource", "Msg_EffectStartDateLessthanEndDate", null));
            return false;
        }
        return super.verify();
    }

    @Override
    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        super.afterMainOrgChanged(oldOrg, org);
        try {
            this.regisiterMaterial();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    @Override
    public ControlledItems[] getNeedMainOrgControl() {
        return new ControlledItems[]{new ControlledItems(this.txtNumberFrom), new ControlledItems(this.txtNumberTo), new ControlledItems(this.prmtlocation)};
    }

    @Override
    protected void registerCustomerBindings() {
        this.bizStatus.removeAllItems();
        this.bizStatus.addItems(new Object[]{GeneSysDefinedEnum.SELECT_ALL, EquipmentBizStatus.using, EquipmentBizStatus.maintaining, EquipmentBizStatus.keeping, EquipmentBizStatus.wornouting, EquipmentBizStatus.saling, EquipmentBizStatus.renting, EquipmentBizStatus.returning, EquipmentBizStatus.idle, EquipmentBizStatus.transferred, EquipmentBizStatus.discontinuation, EquipmentBizStatus.backup, EquipmentBizStatus.damaged, EquipmentBizStatus.repairing, EquipmentBizStatus.other});
        this.cboBillStatus.removeAllItems();
        this.cboBillStatus.addItems(new Object[]{GeneSysDefinedEnum.SELECT_ALL, BillBaseStatusEnum.TEMPORARILYSAVED, BillBaseStatusEnum.SUBMITED, BillBaseStatusEnum.AUDITED});
        super.registerCustomerBindings();
        try {
            EQMPromptDialogFactory.createPrmptList(this.prmtlocation, "com.kingdee.eas.barcode.eqm.basedata.app.EquipmentLocationQuery", new String[]{"installLimit"}, new Object[]{Boolean.TRUE});
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        try {
            this.regisiterMaterial();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void regisiterMaterial() throws BOSException {
        OrgUnitInfo org = (OrgUnitInfo)this.prmtOrgUnit.getValue();
        if (org == null) {
            org = this.getMainOrgInfo();
        }
        if (org == null) {
            return;
        }
        if (org.getCU() == null || org.getCU() != null && org.getCU().getNumber() == null || org.getCU() != null && org.getCU().getLongNumber() == null) {
            try {
                if (this.map.get(org.getId()) == null) {
                    if (org.getCU() == null) {
                        ICompanyOrgUnit iCompanyOrg = CompanyOrgUnitFactory.getRemoteInstance();
                        CompanyOrgUnitInfo org1 = iCompanyOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()), GeneSelectorUtils.getSelector(new StorageOrgUnitInfo().getBOSType(), "", false, true, false));
                        org.setCU(org1.getCU());
                        this.map.put(org.getId(), org);
                    } else {
                        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
                        org.setCU(ctrlUnitInfo);
                        this.map.put(org.getId(), org);
                    }
                } else {
                    org = (OrgUnitInfo)this.map.get(org.getId());
                }
            }
            catch (EASBizException eASBizException) {
                // empty catch block
            }
        }
        EQMPromptDialogFactory.createPrmptList(this.prmtmaterial, "com.kingdee.eas.eqm.archives.app.F7MaterialQuery", new String[]{"CU.id", "equipProperty"}, new Object[]{org != null && org.getCU() != null && org.getCU().getId() != null ? org.getCU().getId().toString() : SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), new Integer(0)}, new CompareType[]{CompareType.EQUALS, CompareType.EQUALS});
        this.prmtmaterial.setCurrentMainBizOrgUnit(org, OrgType.Storage);
    }
}

