/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.eqm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.common.BillBaseStatusEnum;
import com.kingdee.eas.barcode.common.util.GeneSelectorUtils;
import com.kingdee.eas.barcode.eqm.LocationDiffBillEntryCollection;
import com.kingdee.eas.barcode.eqm.LocationDiffBillEntryInfo;
import com.kingdee.eas.barcode.eqm.LocationDiffBillFactory;
import com.kingdee.eas.barcode.eqm.LocationDiffBillInfo;
import com.kingdee.eas.barcode.eqm.StocktakingBillEntryInfo;
import com.kingdee.eas.barcode.eqm.StocktakingBillFactory;
import com.kingdee.eas.barcode.eqm.StocktakingBillInfo;
import com.kingdee.eas.barcode.eqm.StocktakingTaskBillFactory;
import com.kingdee.eas.barcode.eqm.StocktakingTaskBillInfo;
import com.kingdee.eas.barcode.eqm.basedata.AbstractEquipmentArchivesInfo;
import com.kingdee.eas.barcode.eqm.basedata.EquipmentArchivesFactory;
import com.kingdee.eas.barcode.eqm.basedata.EquipmentArchivesInfo;
import com.kingdee.eas.barcode.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.barcode.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.barcode.eqm.basedata.IEquipmentArchives;
import com.kingdee.eas.barcode.eqm.basedata.IEquipmentLocation;
import com.kingdee.eas.barcode.eqm.client.AbstractLocationDiffBillEditUI;
import com.kingdee.eas.barcode.eqm.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class LocationDiffBillEditUI
extends AbstractLocationDiffBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LocationDiffBillEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtCompanyOrgUnit.setEnabled(false);
        this.txtNumber.setEnabled(false);
    }

    @Override
    public void registerCustomerBindings() {
        super.registerCustomerBindings();
        EQMPromptDialogFactory.createPrmptOrgDialog(this.prmtCompanyOrgUnit, null, false, this.getMainBizOrgType(), true, false);
        this.actionSave.setVisible(false);
        this.btnSave.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.menuItemRemove.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionViewSubmitProccess.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionAudit.setVisible(false);
        this.actionUnAudit.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionRemove.setVisible(false);
        this.prmtCompanyOrgUnit.setEnabled(false);
        this.txtNumber.setEnabled(false);
        KDTextField kdtEntrys_remark_DatePicker = new KDTextField();
        kdtEntrys_remark_DatePicker.setName("kdtEntrys_remark_DatePicker");
        kdtEntrys_remark_DatePicker.setVisible(true);
        kdtEntrys_remark_DatePicker.setEditable(true);
        kdtEntrys_remark_DatePicker.setMaxLength(255);
        KDTDefaultCellEditor kdtEntrys_remark_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_remark_DatePicker);
        this.kdtEntrys.getColumn("remark").setEditor((ICellEditor)kdtEntrys_remark_CellEditor);
        this.kdtEntrys.getColumn("description").getStyleAttributes().setHided(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LocationDiffBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        LocationDiffBillInfo info = new LocationDiffBillInfo();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.getMainOrgInfo();
        if (companyOrgUnitInfo != null && !companyOrgUnitInfo.isIsBizUnit()) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
        }
        info.setCompany(companyOrgUnitInfo);
        info.setBillStatus(BillBaseStatusEnum.ADD);
        StocktakingTaskBillInfo task = (StocktakingTaskBillInfo)this.getUIContext().get("TASK_INFO");
        StocktakingBillInfo st = (StocktakingBillInfo)this.getUIContext().get("ST_INFO");
        try {
            task = StocktakingTaskBillFactory.getRemoteInstance().getStocktakingTaskBillInfo((IObjectPK)new ObjectUuidPK(task.getId().toString()));
            st = StocktakingBillFactory.getRemoteInstance().getStocktakingBillInfo((IObjectPK)new ObjectUuidPK(st.getId().toString()));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        info.setStockTakingTastNo(task);
        info.setStockTakingNo(st);
        info.setNumber(st.getNumber() + "_DF02");
        info.setStBeginDate(st.getBeginDate());
        info.setStEndDate(st.getEndDate());
        PersonInfo ps = null;
        if (null != st.getOperator() && null != st.getOperator().getId()) {
            try {
                ps = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(st.getOperator().getId().toString()));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        info.setStActor(ps);
        try {
            this.loadDiff(st, info);
            this.loadFields();
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        return info;
    }

    private void loadDiff(StocktakingBillInfo st, LocationDiffBillInfo info) throws BOSException, EASBizException {
        if (null != st) {
            info.put("entrys", (Object)new LocationDiffBillEntryCollection());
            StocktakingBillEntryInfo est = new StocktakingBillEntryInfo();
            LocationDiffBillEntryInfo einfo = new LocationDiffBillEntryInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            GeneSelectorUtils.addSelectorWithPros(sic, "", new String[]{"id", "name", "number", "bizStatus", "location"});
            MeasureUnitInfo uinfo = null;
            EquipmentLocationInfo acclocation = null;
            EquipmentLocationInfo reallocation = null;
            AbstractEquipmentArchivesInfo eqmArchives = null;
            IEquipmentArchives iea = EquipmentArchivesFactory.getRemoteInstance();
            IMeasureUnit imu = MeasureUnitFactory.getRemoteInstance();
            IEquipmentLocation iel = EquipmentLocationFactory.getRemoteInstance();
            boolean dif = false;
            for (int j = 0; j < st.getEntrys().size(); ++j) {
                est = st.getEntrys().get(j);
                dif = false;
                eqmArchives = null;
                if (null != est.getEqmNumber() && null != est.getEqmNumber().getId()) {
                    eqmArchives = iea.getEquipmentArchivesInfo((IObjectPK)new ObjectUuidPK(est.getEqmNumber().getId().toString()));
                }
                if ((null == eqmArchives || null == eqmArchives.getLocation() || eqmArchives.getLocation().equals(est.getLocation())) && (null == est.getLocation() || est.getLocation().equals(eqmArchives.getLocation()))) continue;
                dif = true;
                if (null != eqmArchives.getLocation() && null != est.getLocation()) {
                    String tmpln;
                    reallocation = iel.getEquipmentLocationInfo((IObjectPK)new ObjectUuidPK(est.getLocation().getId().toString()));
                    acclocation = iel.getEquipmentLocationInfo((IObjectPK)new ObjectUuidPK(eqmArchives.getLocation().getId().toString()));
                    String ln = acclocation.getLongNumber();
                    if (ln.indexOf(tmpln = reallocation.getLongNumber()) >= 0) {
                        dif = false;
                    }
                }
                if (!dif) continue;
                einfo = new LocationDiffBillEntryInfo();
                einfo.setEquipment((EquipmentArchivesInfo)eqmArchives);
                einfo.setEquName(est.getEqmName());
                einfo.setEquModel(est.getModel());
                uinfo = null;
                if (null != est.getUnit() && null != est.getUnit().getId()) {
                    uinfo = imu.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(est.getUnit().getId().toString()));
                }
                einfo.setUnit(uinfo);
                reallocation = null;
                if (null != est.getLocation() && null != est.getLocation().getId()) {
                    reallocation = iel.getEquipmentLocationInfo((IObjectPK)new ObjectUuidPK(est.getLocation().getId().toString()));
                }
                acclocation = null;
                if (null != eqmArchives.getLocation() && null != eqmArchives.getLocation().getId()) {
                    acclocation = iel.getEquipmentLocationInfo((IObjectPK)new ObjectUuidPK(eqmArchives.getLocation().getId().toString()));
                }
                einfo.setRealEquLocation(reallocation);
                einfo.setAccountEquLocation(acclocation);
                info.getEntrys().add(einfo);
                IRow row = this.kdtEntrys.addRow();
                this.loadLineFields(this.kdtEntrys, row, (IObjectValue)einfo);
            }
        }
        this.kdtEntrys.checkParsed();
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable arg0, IRow arg1) {
        return null;
    }

    @Override
    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected IObjectValue newInstanceData() throws EASBizException, BOSException {
        return null;
    }
}

