/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.eqm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.common.BillBaseStatusEnum;
import com.kingdee.eas.barcode.eqm.StockDiffBillEntryCollection;
import com.kingdee.eas.barcode.eqm.StockDiffBillEntryInfo;
import com.kingdee.eas.barcode.eqm.StockDiffBillFactory;
import com.kingdee.eas.barcode.eqm.StockDiffBillInfo;
import com.kingdee.eas.barcode.eqm.StocktakingBillEntryInfo;
import com.kingdee.eas.barcode.eqm.StocktakingBillFactory;
import com.kingdee.eas.barcode.eqm.StocktakingBillInfo;
import com.kingdee.eas.barcode.eqm.StocktakingTaskBillFactory;
import com.kingdee.eas.barcode.eqm.StocktakingTaskBillInfo;
import com.kingdee.eas.barcode.eqm.basedata.AbstractEquipmentArchivesInfo;
import com.kingdee.eas.barcode.eqm.basedata.EquipmentArchivesFactory;
import com.kingdee.eas.barcode.eqm.basedata.EquipmentArchivesInfo;
import com.kingdee.eas.barcode.eqm.basedata.IEquipmentArchives;
import com.kingdee.eas.barcode.eqm.client.AbstractStockDiffBillEditUI;
import com.kingdee.eas.barcode.eqm.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.SysUtil;
import java.math.BigDecimal;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StockDiffBillEditUI
extends AbstractStockDiffBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StockDiffBillEditUI.class);
    protected DetailPanel kdtEntrys_detailPanel = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void registerCustomerBindings() {
        super.registerCustomerBindings();
        EQMPromptDialogFactory.createPrmptOrgDialog(this.prmtCompanyOrgUnit, null, false, this.getMainBizOrgType(), true, false);
        this.actionSave.setVisible(false);
        this.btnSave.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.menuItemRemove.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionViewSubmitProccess.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionAudit.setVisible(false);
        this.actionUnAudit.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionRemove.setVisible(false);
        this.prmtCompanyOrgUnit.setEnabled(false);
        this.txtNumber.setEnabled(false);
        KDTextField kdtEntrys_remark_DatePicker = new KDTextField();
        kdtEntrys_remark_DatePicker.setName("kdtEntrys_remark_DatePicker");
        kdtEntrys_remark_DatePicker.setVisible(true);
        kdtEntrys_remark_DatePicker.setEditable(true);
        kdtEntrys_remark_DatePicker.setMaxLength(255);
        KDTDefaultCellEditor kdtEntrys_remark_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_remark_DatePicker);
        this.kdtEntrys.getColumn("remark").setEditor((ICellEditor)kdtEntrys_remark_CellEditor);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockDiffBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        StockDiffBillInfo info = new StockDiffBillInfo();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.getMainOrgInfo();
        if (companyOrgUnitInfo != null && !companyOrgUnitInfo.isIsBizUnit()) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
        }
        info.setCompany(companyOrgUnitInfo);
        info.setBillStatus(BillBaseStatusEnum.ADD);
        StocktakingTaskBillInfo task = (StocktakingTaskBillInfo)this.getUIContext().get("TASK_INFO");
        StocktakingBillInfo st = (StocktakingBillInfo)this.getUIContext().get("ST_INFO");
        try {
            task = StocktakingTaskBillFactory.getRemoteInstance().getStocktakingTaskBillInfo((IObjectPK)new ObjectUuidPK(task.getId().toString()));
            st = StocktakingBillFactory.getRemoteInstance().getStocktakingBillInfo((IObjectPK)new ObjectUuidPK(st.getId().toString()));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        info.setStockTakingTastNo(task);
        info.setStockTakingNo(st);
        info.setNumber(st.getNumber() + "_DF01");
        info.setStBeginDate(st.getBeginDate());
        info.setStEndDate(st.getEndDate());
        PersonInfo ps = null;
        if (null != st.getOperator() && null != st.getOperator().getId()) {
            try {
                ps = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(st.getOperator().getId().toString()));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        info.setStActor(ps);
        try {
            this.loadDiff(st, info);
            this.loadFields();
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        return info;
    }

    private void loadDiff(StocktakingBillInfo st, StockDiffBillInfo info) throws BOSException, EASBizException {
        if (null != st) {
            info.put("entrys", (Object)new StockDiffBillEntryCollection());
            StocktakingBillEntryInfo est = new StocktakingBillEntryInfo();
            StockDiffBillEntryInfo einfo = new StockDiffBillEntryInfo();
            BigDecimal realqty = BigDecimal.ZERO;
            BigDecimal accqty = BigDecimal.ZERO;
            MeasureUnitInfo uinfo = null;
            AbstractEquipmentArchivesInfo eqmArchives = null;
            IEquipmentArchives iea = EquipmentArchivesFactory.getRemoteInstance();
            IMeasureUnit imu = MeasureUnitFactory.getRemoteInstance();
            for (int j = 0; j < st.getEntrys().size(); ++j) {
                est = st.getEntrys().get(j);
                realqty = BigDecimal.ZERO;
                accqty = BigDecimal.ZERO;
                realqty = est.getStocktakingAmt();
                accqty = est.getAssetAmt();
                eqmArchives = null;
                if (null != est.getEqmNumber() && null != est.getEqmNumber().getId()) {
                    eqmArchives = iea.getEquipmentArchivesInfo((IObjectPK)new ObjectUuidPK(est.getEqmNumber().getId().toString()));
                }
                if (null == eqmArchives || realqty.compareTo(accqty) == 0 && (null == est.getBizStatus() || est.getBizStatus().equals((Object)eqmArchives.getBizStatus())) && (null == eqmArchives.getBizStatus() || eqmArchives.getBizStatus().equals((Object)est.getBizStatus()))) continue;
                einfo = new StockDiffBillEntryInfo();
                einfo.setEquipment((EquipmentArchivesInfo)eqmArchives);
                einfo.setEquName(est.getEqmName());
                einfo.setEquModel(est.getModel());
                if (null != est.getUnit() && null != est.getUnit().getId()) {
                    uinfo = imu.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(est.getUnit().getId().toString()));
                }
                einfo.setUnit(uinfo);
                einfo.setRealEquSataus(est.getBizStatus());
                einfo.setAccountEquStatus(eqmArchives.getBizStatus());
                einfo.setRealEquQty(realqty);
                einfo.setAccountEquQty(accqty);
                einfo.setInvProfitQty(BigDecimal.ZERO);
                einfo.setInvLossQty(BigDecimal.ZERO);
                if (realqty.compareTo(accqty) > 0) {
                    einfo.setInvProfitQty(realqty.subtract(accqty));
                } else {
                    einfo.setInvLossQty(accqty.subtract(realqty));
                }
                info.getEntrys().add(einfo);
                IRow row = this.kdtEntrys.addRow();
                this.loadLineFields(this.kdtEntrys, row, (IObjectValue)einfo);
            }
        }
        this.kdtEntrys.checkParsed();
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable arg0, IRow arg1) {
        return null;
    }

    @Override
    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected IObjectValue newInstanceData() throws EASBizException, BOSException {
        return null;
    }
}

