/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.eqm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.barcode.common.BillBaseStatusEnum;
import com.kingdee.eas.barcode.common.GeneBillBaseInfo;
import com.kingdee.eas.barcode.common.client.GeneBillBaseFilterUI;
import com.kingdee.eas.barcode.common.client.util.GeneClientUtils;
import com.kingdee.eas.barcode.eqm.LocationDiffBillCollection;
import com.kingdee.eas.barcode.eqm.LocationDiffBillFactory;
import com.kingdee.eas.barcode.eqm.LocationDiffBillInfo;
import com.kingdee.eas.barcode.eqm.StockDiffBillCollection;
import com.kingdee.eas.barcode.eqm.StockDiffBillFactory;
import com.kingdee.eas.barcode.eqm.StockDiffBillInfo;
import com.kingdee.eas.barcode.eqm.StocktakingBillCollection;
import com.kingdee.eas.barcode.eqm.StocktakingBillFactory;
import com.kingdee.eas.barcode.eqm.StocktakingBillInfo;
import com.kingdee.eas.barcode.eqm.StocktakingTaskBillFactory;
import com.kingdee.eas.barcode.eqm.StocktakingTaskBillInfo;
import com.kingdee.eas.barcode.eqm.client.AbstractStocktakingTaskBillListUI;
import com.kingdee.eas.barcode.eqm.client.StocktakingTaskBillFilterUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class StocktakingTaskBillListUI
extends AbstractStocktakingTaskBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(StocktakingTaskBillListUI.class);

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBeginStock.setIcon(EASResource.getIcon((String)"imgTbtn_checkstart"));
        this.btnViewStock.setIcon(EASResource.getIcon((String)"imgTbtn_seechecklist"));
        this.btnCancelStock.setIcon(EASResource.getIcon((String)"imgTbtn_cancelcase"));
        this.btnGenStockRpt.setIcon(EASResource.getIcon((String)"imgTbtn_makechecklist"));
        this.btnCancelStockRpt.setIcon(EASResource.getIcon((String)"imgTbtn_checklose"));
        this.btnGenStockaop.setIcon(EASResource.getIcon((String)"imgTbtn_collatethereunder"));
        this.btnDeleteStockAOP.setIcon(EASResource.getIcon((String)"imgTbtn_cancelentrusted"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionBeginStock_actionPerformed(ActionEvent e) throws Exception {
        StocktakingTaskBillInfo taskInfo = this.getSelectBillInfo(this.getSelectedKeyValue());
        if (this.getStocktakingBillInfo(taskInfo.getId().toString()) != null) {
            this.abort("billHadGenerated");
        } else if (!taskInfo.getBillStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.abort("cannotBeginStock");
        }
        UIContext context = new UIContext((Object)this);
        String oql = "select * where id='" + taskInfo.getId() + "'";
        taskInfo = StocktakingTaskBillFactory.getRemoteInstance().getStocktakingTaskBillInfo(oql);
        context.put((Object)"TASK_INFO", (Object)taskInfo);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.barcode.eqm.client.StocktakingBillEditUI", (Map)context, null, OprtState.ADDNEW);
        window.show();
        this.refreshList();
    }

    @Override
    public void actionCancelStock_actionPerformed(ActionEvent e) throws Exception {
        StocktakingTaskBillInfo taskInfo = this.getSelectBillInfo(this.getSelectedKeyValue());
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.eqm.StocktakingResource", (String)"cancelStockConfirm")))) {
            StocktakingBillInfo billInfo = this.getStocktakingBillInfo(taskInfo.getId().toString());
            if (billInfo == null) {
                this.abort("billNotFound");
            } else if (taskInfo.getBillStatus().getValue() >= 81) {
                String msg = EASResource.getString((String)"com.kingdee.eas.barcode.eqm.StocktakingResource", (String)"cannotCancelStock");
                MsgBox.showInfo((Component)((Object)this), (String)msg.replaceAll("\\{0\\}", taskInfo.getBillStatus().toString()));
                SysUtil.abort();
            }
            StocktakingBillFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(billInfo.getId()));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.eqm.StocktakingResource", (String)"cancelStockSucc"));
            this.refreshList();
        }
    }

    @Override
    public void actionViewStock_actionPerformed(ActionEvent e) throws Exception {
        StocktakingTaskBillInfo taskInfo = this.getSelectBillInfo(this.getSelectedKeyValue());
        StocktakingBillInfo billInfo = this.getStocktakingBillInfo(taskInfo.getId().toString());
        if (billInfo == null) {
            this.abort("billNotFound");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)billInfo.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.barcode.eqm.client.StocktakingBillEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionGenStockRpt_actionPerformed(ActionEvent e) throws Exception {
        StocktakingTaskBillInfo taskinfo = this.getSelectBillInfo(this.getSelectedKeyValue());
        if (null == taskinfo || null == taskinfo.getId()) {
            this.abort("billNotFound");
        } else if (!BillBaseStatusEnum.ENDSTOCKTAKING.equals((Object)taskinfo.getBillStatus()) && !BillBaseStatusEnum.BEGINREPORT.equals((Object)taskinfo.getBillStatus())) {
            MsgBox.showInfo((String)"\u53ea\u6709\u5df2\u5b8c\u6210\u76d8\u70b9\u7684\u4efb\u52a1\u5355\u624d\u80fd\u751f\u6210\u5dee\u5f02\u8868\uff01");
            SysUtil.abort();
        }
        StocktakingBillInfo stinfo = this.getStocktakingBillInfo(taskinfo.getId().toString());
        if (stinfo == null) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u751f\u6210\u76d8\u70b9\u5355\uff01");
            SysUtil.abort();
        }
        IObjectPK pk = StockDiffBillFactory.getRemoteInstance().getStockDiffBillByTask(taskinfo.getId().toString());
        UIContext uiContext = new UIContext((Object)this);
        if (null != pk) {
            uiContext.put((Object)"ID", (Object)pk.toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.barcode.eqm.client.StockDiffBillEditUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionCancelStockRpt_actionPerformed(ActionEvent e) throws Exception {
        StocktakingTaskBillInfo taskInfo = this.getSelectBillInfo(this.getSelectedKeyValue());
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)"\u662f\u5426\u786e\u5b9a\u5220\u9664\u5bf9\u5e94\u7684\u76d8\u70b9\u5dee\u5f02\u8868\uff1f"))) {
            StockDiffBillInfo billInfo = this.getStockDiffBillInfo(taskInfo.getId().toString());
            if (billInfo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8be5\u5355\u636e\u6ca1\u6709\u5bf9\u5e94\u7684\u76d8\u70b9\u5dee\u5f02\u8868\uff01");
                SysUtil.abort();
            }
            StockDiffBillFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(billInfo.getId()));
            MsgBox.showInfo((Component)((Object)this), (String)"\u5220\u9664\u76d8\u70b9\u5dee\u5f02\u8868\u6210\u529f\uff01");
            this.refreshList();
        }
    }

    @Override
    public void actionGenStockaop_actionPerformed(ActionEvent e) throws Exception {
        StocktakingTaskBillInfo taskinfo = this.getSelectBillInfo(this.getSelectedKeyValue());
        if (null == taskinfo || null == taskinfo.getId()) {
            this.abort("billNotFound");
        } else if (!BillBaseStatusEnum.ENDSTOCKTAKING.equals((Object)taskinfo.getBillStatus()) && !BillBaseStatusEnum.BEGINREPORT.equals((Object)taskinfo.getBillStatus())) {
            MsgBox.showInfo((String)"\u53ea\u6709\u5df2\u5b8c\u6210\u76d8\u70b9\u7684\u4efb\u52a1\u5355\u624d\u80fd\u751f\u6210\u5dee\u5f02\u8868\uff01");
            SysUtil.abort();
        }
        StocktakingBillInfo stinfo = this.getStocktakingBillInfo(taskinfo.getId().toString());
        if (stinfo == null) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u751f\u6210\u76d8\u70b9\u5355\uff01");
            SysUtil.abort();
        }
        IObjectPK pk = LocationDiffBillFactory.getRemoteInstance().getLocationDiffBillByTask(taskinfo.getId().toString());
        UIContext uiContext = new UIContext((Object)this);
        if (null != pk) {
            uiContext.put((Object)"ID", (Object)pk.toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.barcode.eqm.client.LocationDiffBillEditUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionDeleteStockAOP_actionPerformed(ActionEvent e) throws Exception {
        StocktakingTaskBillInfo taskInfo = this.getSelectBillInfo(this.getSelectedKeyValue());
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)"\u662f\u5426\u786e\u5b9a\u5220\u9664\u5bf9\u5e94\u7684\u8d44\u4ea7\u4fe1\u606f\u5dee\u5f02\u8868\uff1f"))) {
            LocationDiffBillInfo billInfo = this.getLocationDiffBillInfo(taskInfo.getId().toString());
            if (billInfo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8be5\u5355\u636e\u6ca1\u6709\u5bf9\u5e94\u7684\u8d44\u4ea7\u4fe1\u606f\u5dee\u5f02\u8868\uff01");
                SysUtil.abort();
            }
            LocationDiffBillFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(billInfo.getId()));
            MsgBox.showInfo((Component)((Object)this), (String)"\u5220\u9664\u8d44\u4ea7\u4fe1\u606f\u5dee\u5f02\u8868\u6210\u529f\uff01");
            this.refreshList();
        }
    }

    @Override
    protected void checkCanEdit(GeneBillBaseInfo billInfo) throws Exception {
        if (billInfo.getBillStatus() == BillBaseStatusEnum.AUDITED || billInfo.getBillStatus() == BillBaseStatusEnum.BEGINSTOCKTAKING || billInfo.getBillStatus() == BillBaseStatusEnum.ENDSTOCKTAKING || billInfo.getBillStatus() == BillBaseStatusEnum.BEGINREPORT) {
            MsgBox.showWarning((Component)((Object)this), (String)(GeneClientUtils.getResource("BillAt") + billInfo.getBillStatus().getAlias() + GeneClientUtils.getResource("CantBeEdited")));
            SysUtil.abort();
        }
    }

    private void abort(String resource) {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.eqm.StocktakingResource", (String)resource));
        SysUtil.abort();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0, EntityViewInfo arg1) {
        return super.getQueryExecutor(arg0, arg1);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StocktakingTaskBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        StocktakingTaskBillInfo objectValue = new StocktakingTaskBillInfo();
        return objectValue;
    }

    private StocktakingBillInfo getStocktakingBillInfo(String taskId) throws BOSException {
        if (taskId == null || taskId.trim().length() == 0) {
            return null;
        }
        StocktakingBillCollection result = StocktakingBillFactory.getRemoteInstance().getStocktakingBillCollection("select id where taskBill.id='" + taskId + "'");
        if (result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    private StocktakingTaskBillInfo getSelectBillInfo(String key) throws BOSException, EASBizException {
        this.checkSelected();
        StocktakingTaskBillInfo bill = StocktakingTaskBillFactory.getRemoteInstance().getStocktakingTaskBillInfo("select id,billStatus where id ='" + key + "'");
        return bill;
    }

    @Override
    protected GeneBillBaseFilterUI newInstanceFilterUI() throws Exception {
        StocktakingTaskBillFilterUI filterUI = new StocktakingTaskBillFilterUI();
        return filterUI;
    }

    private StockDiffBillInfo getStockDiffBillInfo(String key) throws BOSException, EASBizException {
        this.checkSelected();
        StockDiffBillInfo bill = null;
        StockDiffBillCollection col = StockDiffBillFactory.getRemoteInstance().getStockDiffBillCollection("where stockTakingTastNo.id ='" + key + "'");
        if (null != col && col.size() > 0) {
            bill = col.get(0);
        }
        return bill;
    }

    private LocationDiffBillInfo getLocationDiffBillInfo(String key) throws BOSException, EASBizException {
        this.checkSelected();
        LocationDiffBillInfo bill = null;
        LocationDiffBillCollection col = LocationDiffBillFactory.getRemoteInstance().getLocationDiffBillCollection("where stockTakingTastNo.id ='" + key + "'");
        if (null != col && col.size() > 0) {
            bill = col.get(0);
        }
        return bill;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }
}

