/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.fa.manage.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.fa.manage.FAExBaseStatusEnum;
import com.kingdee.eas.barcode.fa.manage.FaStockTakingInfoBillFactory;
import com.kingdee.eas.barcode.fa.manage.FaStockTakingInfoBillInfo;
import com.kingdee.eas.barcode.fa.manage.FaStockTakingInfoEntryInfo;
import com.kingdee.eas.barcode.fa.manage.client.AbstractFaStockTakingInfoEditUI;
import com.kingdee.eas.barcode.fa.manage.client.ExtensionFileFilter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.KDImagePanel;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.util.UUID;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FaStockTakingInfoEditUI
extends AbstractFaStockTakingInfoEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaStockTakingInfoEditUI.class);
    private Map imagePanles = new HashMap();
    private List deleteFiles = new ArrayList();
    private int currrow = -1;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        int rowCount = this.detailTable.getRowCount();
        if (rowCount > 0) {
            this.showImage(0);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaStockTakingInfoBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        FaStockTakingInfoBillInfo info = new FaStockTakingInfoBillInfo();
        info.setBizDate(new Date());
        info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        return info;
    }

    public void onLoad() throws Exception {
        this.largeImg.setSize(new Dimension(460, 340));
        this.pkAuditTime.setValue(null);
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        if (this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT")) {
            this.actionAddLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        } else {
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
        this.actionAddLine.setVisible(true);
        this.actionRemoveLine.setVisible(true);
        this.kDContainer1.addButton((JButton)this.btnAddLine);
        this.kDContainer1.addButton((JButton)this.btnRemoveLine);
        this.btnAddLine.setText("\u6dfb\u52a0\u56fe\u7247");
        this.btnRemoveLine.setText("\u5220\u9664\u56fe\u7247");
        this.actionAddLine.setEnabled(false);
        this.btnAddLine.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionSubmit.setVisible(false);
        this.actionSubmit.setEnabled(false);
        this.actionFirst.setVisible(false);
        this.actionFirst.setEnabled(false);
        this.actionLast.setVisible(false);
        this.actionLast.setEnabled(false);
        this.actionPre.setVisible(false);
        this.actionPre.setEnabled(false);
        this.actionNext.setVisible(false);
        this.actionNext.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkFlowG.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
    }

    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int begin = this.detailTable.getSelectManager().get().getBeginRow();
        int end = this.detailTable.getSelectManager().get().getEndRow();
        ArrayList<String> list = new ArrayList<String>();
        for (i = begin; i <= end; ++i) {
            list.add(this.detailTable.getCell(i, "id").getValue().toString());
        }
        super.actionRemoveLine_actionPerformed(e);
        for (i = 0; i < list.size(); ++i) {
            this.imagePanles.remove(list.get(i));
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEditRemove();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEditRemove();
        super.actionRemove_actionPerformed(e);
    }

    private void checkCanEditRemove() {
        FAExBaseStatusEnum status = this.editData.getBaseStatus();
        if (FAExBaseStatusEnum.ADDNEW.equals((Object)status) || FAExBaseStatusEnum.SUBMIT.equals((Object)status)) {
            return;
        }
        MsgBox.showInfo((Component)((Object)this), (String)"\u975e\u65b0\u589e,\u63d0\u4ea4\u72b6\u6001\u4e0d\u80fd\u4fee\u6539\u6216\u5220\u9664");
        SysUtil.abort();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        try {
            String strFullPath = FaStockTakingInfoEditUI.getSelectFile((CoreUIObject)this, false, "jpg");
            if (strFullPath != null) {
                File file = new File(strFullPath);
                if (!file.exists()) {
                    MsgBox.showWarning((Component)((Object)this), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
                    return;
                }
                boolean isOld = true;
                File destFile = null;
                int width = 700;
                int height = 560;
                BufferedImage image = ImageIO.read(file);
                int srcWidth = image.getWidth(null);
                int srcHeight = image.getHeight(null);
                int newWidth = 0;
                int newHeight = 0;
                long fileLen = file.length();
                int x = 0;
                int y = 0;
                double scale_w = width / srcWidth;
                double scale_h = height / srcHeight;
                if (srcWidth > height) {
                    if (scale_w < scale_h) {
                        newHeight = height;
                        newWidth = (int)((double)srcWidth * scale_h);
                        x = (newWidth - width) / 2;
                    } else {
                        newHeight = (int)((double)srcHeight * scale_w);
                        newWidth = width;
                        y = (newHeight - height) / 2;
                    }
                    x = (newWidth - width) / 2;
                    y = (newHeight - height) / 2;
                    isOld = false;
                    BufferedImage newImage = new BufferedImage(srcWidth, srcHeight, 1);
                    newImage.getGraphics().drawImage(image.getScaledInstance(srcWidth, srcHeight, 4), 0, 0, null);
                    String fileSufix = file.getName().substring(file.getName().lastIndexOf(".") + 1);
                    destFile = new File(file.getParent(), UUID.randomUUID().toString() + "." + fileSufix);
                    ImageIO.write((RenderedImage)newImage.getSubimage(0, 0, srcWidth, srcHeight), fileSufix, destFile);
                    this.deleteFiles.add(destFile);
                }
                FaStockTakingInfoEntryInfo entry = (FaStockTakingInfoEntryInfo)this.createNewDetailData(this.getDetailTable());
                String fileName = file.getName();
                if (fileName.length() > 80) {
                    fileName = fileName.substring(fileName.length() - 80);
                }
                entry.setFileName(fileName);
                String name = fileName.substring(0, fileName.indexOf("."));
                entry.setName(name);
                IRow row = this.getDetailTable().addRow();
                this.loadLineFields(this.getDetailTable(), row, (IObjectValue)entry);
                KDImagePanel imagePanel = null;
                imagePanel = isOld ? this.dealPic(row, file, name) : this.dealPic(row, destFile, name);
                this.storeFileToRow(row, imagePanel);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.handUIException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getSelectImg(IRow row) {
        FaStockTakingInfoEntryInfo entry = (FaStockTakingInfoEntryInfo)row.getUserObject();
        File file = this.loadFile(entry);
        if (file == null) {
            return null;
        }
        FileInputStream is = null;
        try {
            BufferedImage bi;
            is = new FileInputStream(file);
            BufferedImage bufferedImage = bi = ImageIO.read(is);
            return bufferedImage;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFileFromRow(IRow row, KDImagePanel imagePanel) throws IOException {
        FaStockTakingInfoEntryInfo entry = (FaStockTakingInfoEntryInfo)row.getUserObject();
        if (imagePanel.getImage() == null) {
            File file = this.loadFile(entry);
            if (file == null) {
                return;
            }
            try (FileInputStream is = null;){
                BufferedImage bi;
                is = new FileInputStream(file);
                BufferedImage im = bi = ImageIO.read(is);
                imagePanel.setImage((Image)im);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeFileToRow(IRow row, KDImagePanel imagePanel) {
        Image file = imagePanel.getImage();
        try {
            Object b = null;
            Object fis = null;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            BufferedImage bImage = (BufferedImage)file;
            ImageIO.write((RenderedImage)bImage, "jpg", output);
            byte[] buff = output.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(buff);
            FaStockTakingInfoEntryInfo newData = (FaStockTakingInfoEntryInfo)row.getUserObject();
            newData.setFile(buff);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.handUIException(e);
        }
    }

    protected KDImagePanel dealPic(IRow row, File file, String name) {
        FaStockTakingInfoEntryInfo entry = (FaStockTakingInfoEntryInfo)row.getUserObject();
        String key = entry.getId().toString();
        if (file == null) {
            file = this.loadFile(entry);
        }
        if (name == null) {
            name = entry.getName();
        }
        KDScrollPane spImage = this.getScrollPane(key, name);
        KDImagePanel imagePanel = this.getImagePanle(key, spImage, file);
        Dimension size = new Dimension();
        size.setSize(200, 200);
        spImage.setPreferredSize(size);
        imagePanel.setPreferredSize(size);
        return imagePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File loadFile(FaStockTakingInfoEntryInfo entry) {
        File file = null;
        FileOutputStream fos = null;
        byte[] b = entry.getFile();
        if (b != null) {
            try {
                file = File.createTempFile("KDTF-" + entry.getName(), ".jpg");
                fos = new FileOutputStream(file);
                fos.write(b);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.handUIException(e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return file;
    }

    public KDScrollPane getScrollPane(String key, String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KDImagePanel getImagePanle(String key, KDScrollPane spImage, File file) {
        KDImagePanel imagePanle = (KDImagePanel)this.imagePanles.get(key);
        if (imagePanle == null) {
            imagePanle = new KDImagePanel(null);
            if (file != null) {
                FileInputStream is = null;
                try {
                    BufferedImage bi;
                    is = new FileInputStream(file);
                    BufferedImage im = bi = ImageIO.read(is);
                    imagePanle.setImage((Image)im);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            this.imagePanles.put(key, imagePanle);
            spImage.setViewportView((Component)imagePanle);
            spImage.setPreferredSize(imagePanle.getPreferredSize());
            Dimension size = new Dimension();
            size.setSize(200, 200);
            spImage.setPreferredSize(size);
            imagePanle.setSize(size);
        }
        return imagePanle;
    }

    public static String getSelectFile(CoreUIObject ui, boolean isSave, String ext) throws Exception {
        KDFileChooser chooser = new KDFileChooser(new File("."));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(ext, "*." + ext));
        int returnVal = 0;
        if (isSave) {
            chooser.setDialogTitle("\u4fdd\u5b58\u4e3a");
            returnVal = chooser.showSaveDialog((Component)ui);
        } else {
            chooser.setDialogTitle("\u9009\u62e9\u6587\u4ef6");
            returnVal = chooser.showOpenDialog((Component)ui);
        }
        String strFullPath = null;
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            strFullPath = file.getPath();
        }
        if (isSave && strFullPath != null && !strFullPath.endsWith("." + ext)) {
            return strFullPath + "." + ext;
        }
        return strFullPath;
    }

    @Override
    protected void detailTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.getDetailTable().getRowCount() == 0) {
            return;
        }
        int top = this.detailTable.getSelectManager().get().getTop();
        IRow row = this.getDetailTable().getRow(top);
        ICell cell = row.getCell("id");
        if (null == cell) {
            return;
        }
        String idValue = cell.getValue().toString();
        this.showImage(top);
    }

    private void showImage(int curIndex) {
        if (this.currrow == curIndex) {
            return;
        }
        IRow row = this.detailTable.getRow(curIndex);
        FaStockTakingInfoEntryInfo newData = (FaStockTakingInfoEntryInfo)row.getUserObject();
        String key = newData.getId().toString();
        KDImagePanel imagePanel = (KDImagePanel)this.imagePanles.get(key);
        this.showAsOriginaSize(this.getSelectImg(row));
        this.currrow = curIndex;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        FaStockTakingInfoEntryInfo entry = new FaStockTakingInfoEntryInfo();
        entry.setId(BOSUuid.create((BOSObjectType)BOSObjectType.create((String)"0166AC4E")));
        return entry;
    }

    private void showAsOriginaSize(BufferedImage currImage) {
        if (currImage != null) {
            float ff2;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            float ff = 0.0f;
            if (currImage.getWidth() > this.largeImg.getWidth()) {
                ff = Float.parseFloat(String.valueOf(currImage.getHeight())) / Float.parseFloat(String.valueOf(this.largeImg.getHeight()));
            }
            if (currImage.getHeight() > this.largeImg.getHeight() && (ff2 = Float.parseFloat(String.valueOf(currImage.getHeight())) / Float.parseFloat(String.valueOf(this.largeImg.getHeight()))) > ff) {
                ff = ff2;
            }
            BufferedImage image = this.resizeImageSize(currImage, ff);
            int width = image.getWidth();
            int height = image.getHeight();
            if (width + 15 > dimension.width) {
                width = dimension.width - 15;
            }
            if (height + 35 > dimension.height) {
                height = dimension.height - 55;
            }
            ImageIcon imageIcon = new ImageIcon(image);
            this.largeImg.setIcon((Icon)imageIcon);
        }
    }

    private BufferedImage resizeImageSize(BufferedImage im, float resizeTimes) {
        int width = im.getWidth();
        int height = im.getHeight();
        int toWidth = (int)(Float.parseFloat(String.valueOf(width)) / resizeTimes);
        int toHeight = (int)(Float.parseFloat(String.valueOf(height)) / resizeTimes);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (toWidth + 15 > dimension.width) {
            toWidth = dimension.width - 15;
        }
        if (toHeight + 35 > dimension.height) {
            toHeight = dimension.height - 55;
        }
        BufferedImage result = new BufferedImage(toWidth, toHeight, 1);
        result.getGraphics().drawImage(im.getScaledInstance(toWidth, toHeight, 4), 0, 0, null);
        return result;
    }
}

