/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.pda.encoding;

import com.kingdee.eas.barcode.pda.encoding.Cipher;
import com.kingdee.eas.barcode.pda.encoding.Pair;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;

public class Rsa
extends Cipher {
    @Override
    public byte[] encrypt(byte[] data, String publicKey) {
        String[] tmp = publicKey.split(",");
        BigInteger n = new BigInteger(tmp[0]);
        BigInteger e = new BigInteger(tmp[1]);
        BigInteger x = new BigInteger(data);
        if (x.bitLength() > n.bitLength()) {
            throw new IllegalArgumentException("data is too long.");
        }
        return x.modPow(e, n).toByteArray();
    }

    @Override
    public byte[] decrypt(byte[] data, String privateKey) {
        return this.encrypt(data, privateKey);
    }

    public static Pair<String, String> generateKey(int bitCount) {
        KeyPair kp = Rsa.getKeyGenerator(bitCount);
        RSAPublicKey puk = (RSAPublicKey)kp.getPublic();
        RSAPrivateCrtKey prk = (RSAPrivateCrtKey)kp.getPrivate();
        BigInteger e = puk.getPublicExponent();
        BigInteger n = puk.getModulus();
        BigInteger d = prk.getPrivateExponent();
        String pe = n + "," + d;
        String pd = n + "," + e;
        return new Pair<String, String>(pe, pd);
    }

    public static KeyPair getKeyGenerator(int bitCount) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        kpg.initialize(bitCount);
        KeyPair kp = kpg.generateKeyPair();
        return kp;
    }
}

