/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.rpt.MaterialTraceReportFacadeFactory;
import com.kingdee.eas.barcode.rpt.client.AbstractMataerialTraceReportUI;
import com.kingdee.eas.barcode.rpt.client.MaterialTraceReportConditionUI;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class MataerialTraceReportUI
extends AbstractMataerialTraceReportUI {
    private static final Logger logger = CoreUIObject.getLogger(MataerialTraceReportUI.class);
    private RptParams pp = new RptParams();

    public MataerialTraceReportUI() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.kDTable1.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.kDTable1);
        this.kDTable1.setEnabled(true);
        this.kDTable1.getStyleAttributes().setLocked(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.getStyleAttributes().setLocked(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return MaterialTraceReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return null;
    }

    protected void query() {
        this.kDTable1.removeColumns();
        this.kDTable1.removeRows();
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd");
        Calendar tempBGCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        String bg = this.params.getString("dateStart");
        String ed = this.params.getString("dateEnd");
        String dateStart = "";
        String dateEnd = "";
        if (bg != null && !bg.trim().equals("")) {
            String[] bgs = bg.split("-");
            tempBGCalendar.set(new Integer(bgs[0]), new Integer(bgs[1]) - 1, new Integer(bgs[2]));
            Date beginDate = tempBGCalendar.getTime();
            dateStart = format.format(beginDate).toString();
        }
        if (ed != null && !ed.trim().equals("")) {
            String[] eds = ed.split("-");
            tempEDCalendar.set(new Integer(eds[0]), new Integer(eds[1]) - 1, new Integer(eds[2]));
            Date endDate = tempEDCalendar.getTime();
            dateEnd = format.format(endDate).toString();
        }
        this.outDate.setText(dateStart + "-" + dateEnd);
        this.barcode.setText(this.params.getString("barcode"));
        this.initUserConfig();
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            MaterialTraceReportConditionUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                QuerySolutionInfo solution;
                QueryPanelInfo qpi;
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                String a = super.getClass().getName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName) && (qpi = (solution = iQuery.getDefaultSolution(super.getClass().getName(), queryName)).getQueryPanelInfo().get(0)) != null) {
                    try {
                        cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (MaterialTraceReportConditionUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (MaterialTraceReportConditionUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
                this.params.putAll((Map)cp.getCustomerParamsHashMap());
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setMaxReturnCountVisible(false);
            this.queryDialog.setWidth(450);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(super.getClass().getName());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new MaterialTraceReportConditionUI();
    }

    public void getData(KDTDataRequestEvent e) {
        this.kDTable1.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        this.pp.clear();
        this.pp.putAll(this.params.toMap());
        this.kDTable1.getMergeManager().setMergeMode(0);
        try {
            int freezeCol1;
            RptParams rpt = this.getRemoteInstance().query(this.pp, from, len);
            if (from == 0) {
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.kDTable1);
            }
            if ((freezeCol1 = this.kDTable1.getColumnIndex("FINTERID")) != -1) {
                this.kDTable1.getColumn(freezeCol1).getStyleAttributes().setHided(true);
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            this.insertRows(rs, from, this.kDTable1, true, new DefaultKDTableInsertHandler(rs), 0);
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            this.handUIExceptionAndAbort(ee);
            this.abort();
        }
        this.kDTable1.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    private void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, DefaultKDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        while (rs.next()) {
            IRow row = table.addRow(rowIndex++);
            handler.setTableRowData(row, rs.toRowArray());
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }
}

