/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.rpt.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.rpt.client.AbstractMaterialTraceReportConditionUI;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class MaterialTraceReportConditionUI
extends AbstractMaterialTraceReportConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialTraceReportConditionUI.class);
    private RptParams params = new RptParams();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void loadConditions() {
        CustomerParams cp = this.getCustomerParams();
        if (cp != null) {
            String barcode = cp.getCustomerParam("barcode");
            String materia = cp.getCustomerParam("materia");
            String custom = cp.getCustomerParam("custom");
            String dateStart = cp.getCustomerParam("dateStart");
            String dateEnd = cp.getCustomerParam("dateEnd");
            this.barcode.setText(barcode);
            this.dateStart.setValue((Object)dateStart);
            this.dateEnd.setValue((Object)dateEnd);
        }
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = super.getFilterInfo();
        this.filterInfo = new FilterInfo();
        return this.filterInfo;
    }

    public RptParams getCustomCondition() {
        this.params.clear();
        this.params.setString("barcode", this.barcode.getText());
        MaterialInfo m1 = (MaterialInfo)this.prmrawmaterial.getValue();
        MaterialInfo m2 = (MaterialInfo)this.prmproducts.getValue();
        if (m1 != null) {
            this.params.setString("rawmaterianumber", m1.get("number").toString());
            this.params.setString("rawmateria", m1.get("name").toString());
        }
        if (m2 != null) {
            this.params.setString("productnumber", m2.get("number").toString());
            this.params.setString("product", m1.get("name").toString());
        }
        this.params.setString("dateStart", this.dateStart.getText());
        this.params.setString("dateEnd", this.dateEnd.getText());
        return this.params;
    }

    public void setCustomCondition(RptParams params) {
        params.clear();
        this.params = params;
    }

    public boolean verify() {
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.dateStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.dateEnd.getValue()));
        if (dateFrom != null && dateTo != null && ((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.rpt.BCReportResource", (String)"END_LATE_FROM"));
            this.dateEnd.requestFocus();
            return false;
        }
        return true;
    }
}

