/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.rpt.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.rpt.client.AbstractProQualityTraceReportConditionUI;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class ProQualityTraceReportConditionUI
extends AbstractProQualityTraceReportConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(ProQualityTraceReportConditionUI.class);
    private RptParams params = new RptParams();

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadConditions();
        this.loadf7Field();
    }

    private void loadf7Field() {
        this.prmCustom.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.CustomerInfoQuery");
        this.prmMateria.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialQuery");
    }

    private void loadConditions() {
        CustomerParams cp = this.getCustomerParams();
        if (cp != null) {
            String barcode = cp.getCustomerParam("barcode");
            String materia = cp.getCustomerParam("materia");
            String custom = cp.getCustomerParam("custom");
            String dateStart = cp.getCustomerParam("dateStart");
            String dateEnd = cp.getCustomerParam("dateEnd");
            String inStartDate = cp.getCustomerParam("inStartDate");
            String inEndDate = cp.getCustomerParam("inEndDate");
            String saleNumber = cp.getCustomerParam("saleNumber");
            this.barCode.setText(barcode);
            this.prmCustom.setText(custom);
            this.prmMateria.setText(materia);
            this.dateStart.setValue((Object)dateStart);
            this.dateEnd.setValue((Object)dateEnd);
            this.inStartDate.setValue((Object)inStartDate);
            this.inEndDate.setValue((Object)inEndDate);
            this.txtSaleNumber.setText(saleNumber);
            this.prmtadminOrgUnit.setValue((Object)cp.getCustomerParam("adminOrgUnitInfo"));
        }
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = super.getFilterInfo();
        this.filterInfo = new FilterInfo();
        return this.filterInfo;
    }

    public RptParams getCustomCondition() {
        AdminOrgUnitInfo adOrgId;
        CustomerInfo ci;
        this.params.clear();
        this.params.setString("barcode", this.barCode.getText());
        this.params.setString("barcode", this.barCode.getText());
        this.params.setString("materia", this.prmMateria.getText());
        MaterialInfo m = (MaterialInfo)this.prmMateria.getData();
        if (m != null) {
            this.params.setString("materianumber", m.get("number").toString());
        }
        if ((ci = (CustomerInfo)this.prmCustom.getData()) != null) {
            this.params.setString("custom", ci.get("id").toString());
        }
        if ((adOrgId = (AdminOrgUnitInfo)this.prmtadminOrgUnit.getData()) != null) {
            this.params.setString("adminOrgUnitInfo", adOrgId.get("id").toString());
        }
        this.params.setString("customname", this.prmCustom.getText());
        this.params.setString("dateStart", this.dateStart.getText());
        this.params.setString("dateEnd", this.dateEnd.getText());
        this.params.setString("inStartDate", this.inStartDate.getText());
        this.params.setString("inEndDate", this.inEndDate.getText());
        this.params.setString("saleNumber", this.txtSaleNumber.getText());
        return this.params;
    }

    public void setCustomCondition(RptParams params) {
        params.clear();
        this.params = params;
    }

    public boolean verify() {
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.dateStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.dateEnd.getValue()));
        if (dateFrom != null && dateTo != null && ((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.rpt.BCReportResource", (String)"END_LATE_FROM"));
            this.dateEnd.requestFocus();
            return false;
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.loadConditions();
    }
}

