/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.client.BarCodeClientPrint;
import com.kingdee.eas.barcode.scm.client.BarCodePrintParam;
import com.kingdee.eas.barcode.scm.client.BarcodeBarTenderPrinter;
import com.kingdee.eas.barcode.scm.client.BarcodePrintHelper;
import com.kingdee.eas.barcode.scm.client.BarcodePrintUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BarCodeBDPrint
implements BarCodeClientPrint {
    private static final Logger logger = CoreUIObject.getLogger(BarCodeBDPrint.class);

    @Override
    public Map doPrint(BarCodePrintParam param) {
        logger.info((Object)("\u51c6\u5907\u6253\u5370\uff1a\u4ece" + param.getTable().getName() + " ,\u6761\u7801\u6570 \uff1a" + param.getPrintBarcodes().size() + "  \u4efd\u6570\uff1a " + param.getCount() + "  \u4f7f\u7528\u6a21\u677f \uff1a" + param.getTemplateFileName()));
        try {
            BarCodeBDPrint.printBarcodes(param.getUi(), param.getTemplateFileName(), param.getCount(), param.getPrintBarcodes());
            String barcode = null;
            IRow row = null;
            HashMap<String, String> barcodeMap = new HashMap<String, String>();
            for (Map<String, String> map : param.getPrintBarcodes()) {
                barcode = map.get("Barcode");
                row = this.getRowByBarcode(param.getTable(), barcode);
                row.getCell("isPrint").setValue((Object)true);
                if (param.getUi() instanceof BarcodePrintUI) {
                    row.getCell("select").setValue((Object)false);
                    row.getCell("select").getStyleAttributes().setLocked(true);
                    barcodeMap.put(row.getCell("barcode").getValue().toString(), "0");
                    continue;
                }
                barcodeMap.put(row.getCell("number").getValue().toString(), "0");
            }
            logger.info((Object)("\u5f00\u59cb\u66f4\u65b0\u662f\u5426\u6253\u5370\u5b57\u6bb5\uff1a" + barcodeMap));
            BarcodeDossierFactory.getRemoteInstance().updateBatchPrinted(barcodeMap);
            logger.info((Object)("\u7ed3\u675f\u66f4\u65b0\u662f\u5426\u6253\u5370\u5b57\u6bb5\uff1a" + barcodeMap));
            if (param.getUi() instanceof BarcodePrintUI) {
                param.getTable().reLayoutAndPaint();
            } else {
                ((ListUI)param.getUi()).refreshList();
            }
        }
        catch (Exception e) {
            logger.error((Object)("print barcode has exception, " + e.getMessage()));
        }
        return null;
    }

    private IRow getRowByBarcode(KDTable table, String key) {
        String barcode = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            barcode = (String)table.getCell(i, "barcode").getValue();
            if (!key.equals(barcode)) continue;
            return table.getRow(i);
        }
        return null;
    }

    public static void printBarcodes(CoreUI ui, final String templateFileName, int count, final List<Map<String, String>> printBarcodes) throws IOException {
        BarcodePrintHelper.showUIMsg(ui, "\u51c6\u5907\u6253\u5370");
        boolean fWorks = true;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BarcodeBarTenderPrinter printer = null;
                boolean isFormFeed = false;
                Shell shell = new Shell(Display.getDefault());
                if (printer == null) {
                    printer = new BarcodeBarTenderPrinter((Composite)shell);
                    printer.setTemplateFileName(templateFileName);
                    printer.setPrintBarcodes(printBarcodes);
                }
                printer.print(printBarcodes, isFormFeed);
                printer.distory();
            }
        });
        Display.getDefault().dispose();
        String msg = fWorks ? "\u6253\u5370\u5b8c\u6210" : "\u6253\u5370\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8bbe\u7f6e\u53ca\u5ba2\u6237\u7aef\u65e5\u5fd7";
        BarcodePrintHelper.showUIMsg(ui, msg);
    }
}

