/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.client.BarCodeClientPrint;
import com.kingdee.eas.barcode.scm.client.BarCodePrintParam;
import com.kingdee.eas.barcode.scm.client.BarcodePrintHelper;
import com.kingdee.eas.barcode.scm.client.BarcodePrintUI;
import com.kingdee.eas.barcode.scm.client.BarcodePrinter;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BarCodeCSPrint
implements BarCodeClientPrint {
    private static final Logger logger = CoreUIObject.getLogger(BarCodeCSPrint.class);
    private Map<String, String> afterPrintResult;

    @Override
    public Map doPrint(final BarCodePrintParam param) {
        logger.info((Object)("\u51c6\u5907\u6253\u5370\uff1a\u4ece" + param.getTable().getName() + " ,\u6761\u7801\u6570 \uff1a" + param.getPrintBarcodes().size() + "  \u4efd\u6570\uff1a " + param.getCount() + "  \u4f7f\u7528\u6a21\u677f \uff1a" + param.getTemplateFileName()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BarCodeCSPrint.this.printBarcodes(param.getUi(), param.getTemplateFileName(), param.getCount(), param.getPrintBarcodes());
                    Map resultMap = BarCodeCSPrint.this.getAfterPrintResult();
                    HashMap<String, String> barcodeMap = new HashMap<String, String>();
                    for (String key : resultMap.keySet()) {
                        String value = (String)resultMap.get(key);
                        if (!"0".equals(value)) continue;
                        IRow row = param.getTable().getRow(Integer.valueOf(key).intValue());
                        row.getCell("isPrint").setValue((Object)true);
                        if (param.getUi() instanceof BarcodePrintUI) {
                            row.getCell("select").setValue((Object)false);
                            row.getCell("select").getStyleAttributes().setLocked(true);
                            barcodeMap.put(row.getCell("barcode").getValue().toString(), value);
                            continue;
                        }
                        barcodeMap.put(row.getCell("number").getValue().toString(), value);
                    }
                    logger.info((Object)("\u5f00\u59cb\u66f4\u65b0\u662f\u5426\u6253\u5370\u5b57\u6bb5\uff1a" + barcodeMap));
                    BarcodeDossierFactory.getRemoteInstance().updateBatchPrinted(barcodeMap);
                    logger.info((Object)("\u7ed3\u675f\u66f4\u65b0\u662f\u5426\u6253\u5370\u5b57\u6bb5\uff1a" + barcodeMap));
                    if (param.getUi() instanceof BarcodePrintUI) {
                        param.getTable().reLayoutAndPaint();
                    } else {
                        ((ListUI)param.getUi()).refreshList();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("print barcode has exception, " + e.getMessage()));
                }
            }
        }).start();
        return null;
    }

    private void printBarcodes(CoreUI ui, String templateFileName, int count, List<Map<String, String>> printBarcodes) throws IOException {
        BarcodePrintHelper.showUIMsg(ui, "\u51c6\u5907\u6253\u5370");
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        Runtime runtime = Runtime.getRuntime();
        String cmdKill = "taskkill /f /im lppa.exe";
        boolean fWorks = true;
        BarcodePrinter printer = null;
        int perCount = 1;
        boolean isFormFeed = false;
        this.afterPrintResult = new HashMap<String, String>();
        int barcodeCount = 0;
        int m = printBarcodes.size();
        for (int j = 0; j < m; ++j) {
            int n = count;
            for (int i = 0; i < n; ++i) {
                String barcodeKey;
                ++barcodeCount;
                Map<String, String> dataMap = printBarcodes.get(j);
                BarcodePrintHelper.showUIMsg(ui, "\u6b63\u5728\u6253\u5370\u3002\u3002\u3002");
                if (printer == null) {
                    printer = new BarcodePrinter((Composite)shell);
                    printer.setTemplateFileName(templateFileName);
                    perCount = printer.getPerCount();
                }
                if (barcodeCount % perCount == 0) {
                    barcodeCount = 0;
                    isFormFeed = true;
                } else if (j == printBarcodes.size() - 1 && i == n - 1) {
                    if (barcodeCount < perCount) {
                        isFormFeed = true;
                    }
                } else {
                    isFormFeed = false;
                }
                int iReturn = printer.print(dataMap, isFormFeed);
                if (isFormFeed) {
                    printer = null;
                }
                if (dataMap.containsKey(barcodeKey = dataMap.get("Barcode"))) {
                    String value = dataMap.get(barcodeKey);
                    this.afterPrintResult.put(value, iReturn + "");
                }
                fWorks = fWorks && iReturn == 0;
            }
        }
        shell.dispose();
        display.dispose();
        runtime.exec(cmdKill);
        String msg = fWorks ? "\u6253\u5370\u5b8c\u6210" : "\u6253\u5370\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8bbe\u7f6e\u53ca\u5ba2\u6237\u7aef\u65e5\u5fd7";
        BarcodePrintHelper.showUIMsg(ui, msg);
    }

    private Map<String, String> getAfterPrintResult() {
        return this.afterPrintResult;
    }
}

