/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.barcode.scm.Barcode3GEngineFacadeFactory;
import com.kingdee.eas.barcode.scm.IBarcode3GEngineFacade;
import com.kingdee.eas.barcode.scm.client.SchedThreadBase;
import com.kingdee.eas.common.EASBizException;
import java.util.List;

public class BarCodeMatchThread
extends SchedThreadBase {
    private List configList = null;
    private List configValueList = null;
    private String currMatchCode = "";
    private boolean matchStatus = false;
    private long matchIinternal = 100L;
    private IBarcode3GEngineFacade iBarCode3GE;

    protected void setMatchCode(String value) {
        this.currMatchCode = value;
    }

    @Override
    protected boolean getStatus() {
        return super.getStatus();
    }

    protected boolean getMatchStatus() {
        return this.matchStatus;
    }

    @Override
    protected void executeWork() {
        try {
            this.configList = null;
            this.iBarCode3GE = Barcode3GEngineFacadeFactory.getRemoteInstance();
            this.configList = this.iBarCode3GE.Get3gConfigItem(this.currMatchCode, this.configValueList);
            if (this.configList != null && this.configList.size() > 0) {
                this.matchStatus = true;
                this.stop();
            }
            System.out.println("Execute work ...match");
        }
        catch (InterruptedException e) {
            this.matchStatus = false;
        }
        catch (EASBizException e) {
            this.matchStatus = false;
        }
        catch (BOSException e) {
            this.matchStatus = false;
        }
    }

    @Override
    protected long getNextTime() {
        return System.currentTimeMillis() + 100L;
    }

    public void main(String[] argv) {
        this.matchStatus = false;
        BarCodeMatchThread generator = new BarCodeMatchThread();
        generator.setInternal(this.matchIinternal);
        generator.start();
    }
}

