/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.barcode.scm.Barcode3GEngineFacadeFactory;
import com.kingdee.eas.barcode.scm.IBarcode3GEngineFacade;
import com.kingdee.eas.barcode.scm.client.SchedThreadBase;
import com.kingdee.eas.common.EASBizException;
import java.util.List;

public class BarCodeScannerThread
extends SchedThreadBase {
    public static int i = 0;
    private List configValueList = null;
    private String currMatchCode = "";
    private String barcodeValue = "";
    private boolean readStatus = true;
    private IBarcode3GEngineFacade iBarCode3GE;

    protected void setMatchCode(String value) {
        this.currMatchCode = value;
    }

    protected boolean getReadStatus() {
        return this.readStatus;
    }

    protected void setReadStatus(boolean value) {
        this.readStatus = value;
    }

    protected String getBarcodeValue() {
        return this.barcodeValue;
    }

    protected void setBarcodeValue(String value) {
        this.barcodeValue = value;
    }

    @Override
    protected void executeWork() {
        try {
            if (!this.readStatus) {
                this.iBarCode3GE = Barcode3GEngineFacadeFactory.getRemoteInstance();
                this.configValueList = this.iBarCode3GE.Get3gConfigItemValue(this.currMatchCode);
                if (this.configValueList != null && this.configValueList.size() > 0) {
                    this.barcodeValue = this.configValueList.get(0).toString();
                    this.readStatus = true;
                }
                System.out.println("Execute work ...scan");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected long getNextTime() {
        return System.currentTimeMillis() + 100L;
    }

    public static void main(String[] argv) {
        BarCodeScannerThread generator = new BarCodeScannerThread();
        generator.start();
    }
}

