/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.ILiceControl;
import com.kingdee.eas.barcode.scm.LiceControlFactory;
import com.kingdee.eas.barcode.scm.client.AbstractBarLiceApplyUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BarLiceApplyUI
extends AbstractBarLiceApplyUI {
    private static final Logger logger = CoreUIObject.getLogger(BarLiceApplyUI.class);
    private File licenseFile = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws EASBizException {
        try {
            this.txt_machine.setText(this.getBizInterface().getMachineCode());
        }
        catch (BOSException e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        this.txt_users.setValue((Object)5);
        Calendar c = Calendar.getInstance();
        c.add(2, 1);
        this.pk_expdate.setValue((Object)c.getTime());
        this.txt_geninfo.setEditable(false);
    }

    protected void initListener() {
        super.initListener();
    }

    @Override
    protected void actionChoose_actionPerformed(ActionEvent e) throws Exception {
        super.actionChoose_actionPerformed(e);
        this.initSaveDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionStartExport_actionPerformed(ActionEvent e) throws Exception {
        String licenseInfo = this.txt_geninfo.getText();
        if (StringUtils.isEmpty((String)licenseInfo)) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u751f\u6210\u7533\u8bf7\u4fe1\u606f");
            return;
        }
        super.actionStartExport_actionPerformed(e);
        String path = this.textPath.getText();
        File file = new File(path);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            writer.write(this.txt_geninfo.getText());
            MsgBox.showInfo((String)"\u7533\u8bf7\u6587\u4ef6\u5df2\u751f\u6210,\u8bf7\u51ed\u7533\u8bf7\u6587\u4ef6\u83b7\u53d6\u8bbe\u5907\u6388\u6743\u8bb8\u53ef");
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initSaveDialog() throws Exception {
        KDFileChooser fileChooser = this.initKDFileChooser();
        this.licenseFile = this.initFile(fileChooser, ".txt");
    }

    private KDFileChooser initKDFileChooser() throws Exception {
        String title = "\u9009\u62e9\u7533\u8bf7\u6587\u4ef6\u5b58\u653e\u8def\u5f84";
        String FileName = this.bulidFileName(true);
        KDFileChooser fileChooser = this.getKDFileChooser(title, null, FileName, ".txt");
        return fileChooser;
    }

    private String bulidFileName(boolean isShowTime) {
        StringBuffer name = new StringBuffer();
        name.append("license_apply.txt");
        return name.toString();
    }

    private File initFile(KDFileChooser fileChooser, String suffix) throws Exception {
        if (fileChooser != null) {
            int result = fileChooser.showSaveDialog(null);
            File file = fileChooser.getSelectedFile();
            if (result != 0) {
                return null;
            }
            if (!file.getAbsolutePath().endsWith(suffix)) {
                file = new File(file.getAbsolutePath() + suffix);
            }
            if (file.exists()) {
                int select = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"56_ExportExcelConfigUI"));
                if (select == 2) {
                    return null;
                }
                if (select == 0 && !file.renameTo(file)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"57_ExportExcelConfigUI"));
                    return null;
                }
            }
            this.textPath.setText(file.getAbsolutePath());
            return file;
        }
        return null;
    }

    private KDFileChooser getKDFileChooser(String title, String path, String fileName, String suffix) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(path, fileName));
        fileChooser.setFileFilter(this.bulidFilter(suffix));
        return fileChooser;
    }

    private FileFilter bulidFilter(String suffix) throws Exception {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null) {
                    return extension.equalsIgnoreCase(this.getFilterSuffix());
                }
                return false;
            }

            private String getExtension(File f) {
                String ext = null;
                String fileName = f.getName();
                int i = fileName.lastIndexOf(".");
                if (i > 0 && i < fileName.length() - 1) {
                    ext = fileName.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            @Override
            public String getDescription() {
                return "(*." + this.getFilterSuffix() + ")";
            }

            private String getFilterSuffix() {
                return "txt";
            }
        };
        return fileFilter;
    }

    protected ILiceControl getBizInterface() throws BOSException {
        return LiceControlFactory.getRemoteInstance();
    }

    @Override
    protected void btn_apply_actionPerformed(ActionEvent e) throws Exception {
        String machineCode = this.txt_machine.getText();
        if (machineCode == null) {
            MsgBox.showInfo((String)"\u83b7\u53d6\u673a\u5668\u7279\u5f81\u7801\u5931\u8d25,\u65e0\u6cd5\u751f\u6210\u7533\u8bf7\u4fe1\u606f");
            return;
        }
        Number u = this.txt_users.getNumberValue();
        if (u == null) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u7533\u8bf7\u6570\u91cf");
            return;
        }
        Date expdate = (Date)this.pk_expdate.getValue();
        if (expdate == null) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u6709\u6548\u671f");
            return;
        }
        int users = u.intValue();
        String genInfo = this.getBizInterface().genApplyInfo(users, expdate);
        this.txt_geninfo.setText(genInfo);
    }
}

