/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.ILiceControl;
import com.kingdee.eas.barcode.scm.LiceControlFactory;
import com.kingdee.eas.barcode.scm.client.AbstractBarLiceImportUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BarLiceImportUI
extends AbstractBarLiceImportUI {
    private static final Logger logger = CoreUIObject.getLogger(BarLiceImportUI.class);
    private File licenseFile = null;
    private boolean isImport = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.isImport = false;
    }

    protected void initListener() {
        super.initListener();
    }

    private void initUI() throws EASBizException {
        try {
            this.txt_users.setEnabled(false);
            this.pk_expdate.setEnabled(false);
            this.txt_users.setVisible(false);
            this.pk_expdate.setVisible(false);
            this.txt_machine.setText(this.getBizInterface().getMachineCode());
        }
        catch (BOSException e) {
            e.printStackTrace();
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ILiceControl getBizInterface() throws BOSException {
        return LiceControlFactory.getRemoteInstance();
    }

    public boolean isImportLicenseSucc() {
        return this.isImport;
    }

    @Override
    protected void actionChoose_actionPerformed(ActionEvent e) throws Exception {
        super.actionChoose_actionPerformed(e);
        this.initSaveDialog();
    }

    private void initSaveDialog() throws Exception {
        KDFileChooser fileChooser = this.initKDFileChooser();
        this.licenseFile = this.initFile(fileChooser, ".txt");
    }

    private KDFileChooser initKDFileChooser() throws Exception {
        String title = "\u9009\u62e9\u6388\u6743\u6587\u4ef6\u5b58\u653e\u8def\u5f84";
        String FileName = this.bulidFileName(true);
        KDFileChooser fileChooser = this.getKDFileChooser(title, null, FileName, ".txt");
        return fileChooser;
    }

    private String bulidFileName(boolean isShowTime) {
        return "license.txt";
    }

    private File initFile(KDFileChooser fileChooser, String suffix) throws Exception {
        if (fileChooser != null) {
            int result = fileChooser.showSaveDialog(null);
            File file = fileChooser.getSelectedFile();
            if (result != 0) {
                return null;
            }
            if (!file.getAbsolutePath().endsWith(suffix)) {
                file = new File(file.getAbsolutePath() + suffix);
            }
            this.textPath.setText(file.getAbsolutePath());
            return file;
        }
        return null;
    }

    private KDFileChooser getKDFileChooser(String title, String path, String fileName, String suffix) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(path, fileName));
        fileChooser.setFileFilter(this.bulidFilter(suffix));
        return fileChooser;
    }

    private FileFilter bulidFilter(String suffix) throws Exception {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null) {
                    return extension.equalsIgnoreCase(this.getFilterSuffix());
                }
                return false;
            }

            private String getExtension(File f) {
                String ext = null;
                String fileName = f.getName();
                int i = fileName.lastIndexOf(".");
                if (i > 0 && i < fileName.length() - 1) {
                    ext = fileName.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            @Override
            public String getDescription() {
                return "(*." + this.getFilterSuffix() + ")";
            }

            private String getFilterSuffix() {
                return "txt";
            }
        };
        return fileFilter;
    }

    @Override
    protected void btn_apply_actionPerformed(ActionEvent e) throws Exception {
        String path = this.textPath.getText();
        if (StringUtils.isEmpty((String)path)) {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u6388\u6743\u6587\u4ef6");
            return;
        }
        String importInfo = BarLiceImportUI.read(path);
        if (importInfo == null || importInfo.trim().length() == 0) {
            MsgBox.showInfo((String)"\u7533\u8bf7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        Map revMap = this.getBizInterface().importBarLicenseInfo(importInfo);
        if (revMap == null) {
            MsgBox.showInfo((String)"\u5bfc\u5165\u6388\u6743\u6587\u4ef6\u5f02\u5e38,\u672a\u77e5\u9519\u8bef");
            return;
        }
        int status = (Integer)revMap.get("status");
        if (status == -1) {
            MsgBox.showInfo((String)"\u975e\u6cd5\u6388\u6743\u4fe1\u606f");
            return;
        }
        if (status == -2) {
            MsgBox.showInfo((String)"\u6388\u6743\u4fe1\u606f\u4e0e\u5f53\u524d\u7279\u5f81\u7801\u4e0d\u5339\u914d");
            return;
        }
        if (status == -3) {
            MsgBox.showInfo((String)"\u5b58\u50a8\u6388\u6743\u4fe1\u606f\u5931\u8d25");
            return;
        }
        if (status == 1) {
            this.isImport = true;
            MsgBox.showInfo((String)"\u5bfc\u5165\u6210\u529f");
            this.disposeUIWindow();
        }
    }

    public static String read(String file) {
        return BarLiceImportUI.read(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(String file, String charset) {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = BarLiceImportUI.read(is, charset);
            return string;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        return null;
    }

    public static String read(InputStream is, String charset) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(is, charset);
        StringBuilder sb = new StringBuilder();
        int c = reader.read();
        while (c >= 0) {
            sb.append((char)c);
            c = reader.read();
        }
        return sb.toString();
    }
}

