/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BarTenderFileHelper {
    public static String createTempFile2SysDefDir(List<Map<String, String>> dataMapList) throws Exception {
        String path = BarTenderFileHelper.getSysDefDir();
        String fileName = path + "" + UUID.randomUUID().toString();
        File file = new File(fileName);
        BarTenderFileHelper.createFile(file);
        BarTenderFileHelper.writeTxtFile(dataMapList, file);
        return fileName;
    }

    private static String getSysDefDir() {
        return System.getProperty("java.io.tmpdir");
    }

    private static void createFile(File fileName) throws Exception {
        boolean flag = false;
        try {
            if (!fileName.exists()) {
                fileName.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeTxtFile(List<Map<String, String>> dataMapList, File file) throws Exception {
        boolean flag = false;
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(file, true);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            Iterator<String> keyit = null;
            String val = null;
            int size = 0;
            for (Map<String, String> map : dataMapList) {
                keyit = map.keySet().iterator();
                size = map.size();
                int index = 0;
                while (keyit.hasNext()) {
                    val = map.get(keyit.next());
                    val = val.replaceAll("\t", "    ");
                    val = val.replaceAll("(\r\n|\n)", "  ");
                    bw.write(val);
                    if (size == ++index) continue;
                    bw.write("\t");
                }
                bw.write("\n");
            }
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendMethodB(File file, String content) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

