/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeObject;
import com.kingdee.bos.ctrl.swing.KDImageIcon;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.Barcode3GEngineFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeGenerateFacodeFactory;
import com.kingdee.eas.barcode.scm.IBarcode3GEngineFacade;
import com.kingdee.eas.barcode.scm.IBarcodeGenerateFacode;
import com.kingdee.eas.barcode.scm.client.AbstractBarcode3GUI;
import com.kingdee.eas.barcode.scm.client.BarCodeMatchThread;
import com.kingdee.eas.barcode.scm.client.BarCodeScannerThread;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class Barcode3GUI
extends AbstractBarcode3GUI {
    private static final Logger logger = CoreUIObject.getLogger(Barcode3GUI.class);
    public static final String allChar = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String letterChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String numberChar = "0123456789";
    private Timer timerMatch3g;
    private Timer timerCollect3g;
    private List configList = null;
    private List configValueList = null;
    private BarcodeObject barcodeObject;
    private IBarcode3GEngineFacade iBarCode3GE;
    private BarCodeMatchThread myMatchTd;
    private BarCodeScannerThread myScannTd;
    long interval = 100L;
    long period = 200L;
    String currMatchCode = "";

    public Barcode3GUI() throws Exception {
        this.initUI();
    }

    private void initUI() {
        this.setUITitle("3G\u8bbe\u5907\u914d\u5bf9\u5ba2\u6237\u7aef");
        this.lblStatus.setText("\u8bf7\u751f\u6210\u5339\u914d\u7801\uff0c\u4e0e\u8bbe\u5907\u8fdb\u884c\u5339\u914d");
        this.txtMatchCode.setEnabled(false);
    }

    private void cancelTime() {
        if (this.timerCollect3g != null) {
            this.timerCollect3g.cancel();
        }
        if (this.timerMatch3g != null) {
            this.timerMatch3g.cancel();
        }
    }

    private void cancelThread() {
        try {
            if (this.myMatchTd != null && this.myMatchTd.getStatus()) {
                this.myMatchTd.stop();
            }
            if (this.myScannTd != null && this.myScannTd.getStatus()) {
                this.myScannTd.stop();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean destroyWindow() {
        this.cancelTime();
        this.cancelThread();
        return super.destroyWindow();
    }

    @Override
    protected void buttonGenerate_actionPerformed(ActionEvent e) throws Exception {
        List list = null;
        this.currMatchCode = "";
        this.cancelTime();
        this.txtMatchCode.setText(this.generateAccessTokenCode());
        this.currMatchCode = this.txtMatchCode.getText().toString();
        this.lblStatus.setText("\u6b63\u5728\u7b49\u5f85\u8bbe\u5907\u5339\u914d\uff0c\u8bf7\u7a0d\u4faf...");
        this.iBarCode3GE = Barcode3GEngineFacadeFactory.getRemoteInstance();
        if (this.iBarCode3GE.Set3gConfigItem(this.currMatchCode, list)) {
            byte[] barCodeImgByte = this.generateBarcode(this.currMatchCode);
            this.clearPaintImage();
            this.paintImage(barCodeImgByte);
            this.cancelTime();
            this.cancelThread();
            this.timerMatch3g = new Timer();
            this.timerMatch3g.scheduleAtFixedRate((TimerTask)new timerMatchTask3G(), this.interval, this.period);
            this.myMatchTd = null;
            this.myMatchTd = new BarCodeMatchThread();
            this.myMatchTd.setMatchCode(this.currMatchCode);
            this.myMatchTd.start();
        }
    }

    private void initBarcodeImgInfo() {
        this.barcodeObject = new BarcodeObject();
        this.barcodeObject.setBarcodeType("qr");
        this.barcodeObject.setDpi(600);
        this.barcodeObject.setBarHeight(0.48);
        this.barcodeObject.setModelWidth(0.48);
    }

    private void paintImage(byte[] barCodeImgbyte) throws BOSException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(barCodeImgbyte);
            BufferedImage image = ImageIO.read(bais);
            KDImageIcon icon = new KDImageIcon((Image)image);
            this.lblShowPic.setIcon((Icon)icon);
            bais.close();
        }
        catch (IOException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void clearPaintImage() {
        this.lblShowPic.setIcon(null);
    }

    public byte[] generateBarcode(String code) throws BOSException {
        byte[] barcodeImg = null;
        IBarcodeGenerateFacode iBarcodeGenerate = BarcodeGenerateFacodeFactory.getRemoteInstance();
        try {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("dpi", 600);
            config.put("modelWidth", 0.0);
            config.put("barHeight", 0.0);
            config.put("height", 48);
            config.put("width", 48);
            config.put("autoMatch", "true");
            barcodeImg = iBarcodeGenerate.generateBarcodePicture(code, "qr", config);
        }
        catch (EASBizException e1) {
            throw new BOSException("[" + code + "]\u751f\u6210\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7801\u5236\u4e0d\u652f\u6301\u5bfc\u81f4\uff01" + e1.getMessage());
        }
        return barcodeImg;
    }

    public void initVertifyCode() {
        this.txtMatchCode.setText(this.generateUpperString(6));
    }

    public String generateAccessTokenCode() {
        String singStr = "#";
        String uuidStr = BOSUuid.create((String)"E5B2B4BF").toString();
        String cuidStr = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String useridStr = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return uuidStr + singStr + cuidStr + singStr + useridStr;
    }

    public String generateMixString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(allChar.charAt(random.nextInt(letterChar.length())));
        }
        return sb.toString();
    }

    public String generateNumberString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(numberChar.charAt(random.nextInt(numberChar.length())));
        }
        return sb.toString();
    }

    public String generateUpperString(int length) {
        return this.generateMixString(length).toUpperCase();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public class timerCollect3G
    extends TimerTask {
        @Override
        public void run() {
            if (Barcode3GUI.this.myScannTd != null && Barcode3GUI.this.myScannTd.getReadStatus()) {
                Barcode3GUI.this.txtBarCode.setText(Barcode3GUI.this.myScannTd.getBarcodeValue());
                Barcode3GUI.this.myScannTd.setReadStatus(false);
                Barcode3GUI.this.txtBarCode.selectAll();
            }
        }
    }

    public class timerMatchTask3G
    extends TimerTask {
        @Override
        public void run() {
            Barcode3GUI.this.currMatchCode = Barcode3GUI.this.txtMatchCode.getText().toString();
            if (Barcode3GUI.this.myMatchTd != null && Barcode3GUI.this.myMatchTd.getMatchStatus()) {
                if (Barcode3GUI.this.timerMatch3g != null) {
                    Barcode3GUI.this.timerMatch3g.cancel();
                }
                Barcode3GUI.this.lblStatus.setText("\u5df2\u6709\u8bbe\u5907\u3010" + Barcode3GUI.this.currMatchCode.toString() + "\u3011\u8fde\u63a5\uff0c\u8bf7\u8fdb\u884c\u6761\u7801\u91c7\u96c6...");
                Barcode3GUI.this.myScannTd = null;
                Barcode3GUI.this.myScannTd = new BarCodeScannerThread();
                Barcode3GUI.this.myScannTd.setMatchCode(Barcode3GUI.this.currMatchCode);
                Barcode3GUI.this.myScannTd.setReadStatus(false);
                Barcode3GUI.this.myScannTd.start();
                Barcode3GUI.this.timerCollect3g = new Timer();
                Barcode3GUI.this.timerCollect3g.scheduleAtFixedRate((TimerTask)new timerCollect3G(), Barcode3GUI.this.interval, Barcode3GUI.this.period);
                return;
            }
        }
    }
}

