/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeExecutor;
import com.kingdee.eas.barcode.scm.BarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.BarcodeTypeEnum;
import com.kingdee.eas.barcode.scm.IndBarcodeAnalysisFacadeFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BarcodeAnalysisClientHelper {
    public KDBizPromptBox prmtRule = new KDBizPromptBox();
    public BarcodeExecutor barcodeExecutor;
    public String currRuleId;

    public BarcodeAnalysisClientHelper() {
        this.prmtRule.setQueryInfo("com.kingdee.eas.barcode.scm.app.BarcodeRuleQuery");
        this.prmtRule.setEnabledMultiSelection(false);
    }

    public BarcodeAnalysisResult barcodeAnalysis(BarcodeExecutor be, String barcode, String srcBosType, String destBosType, String CUNumber) throws EASBizException, BOSException {
        if (barcode == null || "".equals(barcode.trim())) {
            return null;
        }
        this.barcodeExecutor = be;
        List list = BarcodeAnalysisFacadeFactory.getRemoteInstance().findBarcodeRule(barcode, srcBosType, destBosType, CUNumber);
        this.barcodeExecutor.checkBarcodeAnalysisIds(list, barcode, srcBosType, destBosType);
        String ruleId = null;
        if (list != null && list.size() > 0) {
            if (list.size() > 1 && this.currRuleId != null) {
                this.prmtRule.setData(null);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.listToSet(list), CompareType.INCLUDE));
                ev.setFilter(filter);
                this.prmtRule.setEntityViewInfo(ev);
                this.prmtRule.setDataBySelector();
                Object d = this.prmtRule.getData();
                if (d != null) {
                    ruleId = ((BarcodeRuleInfo)d).getId().toString();
                }
            } else {
                ruleId = (String)list.get(0);
            }
        }
        if (ruleId == null || "".equals(ruleId)) {
            this.currRuleId = null;
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"83_BarcodeAnalysisClientHelper")));
        }
        this.currRuleId = ruleId;
        BarcodeAnalysisResult barcodeAnalysisResult = BarcodeAnalysisFacadeFactory.getRemoteInstance().barcodeAnalysis(barcode, ruleId);
        if (barcodeAnalysisResult != null && barcodeAnalysisResult.getBarcodeType().getValue() == 2 && this.barcodeExecutor != null && this.barcodeExecutor.isAutoExecutePackageBarcode()) {
            this.autoExecutePackageBarcode(barcode, barcodeAnalysisResult);
        }
        if (barcodeAnalysisResult.getBarcodeType().equals((Object)BarcodeTypeEnum.billBarcode)) {
            this.currRuleId = null;
        }
        return barcodeAnalysisResult;
    }

    protected BarcodeAnalysisResult processDossier(BarcodeExecutor be, String barcode, CtrlUnitInfo ctrlUnitInfo, String destBosType) throws BOSException, EASBizException {
        BarcodeAnalysisResult barcodeResult = null;
        this.barcodeExecutor = be;
        String cuid = ctrlUnitInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcode));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.displayName.*");
        sic.add("material.*");
        sic.add("barRule.*");
        sic.add("barRule.barcodeType.*");
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.entrys.name"));
        sic.add(new SelectorItemInfo("template.entrys.value"));
        sic.add(new SelectorItemInfo("template.entrys.displayName.*"));
        view.setSelector(sic);
        BarcodeDossierCollection col = BarcodeDossierFactory.getRemoteInstance().getBarcodeDossierCollection(view);
        if (col.size() > 0) {
            BarcodeDossierInfo info = col.get(0);
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)destBosType));
            filter.getFilterItems().add(new FilterItemInfo("master.id", (Object)info.getBarRule().getId()));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
            view.setFilter(filter);
            sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("master.*");
            sic.add("master.barcodeType.*");
            sic.add("Entry.*");
            sic.add("Entry.property.*");
            view.setSelector(sic);
            IndBarcodeSetupCollection setupCol = IndBarcodeSetupFactory.getRemoteInstance().getIndBarcodeSetupCollection(view);
            if (setupCol.size() > 0) {
                IndBarcodeSetupInfo setupInfo = setupCol.get(0);
                barcodeResult = IndBarcodeAnalysisFacadeFactory.getRemoteInstance().barcodeAnalysis(barcode, info, setupInfo);
                this.currRuleId = setupInfo.getId().toString();
            }
        }
        if (barcodeResult != null && barcodeResult.getBarcodeType().getValue() == 2 && this.barcodeExecutor != null && this.barcodeExecutor.isAutoExecutePackageBarcode()) {
            this.autoExecutePackageBarcode(barcode, barcodeResult);
        }
        return barcodeResult;
    }

    public void autoExecutePackageBarcode(String barcode, BarcodeAnalysisResult barcodeAnalysisResult) {
        List<String> list = barcodeAnalysisResult.getChidrenBarcodes();
        if (list.size() == 0) {
            return;
        }
        IUIWindow window = null;
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"barcodeExecutor", (Object)this.barcodeExecutor);
            uiContext.put((Object)"barcodeList", list);
            uiContext.put((Object)"packageBarcode", (Object)barcode);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create("com.kingdee.eas.barcode.scm.client.PackageBarcodeAutoClient", (Map)uiContext, null, "");
            window.show();
        }
        catch (Exception e1) {
            ((CoreUI)this.barcodeExecutor).handUIException((Throwable)e1);
        }
    }

    public Set listToSet(List list) {
        LinkedHashSet set = new LinkedHashSet();
        for (int i = 0; i < list.size(); ++i) {
            set.add(list.get(i));
        }
        return set;
    }

    public String getCurrRuleId() {
        return this.currRuleId;
    }
}

