/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.eas.barcode.scm.client.BarTenderFileHelper;
import com.kingdee.eas.barcode.scm.client.OleAutomationInvoker;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;

public class BarcodeBarTenderPrinter
extends Composite {
    private static Logger logger = Logger.getLogger((String)BarcodeBarTenderPrinter.class.getName());
    private static final String PROG_ID = "BarTender.Application";
    private OleFrame myFrame = null;
    private OleControlSite controlSite = null;
    private OleAutomation automation = null;
    private OleAutomation oformat = null;
    private int count;
    private List<Map<String, String>> printBarcodes;
    private String templateFileName;

    public BarcodeBarTenderPrinter(Composite parent) {
        super(parent, 0);
        this.myFrame = new OleFrame(parent, 0);
        this.controlSite = new OleControlSite((Composite)this.myFrame, 0, PROG_ID);
        this.controlSite.doVerb(-1);
        this.automation = new OleAutomation((OleClientSite)this.controlSite);
    }

    public OleAutomation getMainOle() throws Exception {
        OleAutomation oDocs = null;
        Variant vFile = null;
        boolean fOpened = false;
        boolean rtnVal = false;
        File templateFile = new File(this.getTemplateFileName());
        if (!templateFile.canRead()) {
            throw new Exception("\u6a21\u677f\u6587\u4ef6\u65e0\u6cd5\u8bfb\u53d6!");
        }
        Variant vDocuments = OleAutomationInvoker.invoke(this.automation, "Formats");
        oDocs = vDocuments.getAutomation();
        String templatePath = templateFile.getAbsolutePath();
        vFile = new Variant(templatePath);
        Variant format = OleAutomationInvoker.invoke(oDocs, "Open", new Variant[]{vFile, new Variant(false), new Variant("")});
        if (format == null) {
            throw new Exception("\u6a21\u677f\u6253\u5f00\u5931\u8d25!");
        }
        fOpened = true;
        OleAutomation oformat = format.getAutomation();
        return oformat;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<Map<String, String>> getPrintBarcodes() {
        return this.printBarcodes;
    }

    public void setPrintBarcodes(List<Map<String, String>> printBarcodes) {
        this.printBarcodes = printBarcodes;
    }

    public OleAutomation getOaAppActiveDoc() {
        String templatePath;
        File templateFile = new File(this.templateFileName);
        if (!templateFile.canRead()) {
            return null;
        }
        OleAutomation oDocs = null;
        Variant vFile = null;
        Variant vDocuments = OleAutomationInvoker.invoke(this.automation, "NamedSubString");
        oDocs = vDocuments.getAutomation();
        if (OleAutomationInvoker.invoke(oDocs, "Open", vFile = new Variant(templatePath = templateFile.getAbsolutePath())) == null) {
            return null;
        }
        Variant vActiveDoc = OleAutomationInvoker.invoke(this.automation, "ActiveDocument");
        OleAutomation oaAppActiveDoc = vActiveDoc.getAutomation();
        return oaAppActiveDoc;
    }

    public int getPerCount() {
        try {
            OleAutomation oformat = this.getMainOle();
            Variant vsetup = OleAutomationInvoker.invoke(oformat, "PrintSetup");
            OleAutomation ovsetup = vsetup.getAutomation();
            Variant vr = OleAutomationInvoker.invoke(OleAutomationInvoker.invoke(oformat, "PageSetup").getAutomation(), "LabelRows");
            Variant vc = OleAutomationInvoker.invoke(OleAutomationInvoker.invoke(oformat, "PageSetup").getAutomation(), "LabelColumns");
            int rows = vr.getInt();
            int cols = vc.getInt();
            return rows * cols;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(List<Map<String, String>> dataMapList, boolean isFormFeed) {
        if (this.oformat == null) {
            try {
                this.oformat = this.getMainOle();
                OleAutomation databases = OleAutomationInvoker.invoke(this.oformat, "Databases").getAutomation();
                Variant firstdb = OleAutomationInvoker.invoke(databases, "GetDatabase", new Variant(1));
                OleAutomation ofirstdb = firstdb.getAutomation();
                Variant textfile = OleAutomationInvoker.invoke(ofirstdb, "TextFile");
                OleAutomation otextfile = textfile.getAutomation();
                String fileName = BarTenderFileHelper.createTempFile2SysDefDir(dataMapList);
                OleAutomationInvoker.invoke(otextfile, "FileName", new Variant(fileName));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        try {
            OleAutomationInvoker.invoke(this.oformat, "PrintOut", new Variant[]{new Variant(false), new Variant(false)});
            Variant variant = OleAutomationInvoker.invoke(this.automation, "Messages");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.distory();
        }
        return 1;
    }

    private void setUseDatabase() {
        Variant vsetup = OleAutomationInvoker.invoke(this.oformat, "PrintSetup");
        OleAutomation ovsetup = vsetup.getAutomation();
        OleAutomationInvoker.invoke(ovsetup, "UseDatabase", new Variant(1));
    }

    public void distory() {
        try {
            OleAutomationInvoker.invoke(this.automation, "Close", new Variant(1));
            OleAutomationInvoker.invoke(this.automation, "Quit", new Variant(1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void disposeResouces(OleAutomation oDocs, Variant vFile, boolean fOpened) {
        try {
            if (fOpened && oDocs != null) {
                OleAutomationInvoker.invoke(oDocs, "CloseAllDocuments", vFile);
            }
            OleAutomationInvoker.invoke(this.automation, "Quit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.automation.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.controlSite.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myFrame.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.automation = null;
        this.controlSite = null;
        this.myFrame = null;
    }

    private boolean setupVariables(OleAutomation oaDocVars, List<Map<String, String>> dataMapList) {
        Variant nameSubStrs = OleAutomationInvoker.invoke(oaDocVars, "NamedSubStrings");
        OleAutomation oNameSubStrs = nameSubStrs.getAutomation();
        OleAutomationInvoker.invoke(oNameSubStrs, "SubString");
        Variant[] vlist = new Variant[dataMapList.size()];
        String key2 = null;
        String val = null;
        Iterator<String> it = null;
        Map<String, String> dataMap = null;
        Object rev = null;
        int count = dataMapList.size();
        for (int i = 0; i < count; ++i) {
            dataMap = dataMapList.get(i);
            for (String key2 : dataMap.keySet()) {
                val = dataMap.get(key2);
                Variant[] variantArray = new Variant[]{new Variant(key2), new Variant(val)};
            }
        }
        OleAutomationInvoker.invoke(oNameSubStrs, "SetAll", new Variant(2));
        return true;
    }

    private boolean setupVariables2(OleAutomation oaDocVars) {
        Object vals = null;
        Variant nameSubStrs = OleAutomationInvoker.invoke(oaDocVars, "NamedSubStrings");
        OleAutomation oNameSubStrs = nameSubStrs.getAutomation();
        Map<String, String> row = null;
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = null;
        Object rev = null;
        String key2 = null;
        String val = null;
        String vblf = "\r\n";
        for (int i = 0; i < this.printBarcodes.size(); ++i) {
            row = this.printBarcodes.get(i);
            for (String key2 : row.keySet()) {
                val = row.get(key2);
                sb.append(key2).append(vblf).append(val).append(vblf);
            }
            OleAutomationInvoker.invoke(oNameSubStrs, "SetAll", new Variant[]{new Variant(sb.toString()), new Variant(vblf)});
        }
        return true;
    }

    private boolean setupVariables(OleAutomation oaDocVars, Map<String, String> dataMap) {
        boolean fSuccess = true;
        Variant nameSubStrs = OleAutomationInvoker.invoke(oaDocVars, "NamedSubStrings");
        OleAutomation oNameSubStrs = nameSubStrs.getAutomation();
        Set<String> keys = dataMap.keySet();
        Iterator<String> it = keys.iterator();
        Object vDocVar = null;
        Variant rev = null;
        String key = null;
        String val = null;
        while (it.hasNext()) {
            key = it.next();
            val = dataMap.get(key);
            try {
                Object vt = null;
                Object ovt = null;
                rev = OleAutomationInvoker.invoke(oaDocVars, "SetNamedSubStringValue", new Variant[]{new Variant(key), new Variant(val)});
                if (rev != null) continue;
                System.out.println("==================key=" + key + "  is not exists");
            }
            catch (SWTException e) {
                fSuccess = false;
            }
        }
        return fSuccess;
    }
}

