/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.util.ResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class BarcodeClientUtils {
    public static final Color necessaryColor = new Color(252, 251, 223);
    public static final Color lockedColor = new Color(217, 217, 208);
    public static final String DEFAULT_BARCODECONFIG = "defaultBarcodeConfig";

    public static Object getSingleCellValue(ICell cell, PropertyInfo property) {
        Object value = cell.getValue();
        if (value == null) {
            return null;
        }
        String dataType = property.getString("dataType");
        if (property instanceof LinkPropertyInfo) {
            if (value instanceof IObjectValue) {
                return ((IObjectValue)value).get("number");
            }
            return value;
        }
        if ("Enum".equals(dataType)) {
            return ((Enum)value).getName();
        }
        if ("Boolean".equals(dataType)) {
            return value;
        }
        if ("Date".equals(dataType)) {
            String result = null;
            try {
                result = BarcodeUtils.SIMPLE_DATE_FORMAT.format(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("TimeStamp".equals(dataType)) {
            String result = null;
            try {
                result = BarcodeUtils.SIMPLE_TIMESTAMP_FORMAT.format(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("BigDecimal".equals(dataType)) {
            BigDecimal result = null;
            try {
                result = new BigDecimal(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("Integer".equals(dataType)) {
            Integer result = null;
            try {
                result = Integer.parseInt(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        return value;
    }

    public static Object getSingleValue(Object value, PropertyInfo property) {
        if (value == null || "".equals(value)) {
            return null;
        }
        String dataType = property.getString("dataType");
        if (property instanceof LinkPropertyInfo) {
            if (value instanceof IObjectValue) {
                return ((IObjectValue)value).get("number");
            }
            return value;
        }
        if ("Enum".equals(dataType)) {
            return ((Enum)value).getName();
        }
        if ("Boolean".equals(dataType)) {
            return value;
        }
        if ("Date".equals(dataType)) {
            String result = null;
            try {
                result = BarcodeUtils.SIMPLE_DATE_FORMAT.format(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("TimeStamp".equals(dataType)) {
            String result = null;
            try {
                result = BarcodeUtils.SIMPLE_TIMESTAMP_FORMAT.format(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("BigDecimal".equals(dataType)) {
            BigDecimal result = null;
            try {
                result = new BigDecimal(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("Integer".equals(dataType)) {
            Integer result = null;
            try {
                result = Integer.parseInt(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        return value;
    }

    public static void loadSingleColumn(IColumn column, PropertyInfo property) {
        column.getStyleAttributes().setLocked(false);
        String dataType = property.getString("dataType");
        if (property instanceof LinkPropertyInfo) {
            KDBizPromptBox f7 = null;
            EntityObjectInfo tempEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
            String defaultF7 = tempEntity.getExtendedProperty("defaultF7Query");
            if (defaultF7 != null) {
                f7 = new KDBizPromptBox();
                f7.setVisible(true);
                f7.setEditable(true);
                f7.setDisplayFormat("$number$");
                f7.setEditFormat("$number$");
                f7.setCommitFormat("$number$");
                KDTDefaultCellEditor object_CellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                column.setEditor((ICellEditor)object_CellEditor);
                ObjectValueRender avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
                column.setRenderer((IBasicRender)avr);
                f7.setQueryInfo(defaultF7);
            }
        } else if ("Enum".equals(dataType)) {
            String enumClass = (String)property.get("metadataRef");
            if (enumClass != null) {
                List emList = EnumUtils.getEnumList((String)enumClass);
                KDComboBox kdComboBox = new KDComboBox(emList.toArray());
                kdComboBox.setUserObject((Object)emList);
                kdComboBox.setMaximumRowCount(10);
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                column.setEditor((ICellEditor)kdtDefaultCellEditor);
            }
        } else if ("Boolean".equals(dataType)) {
            KDCheckBox checkBox = new KDCheckBox();
            checkBox.setSelected(false);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
            column.setEditor((ICellEditor)kdtDefaultCellEditor);
        } else if ("Date".equals(dataType)) {
            KDDatePicker datePicker = new KDDatePicker();
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
            column.setEditor((ICellEditor)kdtDefaultCellEditor);
            column.getStyleAttributes().setLocked(false);
            column.getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        } else if ("TimeStamp".equals(dataType)) {
            KDDatePicker datePicker = new KDDatePicker();
            datePicker.setTimeEnabled(true);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
            column.setEditor((ICellEditor)kdtDefaultCellEditor);
            column.getStyleAttributes().setLocked(false);
            column.getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        } else if ("BigDecimal".equals(dataType)) {
            column.getStyleAttributes().setNumberFormat("0.00000000");
        }
    }

    public static void setSingleCellValue(ICell cell, PropertyInfo property, String value) {
        boolean isSetValue;
        String dataType = property.getString("dataType");
        boolean bl = isSetValue = value != null && !"".equals(value.trim());
        if ("Enum".equals(dataType)) {
            String enumClass = (String)property.get("metadataRef");
            List emList = EnumUtils.getEnumList((String)enumClass);
            if (isSetValue && enumClass != null) {
                cell.setValue(BarcodeUtils.getEnum(emList, value));
            }
        } else if ("Boolean".equals(dataType)) {
            if (isSetValue) {
                if ("1".equals(value) || "true".equalsIgnoreCase(value) || EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(value)) {
                    cell.setValue((Object)true);
                } else {
                    cell.setValue((Object)false);
                }
            }
        } else if ("Date".equals(dataType)) {
            if (isSetValue) {
                try {
                    Date date = BarcodeUtils.SIMPLE_DATE_FORMAT.parse(value);
                    cell.setValue((Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else if ("TimeStamp".equals(dataType)) {
            if (isSetValue) {
                try {
                    Date date = BarcodeUtils.SIMPLE_TIMESTAMP_FORMAT.parse(value);
                    cell.setValue((Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else if ("BigDecimal".equals(dataType)) {
            if (isSetValue) {
                try {
                    cell.setValue((Object)new BigDecimal(value));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    cell.setValue((Object)new BigDecimal("0.00000000"));
                }
            }
        } else if ("Integer".equals(dataType)) {
            if (isSetValue) {
                try {
                    cell.setValue((Object)Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    cell.setValue((Object)0);
                }
            }
        } else if (isSetValue) {
            cell.setValue((Object)value);
        }
    }

    public static void loadSingleCell(ICell cell, PropertyInfo property, String value) {
        block32: {
            boolean isPutValue;
            cell.getStyleAttributes().setLocked(false);
            String dataType = property.getString("dataType");
            boolean bl = isPutValue = value != null && !"".equals(value.trim());
            if (property instanceof LinkPropertyInfo) {
                KDBizPromptBox f7 = null;
                EntityObjectInfo tempEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
                String defaultF7 = tempEntity.getExtendedProperty("defaultF7Query");
                if (defaultF7 != null) {
                    f7 = new KDBizPromptBox();
                    f7.setVisible(true);
                    f7.setEditable(true);
                    f7.setDisplayFormat("$number$");
                    f7.setEditFormat("$number$");
                    f7.setCommitFormat("$number$");
                    KDTDefaultCellEditor object_CellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                    cell.setEditor((ICellEditor)object_CellEditor);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
                    cell.setRenderer((IBasicRender)avr);
                    f7.setQueryInfo(defaultF7);
                }
                if (isPutValue) {
                    try {
                        if (defaultF7 != null) {
                            IObjectValue tempObj = (IObjectValue)Class.forName(tempEntity.getObjectValueClassRuntime()).newInstance();
                            tempObj.put("number", (Object)value);
                            cell.setValue((Object)tempObj);
                            break block32;
                        }
                        cell.setValue((Object)value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if ("Enum".equals(dataType)) {
                String enumClass = (String)property.get("metadataRef");
                if (enumClass != null) {
                    List emList = EnumUtils.getEnumList((String)enumClass);
                    KDComboBox kdComboBox = new KDComboBox(emList.toArray());
                    kdComboBox.setUserObject((Object)emList);
                    kdComboBox.setMaximumRowCount(10);
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                    cell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    if (isPutValue) {
                        cell.setValue(BarcodeUtils.getEnum(emList, value));
                    }
                }
            } else if ("Boolean".equals(dataType)) {
                KDCheckBox checkBox = new KDCheckBox();
                checkBox.setSelected(false);
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
                cell.setEditor((ICellEditor)kdtDefaultCellEditor);
                cell.setValue((Object)false);
                if (isPutValue) {
                    if ("1".equals(value) || "true".equalsIgnoreCase(value) || EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(value)) {
                        checkBox.setSelected(true);
                        cell.setValue((Object)true);
                    } else {
                        cell.setValue((Object)false);
                    }
                }
            } else if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
                KDDatePicker datePicker = new KDDatePicker();
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
                cell.setEditor((ICellEditor)kdtDefaultCellEditor);
                cell.getStyleAttributes().setLocked(false);
                cell.getStyleAttributes().setNumberFormat("yyyy-MM-dd");
                cell.setValue(null);
                if (isPutValue) {
                    try {
                        Date date = BarcodeUtils.SIMPLE_DATE_FORMAT.parse(value);
                        cell.setValue((Object)date);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            } else if ("BigDecimal".equals(dataType)) {
                if (isPutValue) {
                    try {
                        cell.setValue((Object)new BigDecimal(value));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        cell.setValue((Object)new BigDecimal("0.00"));
                    }
                }
            } else if ("Integer".equals(dataType)) {
                if (isPutValue) {
                    try {
                        cell.setValue((Object)Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        cell.setValue((Object)0);
                    }
                }
            } else if (isPutValue) {
                cell.setValue((Object)value);
            }
        }
    }

    public static String getBarcodeResource(String key) {
        return ResourceUtil.getResource("com.kingdee.eas.barcode.scm.IndBarcodeResource", key);
    }

    public static String getFormatPattern(int scale, boolean takeOutZero) {
        if (takeOutZero) {
            String pattern = null;
            String temp = "#############";
            String scaleStr = temp.substring(0, scale);
            pattern = scale == 0 ? "%{#,##0}f" : "%{#,##0." + scaleStr + "}f";
            return pattern;
        }
        return BarcodeClientUtils.getFormatPattern(scale);
    }

    public static String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = pattern + ";-" + pattern + ";";
        return pattern;
    }
}

