/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.biz.agent.DefaultMultiBillWorkAgent;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeExecutor;
import com.kingdee.eas.barcode.scm.BarcodeScanningFactory;
import com.kingdee.eas.barcode.scm.BarcodeTypeEnum;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.IndBarcodeAnalysisFacadeFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.ReflectUtil;
import com.kingdee.eas.barcode.scm.client.BarcodeAnalysisClientHelper;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.btp.client.BOTClientTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BarcodeComponent
extends JComponent
implements BarcodeExecutor {
    protected EditUI coreUI;
    protected DataBinder dataBinder;
    protected DataComponentMap dcm;
    protected EntityObjectInfo entity;
    protected String botpSrcEntryName;
    protected String botpDestEntryName;
    public static final String CTX_BOTPSRCENTRYNAME_KEY = "@botpSrcEntryName";
    public static final String CTX_BOTPDESTENTRYNAME_KEY = "@botpDestEntryName";
    protected BarcodeConfigInfo barcodeConfigInfo;
    protected IndBarcodeSetupInfo indBarcodeConfigInfo;
    protected String paramValue = null;

    public void exceuteBarcode(CoreUI ui, String barcode) throws Exception {
        BarcodeAnalysisResult barcodeResult;
        if (!ui.getOprtState().equals(OprtState.ADDNEW) && !ui.getOprtState().equals(OprtState.EDIT)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"NOEDITNOADDNEW"));
            return;
        }
        this.coreUI = (EditUI)ui;
        this.dataBinder = this.coreUI.getDataBinder();
        this.dcm = this.dataBinder.getDataComponentMap();
        this.entity = BarcodeUtils.getEntityByBosType(this.dataBinder.getValueObject().getBOSType().toString());
        BarcodeAnalysisClientHelper bach = new BarcodeAnalysisClientHelper();
        String srcBosType = null;
        String destBostType = this.entity.getType().toString();
        if (this.barcodeConfigInfo != null && this.barcodeConfigInfo.getSrcBosType() != null) {
            srcBosType = this.barcodeConfigInfo.getSrcBosType();
        }
        if ((barcodeResult = bach.barcodeAnalysis(this, barcode, srcBosType, destBostType, SysContext.getSysContext().getCurrentCtrlUnit().getNumber())) == null) {
            return;
        }
        BarcodeTypeEnum bte = barcodeResult.getBarcodeType();
        if (bte.getValue() == 0) {
            this.analysisResult(barcodeResult);
        } else if (bte.getValue() == 1) {
            this.billBarcodeExecute(srcBosType, destBostType, barcodeResult);
        } else if (bte.getValue() == 2) {
            // empty if block
        }
    }

    public String exceuteBarcode(CoreUI ui, String barcode, String type) throws Exception {
        IndubarodeParamsetCollection paramCol;
        String message = null;
        if (!ui.getOprtState().equals(OprtState.ADDNEW) && !ui.getOprtState().equals(OprtState.EDIT)) {
            message = EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"NOEDITNOADDNEW");
            MsgBox.showInfo((String)message);
            return message;
        }
        this.coreUI = (EditUI)ui;
        this.dataBinder = this.coreUI.getDataBinder();
        this.dcm = this.dataBinder.getDataComponentMap();
        this.entity = BarcodeUtils.getEntityByBosType(this.dataBinder.getValueObject().getBOSType().toString());
        BarcodeAnalysisClientHelper bach = new BarcodeAnalysisClientHelper();
        String srcBosType = null;
        String destBostType = this.entity.getType().toString();
        if (this.barcodeConfigInfo != null && this.barcodeConfigInfo.getSrcBosType() != null) {
            srcBosType = this.barcodeConfigInfo.getSrcBosType();
        }
        if (this.paramValue == null && (paramCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection()) != null && paramCol.get(0) != null) {
            if (paramCol.get(0).isBusinessBarcode()) {
                this.paramValue = "0";
            } else if (paramCol.get(0).isIndBarcode()) {
                this.paramValue = "1";
            } else if (paramCol.get(0).isPriorBusiness()) {
                this.paramValue = "2";
            } else if (paramCol.get(0).isPriorInd()) {
                this.paramValue = "3";
            }
        }
        BarcodeAnalysisResult barcodeResult = null;
        CtrlUnitInfo ctrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        boolean isDossier = false;
        if ("1".equals(this.paramValue) || "3".equals(this.paramValue)) {
            barcodeResult = bach.processDossier(this, barcode, ctrlUnitInfo, destBostType);
            if (barcodeResult == null) {
                if ("1".equals(this.paramValue)) {
                    message = EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"isnotRule");
                    MsgBox.showWarning((String)message);
                } else if ("3".equals(this.paramValue)) {
                    try {
                        barcodeResult = bach.barcodeAnalysis(this, barcode, srcBosType, destBostType, ctrlUnitInfo.getNumber());
                    }
                    catch (Exception e) {
                        message = EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"isnotRule");
                        MsgBox.showWarning((String)message);
                    }
                }
            } else {
                isDossier = true;
            }
        } else if ("0".equals(this.paramValue)) {
            barcodeResult = bach.barcodeAnalysis(this, barcode, srcBosType, destBostType, ctrlUnitInfo.getNumber());
        } else if ("2".equals(this.paramValue)) {
            try {
                barcodeResult = bach.barcodeAnalysis(this, barcode, srcBosType, destBostType, ctrlUnitInfo.getNumber());
            }
            catch (Exception e) {
                if (barcodeResult != null && barcodeResult.getItems().size() == 0) {
                    barcodeResult = bach.processDossier(this, barcode, ctrlUnitInfo, destBostType);
                }
                if (barcodeResult == null) {
                    barcodeResult = bach.processDossier(this, barcode, ctrlUnitInfo, destBostType);
                }
                if (barcodeResult == null) {
                    message = EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"isnotRule");
                    MsgBox.showWarning((String)message);
                }
                isDossier = true;
            }
        }
        if (barcodeResult == null) {
            return message;
        }
        BarcodeTypeEnum bte = barcodeResult.getBarcodeType();
        if (bte.getValue() == 0) {
            IObjectValue editData = this.coreUI.getDataObject();
            String transTypeNumber = null;
            if (editData.get("transactionType") != null) {
                TransactionTypeInfo transactionTypeInfo = (TransactionTypeInfo)editData.get("transactionType");
                transTypeNumber = transactionTypeInfo.getNumber();
            }
            if (barcodeResult.isBarcodeRepeat()) {
                int index;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("isScan", (Object)1, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("barcodeState", (Object)BarcodeClientUtils.getInOrOutBill(null, destBostType, transTypeNumber), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcode, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                BarcodeDossierCollection dossiercol = null;
                try {
                    dossiercol = BarcodeDossierFactory.getRemoteInstance().getBarcodeDossierCollection(viewInfo);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                if (dossiercol.size() > 0 && (0 == (index = MsgBox.showConfirm3((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"161_BarcodeScanningEditUI"))) || 2 == index)) {
                    SysUtil.abort();
                }
            }
            int rowNum = this.analysisResultForLog(barcodeResult);
            this.afterexecuteBarcode(barcode, destBostType, transTypeNumber);
        } else if (bte.getValue() == 1) {
            if (srcBosType == null || "".equals(srcBosType)) {
                barcodeResult.setBosType(destBostType);
            } else {
                barcodeResult.setBosType(srcBosType);
            }
            this.billBarcodeExecute(srcBosType, destBostType, barcodeResult);
        } else if (bte.getValue() == 2) {
            // empty if block
        }
        return message;
    }

    public void exceuteBarcodeForInd(CoreUI ui, String barcode) throws Exception {
        if (!ui.getOprtState().equals(OprtState.ADDNEW) && !ui.getOprtState().equals(OprtState.EDIT)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"NOEDITNOADDNEW"));
            return;
        }
        this.coreUI = (EditUI)ui;
        this.dataBinder = this.coreUI.getDataBinder();
        this.dcm = this.dataBinder.getDataComponentMap();
        this.entity = BarcodeUtils.getEntityByBosType(this.dataBinder.getValueObject().getBOSType().toString());
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        BarcodeDossierCollection col = BarcodeDossierFactory.getRemoteInstance().getBarcodeDossierCollection("where number='" + barcode + "' and CU.id='" + cuid + "'");
        if (col.size() > 0) {
            BarcodeDossierInfo info = col.get(0);
            IndBarcodeSetupCollection setupCol = IndBarcodeSetupFactory.getRemoteInstance().getIndBarcodeSetupCollection("where businessObjectID='" + this.entity.getType() + "' and master.id='" + info.getBarRule().getId() + "' and state='" + 1 + "'");
            if (setupCol.size() > 0) {
                IndBarcodeSetupInfo setupInfo = setupCol.get(0);
                BarcodeAnalysisResult barcodeResult = IndBarcodeAnalysisFacadeFactory.getRemoteInstance().barcodeAnalysis(barcode, info, setupInfo);
                BarcodeTypeEnum bte = barcodeResult.getBarcodeType();
                this.analysisResultForInd(barcodeResult);
            } else {
                MsgBox.showWarning((String)"\u672a\u627e\u5230\u89e3\u6790\u89c4\u5219");
            }
        } else {
            MsgBox.showWarning((String)"\u672a\u627e\u5230\u6761\u7801\u6863\u6848");
        }
    }

    protected void billBarcodeExecute(String srcBosType, String destBostType, BarcodeAnalysisResult barcodeResult) throws BOSException, BTPException, EASBizException, Exception {
        if (this.barcodeConfigInfo != null && this.barcodeConfigInfo.getSrcBosType() != null) {
            BOTMappingInfo mappingInfo = BOTMappingFactory.getRemoteInstance().getMappingInfoByPK((IObjectPK)new ObjectUuidPK(this.barcodeConfigInfo.getBotMapping().getId().toString()));
            SelectorItemCollection botpSelectors = null;
            if (mappingInfo.getIsTempSave() == 2) {
                botpSelectors = BOTClientTools.getBillEditUISelector((String)destBostType);
            }
            this.botpSrcEntryName = BOTMappingUtil.getSrcEntriesName((BOTMappingInfo)mappingInfo);
            this.botpDestEntryName = BOTMappingUtil.getDestEntriesName((BOTMappingInfo)mappingInfo);
            this.coreUI.getUIContext().put(CTX_BOTPSRCENTRYNAME_KEY, this.botpSrcEntryName);
            this.coreUI.getUIContext().put(CTX_BOTPDESTENTRYNAME_KEY, this.botpDestEntryName);
            CoreBillBaseInfo srcBillInfo = BarcodeScanningFactory.getRemoteInstance().getBillData(barcodeResult);
            IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstanceWithObjectContext((Context)((Context)this.coreUI.getUIContext().get("Dest_MainOrgContext")));
            ArrayList<String> srcEntryIds = new ArrayList<String>();
            IObjectCollection entryColl = (IObjectCollection)srcBillInfo.get(this.botpSrcEntryName);
            for (int i = 0; i < entryColl.size(); ++i) {
                srcEntryIds.add(entryColl.getObject(i).getString("id"));
            }
            CoreBillBaseCollection srcBillCollection = new CoreBillBaseCollection();
            srcBillCollection.add(srcBillInfo);
            BOTClientTools.reBuildControl((CoreUI)this.coreUI, (BOTMappingInfo)mappingInfo, (CoreBillBaseCollection)srcBillCollection, (String)destBostType);
            BTPTransformResult btpResult = iBTPManager.transformForBotp(new String[]{srcBillInfo.getId().toString()}, new String[]{this.botpSrcEntryName}, srcEntryIds, botpSelectors, destBostType, (IObjectPK)new ObjectUuidPK(mappingInfo.getId().toString()), srcBosType);
            IObjectCollection destBillCols = btpResult.getBills();
            BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
            this.coreUI.getUIContext().put("srcBillID", srcBillInfo.getId().toString());
            if (destBillCols != null && destBillCols.size() == 0) {
                throw new BTPException(BTPException.DESTBILLNULL);
            }
            this.coreUI.checkModified();
            this.doCreateFrom(mappingInfo, destBillCols, botRelationCols, iBTPManager);
            this.afterBillBarcode(true);
        } else if (this.barcodeConfigInfo.getSrcBosType() == null) {
            CoreBillBaseInfo billInfo = BarcodeScanningFactory.getRemoteInstance().getBillData(barcodeResult);
            String id = billInfo.getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            this.loadData((IObjectPK)pk);
            this.afterBillBarcode(false);
        }
    }

    protected void afterBillBarcode(boolean isBotp) {
    }

    @Override
    public void executeBarcode(String barcode) throws Exception {
        this.exceuteBarcode((CoreUI)this.coreUI, barcode, this.paramValue);
    }

    @Override
    public boolean isAutoExecutePackageBarcode() {
        return true;
    }

    public void loadData(IObjectPK pk) throws Exception {
        this.coreUI.checkModified();
        IObjectValue objValue = (IObjectValue)ReflectUtil.invoke(this.coreUI, "getValue", new Class[]{IObjectPK.class}, new Object[]{pk});
        this.coreUI.setOprtState("EDIT");
        this.coreUI.setDataObject(objValue);
        ReflectUtil.invoke(this.coreUI, "innerLoadFields");
        ReflectUtil.invoke(this.coreUI, "showMessageForStatus");
        this.coreUI.getUIContext().put("ID", pk.toString());
        this.coreUI.getUIContext().put("InitDataObject", objValue);
    }

    protected void doCreateFrom(BOTMappingInfo botMappingInfo, IObjectCollection destBillCols, BOTRelationCollection botRelationCols, IBTPManager iBTPManager) throws Exception {
        if (botMappingInfo.getIsTempSave() != 2 || destBillCols.size() > 1) {
            RealModeIDList idList = RealModeIDList.getEmptyIDList();
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
                agent.markBotpTransfer((IObjectValue)destBillInfo, destBillInfo.getId().toString());
                idList.add(destBillInfo.getId().toString());
            }
            idList.setCurrentIndex(0);
            this.coreUI.getUIContext().remove("ID");
            this.coreUI.getUIContext().remove("IDList");
            this.coreUI.getUIContext().remove("InitDataObject");
            this.coreUI.getUIContext().put("ID", idList.getCurrentID());
            this.coreUI.getUIContext().put("IDList", idList);
            this.coreUI.setOprtState("EDIT");
            this.coreUI.getUIContext().put("BOTPViewStatus", new Integer(1));
            this.coreUI.prepareInit().callHandler();
            this.coreUI.onLoad();
        } else {
            IObjectValue destBillInfo = destBillCols.getObject(0);
            DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
            agent.markBotpTransfer(destBillInfo, destBillInfo.get("id").toString());
            ((CoreBillEditUI)this.coreUI).setMakeRelations(botRelationCols);
            this.coreUI.getUIContext().remove("ID");
            this.coreUI.getUIContext().remove("IDList");
            this.coreUI.getUIContext().remove("InitDataObject");
            this.coreUI.getUIContext().put("InitDataObject", destBillInfo);
            this.coreUI.setOprtState("ADDNEW");
            this.coreUI.getUIContext().put("BOTPViewStatus", new Integer(1));
            if (destBillCols.getObject(0).get("id") != null) {
                DataObjectMutex mutextControl = new DataObjectMutex();
                try {
                    mutextControl.requestDataObjectLock(destBillCols.getObject(0).get("id").toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.coreUI.prepareInit().callHandler();
            this.coreUI.onLoad();
        }
    }

    public ICoreBase getBizInterface() throws BOSException {
        return (ICoreBase)ReflectUtil.invoke(this.coreUI, "getBizInterface");
    }

    protected abstract void analysisResult(BarcodeAnalysisResult var1) throws Exception;

    protected abstract int analysisResultForLog(BarcodeAnalysisResult var1) throws Exception;

    protected abstract void analysisResultForInd(BarcodeAnalysisResult var1) throws Exception;

    protected boolean mathText(Component comp, Object cellValue, Object compareValue, String field) {
        if (comp instanceof KDPromptBox) {
            String number;
            KDPromptBox temp = (KDPromptBox)comp;
            if (cellValue != null) {
                temp.setValue(cellValue);
            }
            if ((number = ((IObjectValue)cellValue).getString("number")) != null && number.equals(compareValue.toString())) {
                return true;
            }
        } else if (comp instanceof KDCheckBox) {
            KDCheckBox temp = (KDCheckBox)comp;
            if (cellValue != null) {
                temp.setSelected(((Boolean)cellValue).booleanValue());
            }
            if (temp.isSelected()) {
                if ("1".equals(compareValue.toString()) || "true".equalsIgnoreCase(compareValue.toString()) || EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(compareValue.toString())) {
                    return true;
                }
            } else if (!("1".equals(compareValue.toString()) || "true".equalsIgnoreCase(compareValue.toString()) || EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(compareValue.toString()))) {
                return true;
            }
        } else if (comp instanceof KDDatePicker) {
            KDDatePicker temp = (KDDatePicker)comp;
            if (cellValue != null) {
                temp.setValue(cellValue);
            }
            if (temp.getValue() != null && temp.getValue() instanceof Date) {
                return BarcodeUtils.SIMPLE_DATE_FORMAT.format(temp.getValue()).equals(BarcodeUtils.SIMPLE_DATE_FORMAT.format(compareValue));
            }
        } else if (comp instanceof KDTextField) {
            KDTextField temp = (KDTextField)comp;
            if (cellValue != null) {
                temp.setText((String)cellValue);
            }
            if (temp.getText() != null && temp.getText().equals(compareValue.toString())) {
                return true;
            }
        } else if (comp instanceof KDComboBox) {
            List emList;
            KDComboBox temp = (KDComboBox)comp;
            if (cellValue != null) {
                temp.setSelectedItem(cellValue);
            }
            Object fields = ReflectUtil.getFieldObject(DataComponentMap.class, "compToField", this.dcm);
            Field f = null;
            if (fields != null && fields instanceof HashMap) {
                f = this.getDcmField((HashMap)fields, field);
            }
            if (f.getFieldClazz() != null && BarcodeUtils.getEnum(emList = EnumUtils.getEnumList((Class)f.getFieldClazz()), compareValue.toString()).equals(temp.getSelectedItem())) {
                return true;
            }
        } else {
            Object compProperty = BindingUtility.getBeanProperty((Object)comp, (String)this.dcm.getComponentProperty(field).getPropertyName());
            if (compProperty != null && compProperty.toString().equals(compareValue.toString())) {
                return true;
            }
        }
        return false;
    }

    protected boolean mathText(ICell cell, KDTable kdt, Object compareValue, String field) {
        KDTSelectBlock block = kdt.getSelectManager().get();
        kdt.getEditManager().editCellAt(cell.getRowIndex(), cell.getColumnIndex());
        boolean result = false;
        if (cell.getEditor() != null && cell.getEditor().getComponent() != null) {
            result = this.mathText(cell.getEditor().getComponent(), cell.getValue(), compareValue, field);
        } else if (kdt.getColumn(cell.getColumnIndex()).getEditor() != null && kdt.getColumn(cell.getColumnIndex()).getEditor().getComponent() != null) {
            result = this.mathText(kdt.getColumn(cell.getColumnIndex()).getEditor().getComponent(), cell.getValue(), compareValue, field);
        } else if (cell.getValue() != null) {
            result = cell.getValue().toString().equals(compareValue.toString());
        }
        kdt.getEditManager().cancelEditing();
        kdt.getSelectManager().remove();
        return result;
    }

    public Object putValue(Component comp, Object value, String field) {
        if (value == null) {
            return null;
        }
        Object newValue = null;
        if (comp instanceof KDPromptBox) {
            KDPromptBox temp = (KDPromptBox)comp;
            temp.setText(value.toString());
            try {
                temp.commitEdit();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            newValue = temp.getValue();
        } else if (comp instanceof KDCheckBox) {
            KDCheckBox temp = (KDCheckBox)comp;
            if ("1".equals(value.toString()) || "true".equalsIgnoreCase(value.toString()) || EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(value.toString())) {
                temp.setSelected(true);
            } else {
                temp.setSelected(false);
            }
            ChangeListener[] listeners = (ChangeListener[])temp.getListeners(ChangeListener.class);
            ChangeEvent event = new ChangeEvent(temp);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].stateChanged(event);
            }
            newValue = temp.isSelected();
        } else if (comp instanceof KDDatePicker) {
            KDDatePicker temp = (KDDatePicker)comp;
            temp.setValue(value);
            try {
                temp.commitEdit();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            newValue = temp.getValue();
        } else if (comp instanceof KDTimePicker) {
            KDTimePicker temp = (KDTimePicker)comp;
            if (value instanceof Date) {
                temp.setValue((Object)new Timestamp(((Date)value).getTime()));
            } else {
                temp.setValue(value);
            }
            try {
                temp.commitEdit();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (comp instanceof KDTextField) {
            KDTextField temp = (KDTextField)comp;
            temp.setText(value.toString());
            PropertyChangeListener[] listeners = (PropertyChangeListener[])temp.getListeners(PropertyChangeListener.class);
            PropertyChangeEvent event = new PropertyChangeEvent(temp, "text", "", value.toString());
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].propertyChange(event);
            }
            newValue = temp.getText();
        } else if (comp instanceof KDComboBox) {
            KDComboBox temp = (KDComboBox)comp;
            Object fields = ReflectUtil.getFieldObject(DataComponentMap.class, "compToField", this.dcm);
            Field f = null;
            if (fields != null && fields instanceof HashMap) {
                f = this.getDcmField((HashMap)fields, field);
            }
            if (f.getFieldClazz() != null) {
                List emList = EnumUtils.getEnumList((Class)f.getFieldClazz());
                temp.setSelectedItem(BarcodeUtils.getEnum(emList, value.toString()));
            }
            ItemListener[] listeners = (ItemListener[])temp.getListeners(ItemListener.class);
            ItemEvent event = new ItemEvent((ItemSelectable)temp, temp.getSelectedIndex(), temp.getSelectedItem(), 1);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].itemStateChanged(event);
            }
            newValue = temp.getSelectedItem();
        } else if (comp instanceof KDFormattedTextField) {
            KDFormattedTextField temp = (KDFormattedTextField)comp;
            temp.setText(value.toString());
            try {
                temp.commitEdit();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            newValue = temp.getNumberValue();
        } else if (comp instanceof KDNumberTextField) {
            KDNumberTextField temp = (KDNumberTextField)comp;
            temp.setText(value.toString());
            try {
                temp.commitEdit();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            newValue = temp.getNumberValue();
        } else {
            BindingUtility.setBeanProperty((Object)comp, (String)this.dcm.getComponentProperty(field).getPropertyName(), (Object)value);
            newValue = value;
        }
        comp.requestFocus();
        return newValue;
    }

    public Field getDcmField(HashMap fields, String field) {
        if (fields != null) {
            for (Map.Entry e : fields.entrySet()) {
                Field f = (Field)e.getValue();
                if (f.getName() == null || !f.getName().equals(field)) continue;
                return f;
            }
        }
        return null;
    }

    public Object putValue(ICell cell, KDTable kdt, Object value, String field) {
        KDTSelectBlock block = kdt.getSelectManager().get();
        boolean isLocked = cell.getStyleAttributes().isLocked();
        if (isLocked) {
            cell.getStyleAttributes().setLocked(false);
        }
        kdt.getEditManager().editCellAt(cell.getRowIndex(), cell.getColumnIndex());
        Object newValue = null;
        if (cell.getEditor() != null && cell.getEditor().getComponent() != null) {
            newValue = this.putValue(cell.getEditor().getComponent(), value, field);
        } else if (kdt.getColumn(cell.getColumnIndex()).getEditor() != null && kdt.getColumn(cell.getColumnIndex()).getEditor().getComponent() != null) {
            newValue = this.putValue(kdt.getColumn(cell.getColumnIndex()).getEditor().getComponent(), value, field);
        } else {
            cell.setValue(value);
            newValue = value;
        }
        cell.setValue(newValue);
        KDTEditListener[] listeners = (KDTEditListener[])kdt.getListeners(KDTEditListener.class);
        KDTEditEvent e = new KDTEditEvent((Object)kdt, null, newValue, cell.getRowIndex(), cell.getColumnIndex(), false, 1);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].editStopped(e);
        }
        kdt.getEditManager().cancelEditing();
        kdt.getSelectManager().remove();
        cell.getStyleAttributes().setLocked(isLocked);
        return newValue;
    }

    public BarcodeConfigInfo getBarcodeConfigInfo() {
        return this.barcodeConfigInfo;
    }

    public void setBarcodeConfigInfo(BarcodeConfigInfo barcodeConfigInfo) {
        this.barcodeConfigInfo = barcodeConfigInfo;
    }

    public IndBarcodeSetupInfo getIndBarcodeConfigInfo() {
        return this.indBarcodeConfigInfo;
    }

    public void setIndBarcodeConfigInfo(IndBarcodeSetupInfo indBarcodeConfigInfo) {
        this.indBarcodeConfigInfo = indBarcodeConfigInfo;
    }
}

