/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodePDAConfigXmlUntil;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.DataBasePermissionUtil;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeConfigEditUI;
import com.kingdee.eas.barcode.scm.client.BarcodeConfigDetailsEditUI;
import com.kingdee.eas.barcode.scm.client.BarcodeDefaultUI;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.barcode.scm.client.SelectEntityUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitFilterInfoProducer;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.event.ChangeEvent;

public class BarcodeConfigEditUI
extends AbstractBarcodeConfigEditUI {
    protected EntityObjectInfo currEntity;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"85_BarcodeConfigEditUI"));
        this.prmtBotMapping.setEnabled(false);
        this.prmtBotMapping.setEnabledMultiSelection(false);
        this.prmtBotMapping.setCommitFormat("$name$");
        this.actionSave.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionDefaultSolution.setVisible(true);
        this.actionDefaultSolution.setEnabled(true);
        this.menuSubmitOption.setVisible(false);
        this.rMenuItemSubmitAndPrint.setVisible(false);
        this.isPDA.setVisible(false);
        this.chkVerifyMode.setEnabled(false);
        this.chkWholeScan.setEnabled(false);
        this.menuBiz.setVisible(false);
        this.txtSrcAlias.setEnabled(false);
        this.txtNumber.setMaxLength(80);
        this.txtName.setMaxLength(80);
        this.txtDescription.setMaxLength(250);
        CtrlF7 ctrlF7 = new CtrlF7();
        ctrlF7.setIsCUFilter(false);
        ctrlF7.setContainSealUp(true);
        ctrlF7.setCumulate(false);
        ctrlF7.setPermissionItem("barcodeConfig_view");
        this.prmtCU.setSelector((KDPromptSelector)ctrlF7);
        OrgUnitFilterInfoProducer producer = new OrgUnitFilterInfoProducer((OrgF7PromptDialog)ctrlF7);
        this.prmtCU.setFilterInfoProducer((IFilterInfoProducer)producer);
        this.prmtDestEntity.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtDestEntity.setReadOnly(true);
        this.prmtDestEntity.setEditable(false);
        this.prmtDestEntity.setRequired(true);
        this.prmtDestEntity.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BarcodeConfigEditUI.this.prmtDestEntity_willShow(e);
                }
                catch (Exception e1) {
                    BarcodeConfigEditUI.this.handleException(e1);
                }
            }
        });
        this.prmtBotMapping.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                BarcodeConfigEditUI.this.prmtBotMapping_Changed(e);
            }
        });
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection coll = super.getSelectors();
        coll.add(new SelectorItemInfo("*"));
        return coll;
    }

    protected void prmtBotMapping_Changed(DataChangeEvent e) {
        BOTMappingInfo botMapping = (BOTMappingInfo)e.getNewValue();
        if (botMapping != null) {
            this.txtSrcAlias.setText(botMapping.getSrcEntityAlias());
            this.chkMatchBill.setEnabled(true);
            this.chkVerifyMode.setEnabled(false);
        } else {
            this.txtSrcAlias.setText(null);
            this.chkMatchBill.setEnabled(false);
            this.chkVerifyMode.setEnabled(true);
        }
    }

    protected void prmtDestEntity_willShow(SelectorEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", "bizbill");
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!ui.isCancel) {
            int flag = 0;
            if (this.kDTabbedPane1.getTabCount() > 0 && this.currEntity != null && !((EntityObjectInfo)ui.getReturnObject()).getType().equals((Object)this.currEntity.getType()) && (flag = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"86_BarcodeConfigEditUI"))) == 2) {
                return;
            }
            this.clearALL();
            this.currEntity = (EntityObjectInfo)ui.getReturnObject();
            this.prmtDestEntity.setText(this.currEntity.getAlias());
            this.destEntity_Changed();
        }
    }

    protected void destEntity_Changed() throws Exception {
        if (this.currEntity != null) {
            this.isPDA.setVisible(true);
            this.isPDA.setSelected(false);
            this.chkVerifyMode.setEnabled(false);
            this.chkWholeScan.setEnabled(false);
            this.prmtBotMapping.setEnabled(true);
            this.prmtBotMapping.setEntityViewInfo(this.buildBotpEV(null, null, this.currEntity.getType().toString()));
            this.loadDataDetails();
        } else {
            this.clearALL();
        }
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    protected void clearALL() {
        this.currEntity = null;
        this.prmtBotMapping.setValue(null);
        this.prmtBotMapping.setEnabled(false);
        this.prmtDestEntity.setValue(null);
        this.prmtDestEntity.setText(null);
        this.txtSrcAlias.setText(null);
        this.kDTabbedPane1.removeAll();
        this.isPDA.setVisible(false);
    }

    protected void loadDataDetails() throws Exception {
        this.kDTabbedPane1.removeAll();
        BarcodeConfigDetailsEditUI ui = new BarcodeConfigDetailsEditUI();
        ui.setParentUI(this);
        ui.init(this.currEntity, null, null, null);
    }

    protected void initUserConfig() {
        super.initUserConfig();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.prmtCU.getValue() == null) {
            this.prmtCU.setValue((Object)SysContext.getSysContext().getCurrentCtrlUnit());
        }
        if (this.editData.getDestBosType() != null) {
            this.currEntity = BarcodeUtils.getEntityByBosType(this.editData.getDestBosType());
            this.prmtDestEntity.setText(this.currEntity.getAlias());
        } else {
            this.currEntity = null;
            this.prmtDestEntity.setText(null);
        }
        try {
            this.destEntity_Changed();
            if (this.editData.getDetailsXML() != null) {
                BarcodeConfigXML xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(this.editData.getDetailsXML());
                for (int i = 0; i < xmlInfo.getDetails().size(); ++i) {
                    BarcodeConfigXMLDetail detail = xmlInfo.getDetails().get(i);
                    int index = this.kDTabbedPane1.indexOfTab(detail.getEntityAlias());
                    BarcodeConfigDetailsEditUI detailUi = (BarcodeConfigDetailsEditUI)((Object)this.kDTabbedPane1.getComponentAt(index));
                    detailUi.loadSelectedProperties(detail.getProperties());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
        this.isPDA.setSelected(this.editData.isIsPDA());
        if (this.prmtBotMapping.getValue() != null) {
            this.chkMatchBill.setEnabled(true);
        } else {
            this.chkMatchBill.setEnabled(false);
        }
    }

    protected void initDataStatus() {
        block6: {
            block7: {
                block5: {
                    super.initDataStatus();
                    if (this.editData != null && this.editData.getDestBosType() != null) {
                        this.currEntity = BarcodeUtils.getEntityByBosType(this.editData.getDestBosType());
                        this.prmtDestEntity.setText(this.currEntity.getAlias());
                    } else {
                        this.currEntity = null;
                        this.prmtDestEntity.setText(null);
                    }
                    if (!this.getOprtState().equals(OprtState.ADDNEW)) break block5;
                    this.prmtDestEntity.setEnabled(true);
                    for (int i = 0; i < this.kDTabbedPane1.getTabCount(); ++i) {
                        BarcodeConfigDetailsEditUI detailsUI = (BarcodeConfigDetailsEditUI)((Object)this.kDTabbedPane1.getComponentAt(i));
                        detailsUI.setEditable(true);
                    }
                    break block6;
                }
                if (!this.getOprtState().equals(OprtState.EDIT)) break block7;
                this.prmtDestEntity.setEnabled(true);
                for (int i = 0; i < this.kDTabbedPane1.getTabCount(); ++i) {
                    BarcodeConfigDetailsEditUI detailsUI = (BarcodeConfigDetailsEditUI)((Object)this.kDTabbedPane1.getComponentAt(i));
                    detailsUI.setEditable(true);
                }
                break block6;
            }
            if (!this.getOprtState().equals(OprtState.VIEW)) break block6;
            this.prmtDestEntity.setEnabled(false);
            for (int i = 0; i < this.kDTabbedPane1.getTabCount(); ++i) {
                BarcodeConfigDetailsEditUI detailsUI = (BarcodeConfigDetailsEditUI)((Object)this.kDTabbedPane1.getComponentAt(i));
                detailsUI.setEditable(false);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.prmtBotMapping.getValue() != null) {
            BOTMappingInfo bot = (BOTMappingInfo)this.prmtBotMapping.getValue();
            this.editData.setSrcBosType(bot.getSrcEntityName());
            this.editData.setSrcAlias(bot.getSrcEntityAlias());
        } else {
            this.editData.setSrcBosType(null);
            this.editData.setSrcAlias(null);
        }
        this.editData.setDestBosType(this.currEntity.getType().toString());
        this.editData.setDestAlias(this.currEntity.getAlias());
        this.editData.setDetailsXML(this.buildDetailsXML(this.editData));
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        StringBuffer errorMsg = new StringBuffer();
        String number = this.txtNumber.getText();
        String name = this.txtName.getText();
        if (number == null || "".equals(number.trim())) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"87_BarcodeConfigEditUI"));
        }
        if (name == null || "".equals(name.trim())) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"88_BarcodeConfigEditUI"));
        }
        if (this.prmtDestEntity.getText() == null || "".equals(this.prmtDestEntity.getText().trim())) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"89_BarcodeConfigEditUI"));
        }
        if (errorMsg.length() > 0) {
            MsgBox.showInfo((String)errorMsg.toString());
            SysUtil.abort();
        }
        this.txtNumber.setText(number.trim());
        this.editData.setNumber(number.trim());
        this.txtName.setText(name.trim());
        this.editData.setName(name.trim());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        BarcodePDAConfigXmlUntil.genPdaMainMenuByBarcodeConfig();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK orgPK = new ObjectUuidPK(((CtrlUnitInfo)this.prmtCU.getValue()).getId());
        DataBasePermissionUtil.chekcPermission(null, (IObjectPK)orgPK, "barcodeConfig_update");
        this.checkUsed();
        super.actionEdit_actionPerformed(e);
    }

    private void checkUsed() throws BOSException {
        String id = this.editData.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("scanConfig.id", (Object)id);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        BarcodePDAViewConfigCollection col = BarcodePDAViewConfigFactory.getRemoteInstance().getBarcodePDAViewConfigCollection(view);
        if (col != null && col.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"cannot_edit_config"));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    protected EntityViewInfo buildBotpEV(String botp, String srcBosType, String bosType) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (botp != null && !"".equals(botp.trim())) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)botp, CompareType.EQUALS));
        }
        if (srcBosType != null && !"".equals(srcBosType.trim())) {
            filter.getFilterItems().add(new FilterItemInfo("srcEntityName", (Object)srcBosType, CompareType.EQUALS));
        }
        if (bosType != null && !"".equals(bosType.trim())) {
            filter.getFilterItems().add(new FilterItemInfo("destEntityName", (Object)bosType, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("extRule.isEffected", (Object)true));
        ev.setFilter(filter);
        return ev;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        StringBuffer errorMsg = new StringBuffer();
        String number = this.txtNumber.getText();
        String name = this.txtName.getText();
        if (number == null || "".equals(number.trim())) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"87_BarcodeConfigEditUI"));
        }
        if (name == null || "".equals(name.trim())) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"88_BarcodeConfigEditUI"));
        }
        if (errorMsg.length() > 0) {
            MsgBox.showInfo((String)errorMsg.toString());
            SysUtil.abort();
        }
        this.txtNumber.setText(number.trim());
        this.editData.setNumber(number.trim());
        this.txtName.setText(name.trim());
        this.editData.setName(name.trim());
    }

    protected String buildDetailsXML(BarcodeConfigInfo info) {
        BarcodeConfigXML xmlInfo = null;
        xmlInfo = info.getDetailsXML() != null ? BarcodeXMLHelper.toBarcodeConfigXML(info.getDetailsXML()) : new BarcodeConfigXML();
        if (info.getBotMapping() != null) {
            BOTMappingInfo botInfo = info.getBotMapping();
            xmlInfo.setBotpId(botInfo.getId().toString());
            xmlInfo.setBotpName(botInfo.getName());
        }
        if (info.getCU() != null) {
            xmlInfo.setCu(info.getCU().getNumber());
        }
        xmlInfo.setDestAlias(info.getDestAlias());
        xmlInfo.setDestBosType(info.getDestBosType());
        xmlInfo.setName(info.getName());
        xmlInfo.setNumber(info.getNumber());
        xmlInfo.setSrcAlias(info.getSrcAlias());
        xmlInfo.setSrcBosType(info.getSrcBosType());
        xmlInfo.setDescription(info.getDescription());
        xmlInfo.getDetails().clear();
        for (int i = 0; i < this.kDTabbedPane1.getTabCount(); ++i) {
            BarcodeConfigDetailsEditUI detailsUI = (BarcodeConfigDetailsEditUI)((Object)this.kDTabbedPane1.getComponentAt(i));
            BarcodeConfigXMLDetail detail = detailsUI.getDetail();
            xmlInfo.addDetail(detail);
        }
        return BarcodeXMLHelper.barcodeConfigXMLToXML(xmlInfo);
    }

    protected IObjectValue createNewData() {
        this.clearALL();
        BarcodeConfigInfo info = new BarcodeConfigInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BarcodeConfigFactory.getRemoteInstance();
    }

    public KDTabbedPane getKDTabbedPane() {
        return this.kDTabbedPane1;
    }

    @Override
    public void actionDefaultSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"90_BarcodeConfigEditUI"));
            return;
        }
        if (this.currEntity == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"91_BarcodeConfigEditUI"));
            return;
        }
        ObjectUuidPK orgPK = new ObjectUuidPK(((CtrlUnitInfo)this.prmtCU.getValue()).getId());
        DataBasePermissionUtil.chekcPermission(null, (IObjectPK)orgPK, "barcodeConfig_defaultSolution");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"entity", (Object)this.currEntity);
        uiContext.put((Object)"config", (Object)this.editData);
        IUIWindow window = null;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        window = uiFactory.create(BarcodeDefaultUI.class.getName(), (Map)uiContext, null, "");
        window.show();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCU;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    @Override
    protected void chkVerifyMode_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkVerifyMode.isSelected()) {
            this.chkCompleteCheck.setEnabled(true);
        } else {
            this.chkCompleteCheck.setEnabled(false);
            this.chkCompleteCheck.setSelected(false);
        }
    }

    @Override
    protected void isPDA_stateChanged(ChangeEvent e) throws Exception {
        if (this.isPDA.isSelected()) {
            this.chkVerifyMode.setEnabled(true);
            this.chkWholeScan.setEnabled(true);
        } else {
            this.chkVerifyMode.setEnabled(false);
            this.chkWholeScan.setEnabled(false);
        }
    }
}

