/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAConfigXmlUntil;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.DataBasePermissionUtil;
import com.kingdee.eas.barcode.scm.OrgUnitUtils;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeConfigListUI;
import com.kingdee.eas.barcode.scm.client.BarcodeConfigEditUI;
import com.kingdee.eas.barcode.scm.client.BarcodePrintHelper;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class BarcodeConfigListUI
extends AbstractBarcodeConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodeConfigListUI.class);
    private String permissionCuStr = "";

    public BarcodeConfigListUI() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"85_BarcodeConfigEditUI"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return BarcodeConfigEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BarcodeConfigFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        OrgUnitCollection coll = OrgUnitUtils.getAuthOrgByPermItem(null, OrgType.ControlUnit, "barcodeConfig_view");
        this.permissionCuStr = OrgUnitUtils.toStringList(coll, "number");
        super.onLoad();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo mergfilter = new FilterInfo();
        mergfilter.getFilterItems().add(new FilterItemInfo("cu.number", (Object)this.permissionCuStr, CompareType.INCLUDE));
        try {
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(mergfilter);
            } else {
                viewInfo.getFilter().mergeFilter(mergfilter, "and");
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        IQueryExecutor exe = super.getQueryExecutor(queryPK, viewInfo);
        return exe;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        Map idm = BarcodePrintHelper.getSelectedIdsMap(this.tblMain, "id");
        StringBuffer ids = new StringBuffer();
        for (Map.Entry idEntry : idm.entrySet()) {
            String id = (String)idEntry.getKey();
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("scanConfig.id", (Object)id);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            BarcodePDAViewConfigCollection col = BarcodePDAViewConfigFactory.getRemoteInstance().getBarcodePDAViewConfigCollection(view);
            if (col == null || col.size() <= 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"cannot_del_config"));
            this.abort();
        }
        super.actionRemove_actionPerformed(e);
        BarcodePDAConfigXmlUntil.genPdaMainMenuByBarcodeConfig();
    }

    private IObjectPK getOrgId() throws BOSException, EASBizException {
        BarcodeConfigInfo info = BarcodeConfigFactory.getRemoteInstance().getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
        ObjectUuidPK orgId = new ObjectUuidPK(info.getCU().getId().toString());
        return orgId;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK orgId = this.getOrgId();
        DataBasePermissionUtil.chekcPermission(null, orgId, "barcodeConfig_update");
        KDTSelectBlock block = (KDTSelectBlock)this.tblMain.getSelectManager().getBlocks().get(0);
        IRow row = this.tblMain.getRow(block.getBeginRow());
        String id = (String)row.getCell("id").getValue();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("scanConfig.id", (Object)id);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        BarcodePDAViewConfigCollection col = BarcodePDAViewConfigFactory.getRemoteInstance().getBarcodePDAViewConfigCollection(view);
        if (col != null && col.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"cannot_edit_config"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }
}

