/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTextFieldUI;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.BarcodeImportTypeEnum;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeDataImport;
import com.kingdee.eas.basedata.assistant.AddressCollection;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.fa.manage.client.FaStockDataImportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.TextUI;
import org.apache.log4j.Logger;

public class BarcodeDataImport
extends AbstractBarcodeDataImport {
    private static final Logger logger = CoreUIObject.getLogger(FaStockDataImportUI.class);
    private KDFileChooser chooser;
    private Map<String, Object> barcodeMap = new HashMap<String, Object>();

    public Map<String, Object> getBarcodeMap() {
        return this.barcodeMap;
    }

    public void setBarcodeMap(Map<String, Object> barcodeMap) {
        this.barcodeMap = barcodeMap;
    }

    public BarcodeDataImport() throws Exception {
        this.chooser = new KDFileChooser();
        this.chooser.setFileFilter((FileFilter)new TxtFileFilter());
        this.chooser.setAcceptAllFileFilterUsed(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        KingdeeTextFieldUI ui = new KingdeeTextFieldUI((JComponent)this.txtFilePath){

            protected void paintBackground(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.tf.getWidth(), this.tf.getHeight());
            }
        };
        this.txtFilePath.setUI((TextUI)ui);
        this.txtFilePath.setEditable(false);
        this.cboNewAddOrOverImport.setSelectedItem((Object)BarcodeImportTypeEnum.ADDNEW_IMPORT);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOpenFile.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        this.btnConfirm.setEnabled(true);
        this.btnCancle.setEnabled(true);
        this.btnOpenFile.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.actionFileOpen.setEnabled(true);
    }

    @Override
    public void actionFileOpen_actionPerformed(ActionEvent e) throws Exception {
        int rVal = this.chooser.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            this.txtFilePath.setText(this.chooser.getSelectedFile().toString());
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilePath.getText();
        if (path == null || path.trim().length() == 0) {
            this.txtFilePath.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.client.IndubarcodeResource", (String)"select_file_first"));
            return;
        }
        if (!new File(path).exists()) {
            this.txtFilePath.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.client.IndubarcodeResource", (String)"file_not_found"));
            return;
        }
        this.checkFile(path);
        this.disposeUIWindow();
    }

    private boolean isCN(char ch, boolean withPreCN) {
        boolean b;
        boolean bl = b = ch >= '\u4e00' && ch <= '\u9fa5' || "\uff01\uff0c\u3002\uff1f\uff1a\u201c\u201d\u2018\u2019\uff0b\uff0d\u00d7\u00f7\u3001\u3010\u3011\u300e\u300f\uff5e".indexOf(ch) != -1;
        if (!b && withPreCN) {
            return ",.:;!?-_ \u3000".indexOf(ch) != -1;
        }
        return b;
    }

    private boolean verifyImport(String line) {
        String message = null;
        char[] numberChr = line.toCharArray();
        for (int i = 0; i < numberChr.length; ++i) {
            if (!this.isCN(numberChr[i], false)) continue;
            message = EASResource.getString((String)"com.kingdee.eas.barcode.scm.client.IndubarcodeResource", (String)"numberNoChanese");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFile(String path) {
        File file = new File(path.toString());
        BufferedReader br = null;
        FileInputStream reader = null;
        try {
            reader = new FileInputStream(file);
            br = new BufferedReader(new InputStreamReader((InputStream)reader, "UTF-8"));
            int lineNumber = 0;
            String line = br.readLine();
            if (line == null || line.equals("")) {
                String message = EASResource.getString((String)"com.kingdee.eas.barcode.scm.client.IndubarcodeResource", (String)"file_content_empty");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
            while (line != null) {
                if (line.trim().length() == 0) {
                    line = br.readLine();
                }
                if (!this.verifyImport(line)) {
                    SysUtil.abort();
                }
                line = br.readLine();
            }
            br.close();
            reader = new FileInputStream(file);
            br = new BufferedReader(new InputStreamReader((InputStream)reader, "UTF-8"));
            String[] temps = null;
            ArrayList<String> importBarCodeList = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                temps = line.split(",");
                for (int i = 0; i < temps.length; ++i) {
                    temps[i] = temps[i].replace("&#44;", ",");
                }
                this.importData(temps, importBarCodeList);
                importBarCodeList.add(temps[0]);
                ++lineNumber;
            }
            BarcodeImportTypeEnum cboSelectIndex = (BarcodeImportTypeEnum)((Object)this.cboNewAddOrOverImport.getSelectedItem());
            this.barcodeMap.put("barcodeList", importBarCodeList);
            this.barcodeMap.put("importType", cboSelectIndex.getValue());
            br.close();
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void clearZeroNoImportBarCode(List importBarCodeList) {
        KDTable kdtEntries = (KDTable)this.getUIContext().get("kdtEntries");
        BigDecimal zero = new BigDecimal("0");
        int n = kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = kdtEntries.getRow(i);
            String barCode = String.valueOf(row.getCell("barCode").getValue());
            if (importBarCodeList.indexOf(barCode) != -1) continue;
            row.getCell("stocktakingAmt").setValue((Object)zero);
            BigDecimal assetAmt = (BigDecimal)row.getCell("assetAmt").getValue();
            row.getCell("profitAmt").setValue((Object)zero.subtract(assetAmt));
        }
    }

    private void importData(String[] temps, List importBarCodeList) {
    }

    private void setRowAnyOthersValue(IRow row, String[] temps) {
        int useDeptInt;
        int usePersonInt;
        int adminDeptInt;
        int keepInt;
        int addInt;
        String address = "";
        if (null != row.getCell("address").getValue()) {
            address = row.getCell("address").getValue().toString();
        }
        int n = addInt = temps[9].indexOf("-") < 0 ? temps[9].length() : temps[9].indexOf("-");
        if (temps[9] == null || "".equals(temps[9])) {
            row.getCell("address").setValue(null);
        } else if (!address.equals(temps[9].substring(0, addInt))) {
            String addressNum = temps[9].indexOf("-") < 0 ? "" : temps[9].substring(addInt + 1);
            String addr = temps[9].indexOf("-") < 0 ? temps[9] : temps[9].substring(0, addInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (addressNum != null && !"".equals(addressNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)addressNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)addr, CompareType.EQUALS));
            }
            AddressCollection addCol = new AddressCollection();
            try {
                addCol = AddressFactory.getRemoteInstance().getAddressCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (addCol != null && addCol.size() > 0) {
                AddressInfo addrInfo = addCol.get(0);
                row.getCell("address").setValue((Object)addrInfo);
            } else {
                row.getCell("address").setValue(null);
            }
        }
        String keeper = "";
        if (null != row.getCell("keeper").getValue()) {
            keeper = row.getCell("keeper").getValue().toString();
        }
        int n2 = keepInt = temps[5].indexOf("-") < 0 ? temps[5].length() : temps[5].indexOf("-");
        if (temps[5] == null || "".equals(temps[5])) {
            row.getCell("keeper").setValue(null);
        } else if (!keeper.equals(temps[5].substring(0, keepInt))) {
            String keeperNum = temps[5].indexOf("-") < 0 ? "" : temps[5].substring(keepInt + 1);
            String keep = temps[5].indexOf("-") < 0 ? temps[5] : temps[5].substring(0, keepInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (keeperNum != null && !"".equals(keeperNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)keeperNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)keep, CompareType.EQUALS));
            }
            PersonCollection personCollection = new PersonCollection();
            try {
                personCollection = PersonFactory.getRemoteInstance().getPersonCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (personCollection != null && personCollection.size() > 0) {
                PersonInfo adminInfo = personCollection.get(0);
                row.getCell("keeper").setValue((Object)adminInfo);
            } else {
                row.getCell("keeper").setValue(null);
            }
        }
        String adminDept = "";
        if (null != row.getCell("adminDept").getValue()) {
            adminDept = row.getCell("adminDept").getValue().toString();
        }
        int n3 = adminDeptInt = temps[6].indexOf("-") < 0 ? temps[6].length() : temps[6].indexOf("-");
        if (temps[6] == null || "".equals(temps[6])) {
            row.getCell("adminDept").setValue(null);
        } else if (!adminDept.equals(temps[6].substring(0, adminDeptInt))) {
            String adminNum = temps[6].indexOf("-") < 0 ? "" : temps[6].substring(adminDeptInt + 1);
            String admin = temps[6].indexOf("-") < 0 ? temps[6] : temps[6].substring(0, adminDeptInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (adminNum != null && !"".equals(adminNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)adminNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)admin, CompareType.EQUALS));
            }
            AdminOrgUnitCollection adminCollection = new AdminOrgUnitCollection();
            try {
                adminCollection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (adminCollection != null && adminCollection.size() > 0) {
                AdminOrgUnitInfo adminInfo = adminCollection.get(0);
                row.getCell("adminDept").setValue((Object)adminInfo);
            } else {
                row.getCell("adminDept").setValue(null);
            }
        }
        String usePerson = "";
        if (null != row.getCell("usePerson").getValue()) {
            usePerson = row.getCell("usePerson").getValue().toString();
        }
        int n4 = usePersonInt = temps[7].indexOf("-") < 0 ? temps[7].length() : temps[7].indexOf("-");
        if (temps[7] == null || "".equals(temps[7])) {
            row.getCell("usePerson").setValue(null);
        } else if (!usePerson.equals(temps[7].substring(0, usePersonInt))) {
            String usePersonNum = temps[7].indexOf("-") < 0 ? "" : temps[7].substring(usePersonInt + 1);
            String use = temps[7].indexOf("-") < 0 ? temps[7] : temps[7].substring(0, usePersonInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (usePersonNum != null && !"".equals(usePersonNum) && !"null".equals(usePersonNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)usePersonNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)use, CompareType.EQUALS));
            }
            PersonCollection personCollection = new PersonCollection();
            try {
                personCollection = PersonFactory.getRemoteInstance().getPersonCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (personCollection != null && personCollection.size() > 0) {
                PersonInfo usePersonInfo = personCollection.get(0);
                row.getCell("usePerson").setValue((Object)usePersonInfo);
            } else {
                row.getCell("usePerson").setValue(null);
            }
        }
        String useDept = "";
        if (null != row.getCell("useDept").getValue()) {
            useDept = row.getCell("useDept").getValue().toString();
        }
        int n5 = useDeptInt = temps[8].indexOf("-") < 0 ? temps[8].length() : temps[8].indexOf("-");
        if (temps[8] == null || "".equals(temps[8])) {
            row.getCell("useDept").setValue(null);
        } else if (!useDept.equals(temps[8].substring(0, useDeptInt))) {
            String useDeptNum = temps[8].indexOf("-") < 0 ? "" : temps[8].substring(useDeptInt + 1);
            String uDept = temps[8].indexOf("-") < 0 ? temps[8] : temps[8].substring(0, useDeptInt);
            EntityViewInfo v = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            v.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            if (useDeptNum != null && !"".equals(useDeptNum) && !"null".equals(useDeptNum)) {
                f.getFilterItems().add(new FilterItemInfo("number", (Object)useDeptNum, CompareType.EQUALS));
            } else {
                f.getFilterItems().add(new FilterItemInfo("name", (Object)uDept, CompareType.EQUALS));
            }
            AdminOrgUnitCollection adminCollection = new AdminOrgUnitCollection();
            try {
                adminCollection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(v);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (adminCollection != null && adminCollection.size() > 0) {
                AdminOrgUnitInfo useDeptInfo = adminCollection.get(0);
                row.getCell("useDept").setValue((Object)useDeptInfo);
            } else {
                row.getCell("useDept").setValue(null);
            }
        }
    }

    private void setEditableRow(String oprtState) {
        KDTable kdtEntries = (KDTable)this.getUIContext().get("kdtEntries");
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            int profitIndex = kdtEntries.getColumnIndex("profitAmt");
            int assetNumIndex = kdtEntries.getColumnIndex("assetNum");
            int stocktakingAmtIndex = kdtEntries.getColumnIndex("assetAmt");
            for (int i = 0; i < kdtEntries.getRowCount(); ++i) {
                IRow row = kdtEntries.getRow(i);
                if (row.getCell("facurcard.id").getValue() != null && row.getCell("facurcard.id").getValue().toString().trim().length() != 0) continue;
                for (int j = 0; j < kdtEntries.getColumnCount(); ++j) {
                    if (profitIndex == j || assetNumIndex == j || stocktakingAmtIndex == j) continue;
                    row.getCell(j).getStyleAttributes().setLocked(false);
                }
            }
        } else {
            kdtEntries.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setVisible(false);
        this.disposeUIWindow();
    }

    private static class TxtFileFilter
    extends FileFilter {
        private TxtFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = f.getName();
            ext = ext.lastIndexOf(".") > 0 ? ext.substring(ext.lastIndexOf(".") + 1, ext.length()) : null;
            if (ext != null) {
                return (ext = ext.toLowerCase(Locale.ENGLISH)).compareTo("txt") == 0;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "text(.txt)";
        }
    }
}

